/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing;

import configurationslicing.Messages;
import configurationslicing.Slice;
import configurationslicing.Slicer;
import configurationslicing.SlicerLoader;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ManagementLink;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.security.Permission;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class ConfigurationSlicing
extends ManagementLink {
    private static final Logger LOGGER = Logger.getLogger(ConfigurationSlicing.class.getName());

    public String getDescription() {
        return Messages.configurationSlicing_description();
    }

    public String getIconFileName() {
        return "orange-square.png";
    }

    public String getUrlName() {
        return "slicing";
    }

    public String getDisplayName() {
        return Messages.configurationSlicing_displayName();
    }

    public String getCategoryName() {
        return "TOOLS";
    }

    public Permission getRequiredPermission() {
        return Jenkins.ADMINISTER;
    }

    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.CONFIGURATION;
    }

    public List<Slicer> getAxes() {
        ExtensionList elist = Jenkins.get().getExtensionList(Slicer.class);
        ArrayList<Slicer> list = new ArrayList<Slicer>();
        for (Slicer slicer : elist) {
            if (slicer.isLoaded()) {
                if (slicer instanceof SlicerLoader) {
                    SlicerLoader loader = (SlicerLoader)slicer;
                    slicer = loader.getDelegate();
                }
                list.add(slicer);
                LOGGER.fine("Loaded: " + String.valueOf(slicer.getClass()));
                continue;
            }
            LOGGER.warning("NOT Loaded: " + String.valueOf(slicer.getClass()));
        }
        Collections.sort(list);
        return list;
    }

    public Collection<String> getViews() {
        Collection views = Jenkins.get().getViews();
        ArrayList<String> names = new ArrayList<String>();
        this.addViews(null, views, names);
        Collections.sort(names, String.CASE_INSENSITIVE_ORDER);
        return names;
    }

    private void addViews(String baseName, Collection<View> views, List<String> names) {
        for (View view : views) {
            Object name = view.getDisplayName();
            if (baseName != null) {
                name = baseName + "/" + (String)name;
            }
            if (view instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)view;
                Collection subviews = group.getViews();
                this.addViews((String)name, subviews, names);
                continue;
            }
            names.add((String)name);
        }
    }

    public Object getDynamic(String token, StaplerRequest2 req, StaplerResponse2 rsp) {
        Jenkins.get().checkPermission(Hudson.ADMINISTER);
        for (Slicer s : this.getAxes()) {
            if (!s.getUrl().equals(token)) continue;
            return new SliceExecutor(s, null);
        }
        return null;
    }

    public class SliceExecutor<T extends Slice, I> {
        Slicer<T, I> slicer;
        List<I> worklist;
        List<I> changed;
        T slice;
        View view;

        public SliceExecutor(Slicer<T, I> s, View view) {
            this.slicer = s;
            this.view = view;
            this.execute();
        }

        private void execute() {
            Slice accumulator = (Slice)this.slicer.getInitialAccumulator();
            this.worklist = this.slicer.getWorkDomain();
            Collection items = null;
            if (this.view != null) {
                items = this.view.getItems();
            }
            for (I item : this.worklist) {
                if (items != null && !items.contains(item)) continue;
                accumulator = this.slicer.accumulate(accumulator, item);
            }
            this.slice = accumulator;
        }

        private List<I> transform(T newslice) {
            ArrayList<I> ret = new ArrayList<I>();
            this.worklist = this.slicer.getWorkDomain();
            for (I item : this.worklist) {
                if (!this.slicer.transform(newslice, item)) continue;
                ret.add(item);
            }
            return ret;
        }

        public ConfigurationSlicing getParent() {
            return ConfigurationSlicing.this;
        }

        public T getSlice() {
            return this.slice;
        }

        public Slicer<T, I> getSlicer() {
            return this.slicer;
        }

        public List<I> getChanged() {
            return this.changed;
        }

        public String getViewDisplayPart() {
            if (this.view == null) {
                return "";
            }
            Object part = this.view.getDisplayName();
            ViewGroup owner = this.view.getOwner();
            while (owner instanceof View) {
                View parentView = (View)owner;
                part = parentView.getDisplayName() + " / " + (String)part;
                owner = parentView.getOwner();
            }
            part = " > " + (String)part;
            return part;
        }

        public List<I> getWorklist() {
            return this.worklist;
        }

        @RequirePOST
        public void doSliceconfigSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
            String pathInfo = req.getPathInfo();
            try {
                Slice newslice = ((Slice)this.slice).newInstance(req, req.getSubmittedForm());
                this.transform(newslice);
                this.slice = newslice;
                String redirect = this.getRedirectPath(pathInfo);
                rsp.sendRedirect2(redirect);
            }
            catch (Descriptor.FormException e) {
                e.printStackTrace();
            }
        }

        private String getRedirectPath(String pathInfo) {
            String urlPart = "slicing/" + this.slicer.getUrl() + "/view/";
            if (pathInfo.contains(urlPart)) {
                return "../..";
            }
            return "..";
        }

        public Object getDynamic(String token, StaplerRequest2 req, StaplerResponse2 rsp) {
            Jenkins.get().checkPermission(Hudson.ADMINISTER);
            String viewName = req.getParameter("view");
            View view = null;
            if (viewName != null) {
                view = this.getView(viewName);
            }
            return new SliceExecutor<T, I>(this.slicer, view);
        }

        private View getView(String token) {
            String[] split = token.split("/");
            View view = null;
            for (String name : split) {
                if (view instanceof ViewGroup) {
                    ViewGroup group = (ViewGroup)view;
                    view = group.getView(name);
                    continue;
                }
                view = Jenkins.get().getView(name);
            }
            return view;
        }
    }
}

