/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.logstash;

import configurationslicing.BooleanSlicer;
import configurationslicing.TopLevelItemSelector;
import hudson.Extension;
import hudson.Util;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.tasks.BuildWrapper;
import hudson.util.DescribableList;
import java.util.Collection;
import java.util.List;
import jenkins.plugins.logstash.LogstashBuildWrapper;

@Extension(optional=true)
public class LogStashSlicer
extends BooleanSlicer<AbstractProject> {
    public LogStashSlicer() {
        super(new LogstashSpec());
    }

    @Override
    public boolean isLoaded() {
        try {
            new LogstashBuildWrapper();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static class LogstashSpec
    implements BooleanSlicer.BooleanSlicerSpec<AbstractProject> {
        @Override
        public String getName() {
            return "Logstash Slicer";
        }

        @Override
        public String getUrl() {
            return "logstash";
        }

        @Override
        public List<AbstractProject> getWorkDomain() {
            return TopLevelItemSelector.getAllTopLevelItems(AbstractProject.class);
        }

        @Override
        public boolean getValue(AbstractProject item) {
            DescribableList<BuildWrapper, Descriptor<BuildWrapper>> buildWrappersList = this.getBuildWrappers(item);
            if (buildWrappersList == null) {
                return false;
            }
            return !buildWrappersList.getAll(LogstashBuildWrapper.class).isEmpty();
        }

        private DescribableList<BuildWrapper, Descriptor<BuildWrapper>> getBuildWrappers(AbstractProject item) {
            if (item instanceof Project) {
                Project project = (Project)item;
                return project.getBuildWrappersList();
            }
            if (item instanceof MavenModuleSet) {
                MavenModuleSet set = (MavenModuleSet)item;
                return set.getBuildWrappersList();
            }
            return null;
        }

        @Override
        public String getName(AbstractProject item) {
            return item.getName();
        }

        @Override
        public boolean setValue(AbstractProject item, boolean value) {
            LogstashBuildWrapper logstashWrapper = new LogstashBuildWrapper();
            if (item instanceof Project) {
                Project project = (Project)item;
                DescribableList bwList = project.getBuildWrappersList();
                List lsList = Util.filter((List)bwList, LogstashBuildWrapper.class);
                if (lsList.isEmpty() != value) {
                    return false;
                }
                if (value) {
                    bwList.add((Object)new LogstashBuildWrapper());
                } else {
                    bwList.removeAll((Collection)lsList);
                }
                return true;
            }
            if (item instanceof MavenModuleSet) {
                MavenModuleSet set = (MavenModuleSet)item;
                DescribableList bwList = set.getBuildWrappersList();
                List lsList = Util.filter((List)bwList, LogstashBuildWrapper.class);
                if (lsList.isEmpty() != value) {
                    return false;
                }
                if (value) {
                    bwList.add((Object)new LogstashBuildWrapper());
                } else {
                    bwList.removeAll((Collection)lsList);
                }
                return true;
            }
            return false;
        }
    }
}

