/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing;

import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

public class AbstractJob {
    private Job item;

    public AbstractJob(Job item) {
        this.item = item;
    }

    public static AbstractJob fix(Job item) {
        return new AbstractJob(item);
    }

    public boolean isConcurrentBuilds() {
        Job job = this.item;
        if (job instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)job;
            return project.isConcurrentBuild();
        }
        job = this.item;
        if (job instanceof WorkflowJob) {
            WorkflowJob job2 = (WorkflowJob)job;
            return job2.isConcurrentBuild();
        }
        return true;
    }

    public void makeConcurrentBuilds(boolean value) throws IOException {
        Job job = this.item;
        if (job instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)job;
            project.setConcurrentBuild(value);
        }
        if ((job = this.item) instanceof WorkflowJob) {
            WorkflowJob job2 = (WorkflowJob)job;
            job2.setConcurrentBuild(value);
        }
        throw new IOException("Unsupported job type");
    }

    public <T extends Trigger> T getTrigger(Class<T> clazz) {
        Job job = this.item;
        if (job instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)job;
            return (T)project.getTrigger(clazz);
        }
        job = this.item;
        if (job instanceof WorkflowJob) {
            WorkflowJob job2 = (WorkflowJob)job;
            return this.getTrigger(job2, clazz);
        }
        return null;
    }

    public void removeTrigger(TriggerDescriptor trigger) throws IOException {
        Job job = this.item;
        if (job instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)job;
            project.removeTrigger(trigger);
        }
        if ((job = this.item) instanceof WorkflowJob) {
            WorkflowJob job2 = (WorkflowJob)job;
            this.removeTrigger(job2, trigger);
        }
    }

    public void addTrigger(Trigger<?> trigger) throws IOException {
        Job job = this.item;
        if (job instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)job;
            project.addTrigger(trigger);
        }
        if ((job = this.item) instanceof WorkflowJob) {
            WorkflowJob job2 = (WorkflowJob)job;
            job2.addTrigger(trigger);
        }
    }

    private <T extends Trigger> T getTrigger(WorkflowJob pipeline, Class<T> clazz) {
        for (Trigger p : pipeline.getTriggersJobProperty().getTriggers()) {
            if (!clazz.isInstance(p)) continue;
            return (T)((Trigger)clazz.cast(p));
        }
        return null;
    }

    private void removeTrigger(WorkflowJob pipeline, TriggerDescriptor triggerDescriptor) {
        Trigger trigger = (Trigger)pipeline.getTriggers().get(triggerDescriptor);
        if (trigger != null) {
            pipeline.getTriggersJobProperty().removeTrigger(trigger);
        }
    }
}

