/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.conditionalbuildstep;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.DependencyDeclarer;
import net.sf.json.JSONObject;
import org.jenkins_ci.plugins.run_condition.BuildStepRunner;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.jenkinsci.plugins.conditionalbuildstep.BuilderChain;
import org.jenkinsci.plugins.conditionalbuildstep.LegacyBuildstepCondition;
import org.jenkinsci.plugins.conditionalbuildstep.Messages;
import org.jenkinsci.plugins.conditionalbuildstep.dependency.ConditionalDependencyGraphWrapper;
import org.jenkinsci.plugins.conditionalbuildstep.singlestep.SingleConditionalBuilder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class ConditionalBuilder
extends Builder
implements DependencyDeclarer {
    private static Logger log = Logger.getLogger(ConditionalBuilder.class.getName());
    private transient String condition;
    private transient boolean invertCondition;
    private final BuildStepRunner runner;
    private RunCondition runCondition;
    private List<BuildStep> conditionalbuilders;

    @Deprecated
    public ConditionalBuilder(RunCondition runCondition, BuildStepRunner runner) {
        this(runCondition, runner, new ArrayList<BuildStep>());
    }

    @DataBoundConstructor
    public ConditionalBuilder(RunCondition runCondition, BuildStepRunner runner, List<BuildStep> conditionalbuilders) {
        this.runner = runner;
        this.runCondition = runCondition;
        this.conditionalbuilders = conditionalbuilders;
    }

    public BuildStepRunner getRunner() {
        return this.runner;
    }

    public RunCondition getRunCondition() {
        return this.runCondition;
    }

    public Collection getProjectActions(AbstractProject<?, ?> project) {
        ArrayList projectActions = new ArrayList();
        for (BuildStep buildStep : this.getConditionalbuilders()) {
            projectActions.addAll(buildStep.getProjectActions(project));
        }
        return projectActions;
    }

    public List<BuildStep> getConditionalbuilders() {
        if (this.conditionalbuilders == null) {
            this.conditionalbuilders = new ArrayList<BuildStep>();
        }
        return this.conditionalbuilders;
    }

    @Deprecated
    public void setConditionalbuilders(List<BuildStep> conditionalbuilders) {
        this.conditionalbuilders = conditionalbuilders;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return this.runner.prebuild(this.runCondition, (BuildStep)new BuilderChain(this.getConditionalbuilders()), build, listener);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return this.runner.perform(this.runCondition, (BuildStep)new BuilderChain(this.getConditionalbuilders()), build, launcher, listener);
    }

    public Object readResolve() {
        if (this.condition != null) {
            this.runCondition = new LegacyBuildstepCondition(this.condition, this.invertCondition);
        }
        return this;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public void buildDependencyGraph(AbstractProject project, DependencyGraph graph) {
        for (BuildStep builder : this.getConditionalbuilders()) {
            if (!(builder instanceof DependencyDeclarer)) continue;
            ((DependencyDeclarer)builder).buildDependencyGraph(project, (DependencyGraph)new ConditionalDependencyGraphWrapper(graph, this.runCondition, this.runner));
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return !"hudson.plugins.promoted_builds.PromotionProcess".equals(aClass.getCanonicalName());
        }

        public String getDisplayName() {
            return Messages.multistepbuilder_displayName();
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public List<? extends Descriptor<? extends BuildStep>> getBuilderDescriptors(AbstractProject<?, ?> project) {
            SingleConditionalBuilder.SingleConditionalBuilderDescriptor singleConditionalStepDescriptor = (SingleConditionalBuilder.SingleConditionalBuilderDescriptor)Hudson.getInstance().getDescriptorByType(SingleConditionalBuilder.SingleConditionalBuilderDescriptor.class);
            return singleConditionalStepDescriptor.getAllowedBuilders(project);
        }

        public DescriptorExtensionList<BuildStepRunner, BuildStepRunner.BuildStepRunnerDescriptor> getBuildStepRunners() {
            return BuildStepRunner.all();
        }

        public List<? extends Descriptor<? extends RunCondition>> getRunConditions() {
            return RunCondition.all();
        }
    }
}

