/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.conditionalbuildstep.dependency;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.NullStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkins_ci.plugins.run_condition.BuildStepRunner;
import org.jenkins_ci.plugins.run_condition.RunCondition;

public class ConditionalDependencyWrapper
extends DependencyGraph.Dependency {
    private static Logger LOGGER = Logger.getLogger(ConditionalDependencyWrapper.class.getName());
    private DependencyGraph.Dependency dep;
    private RunCondition condition;
    private BuildStepRunner runner;

    public ConditionalDependencyWrapper(DependencyGraph.Dependency dep, RunCondition condition, BuildStepRunner runner) {
        super(dep.getUpstreamProject(), dep.getDownstreamProject());
        this.dep = dep;
        this.condition = condition;
        this.runner = runner;
    }

    public boolean shouldTriggerBuild(AbstractBuild build, TaskListener listener, List<Action> actions) {
        BuildListener buildListener = null;
        if (listener instanceof BuildListener) {
            buildListener = (BuildListener)listener;
        } else {
            LOGGER.warning("There is no BuildListener, and logs from RunCondition won't be recorded.");
            buildListener = new StreamBuildListener((OutputStream)new NullStream());
        }
        try {
            MarkPerformedBuilder marker = new MarkPerformedBuilder();
            Launcher launcher = null;
            this.runner.perform(this.condition, (BuildStep)marker, build, launcher, buildListener);
            if (marker.isPerformed()) {
                return this.dep.shouldTriggerBuild(build, listener, actions);
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to evaluate condition", e);
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ConditionalDependencyWrapper d = (ConditionalDependencyWrapper)((Object)obj);
        return this.dep.equals((Object)d.dep) && this.condition.equals(d.condition);
    }

    public int hashCode() {
        return this.dep.hashCode() * 23 + this.condition.hashCode();
    }

    public AbstractProject getDownstreamProject() {
        return this.dep.getDownstreamProject();
    }

    public AbstractProject getUpstreamProject() {
        return this.dep.getUpstreamProject();
    }

    public boolean pointsItself() {
        return this.dep.pointsItself();
    }

    private static class MarkPerformedBuilder
    extends Builder {
        private boolean performed = false;
        private static final Descriptor<Builder> DESCRIPTOR = new BuildStepDescriptor<Builder>(){

            public boolean isApplicable(Class<? extends AbstractProject> jobType) {
                return true;
            }

            public String getDisplayName() {
                return "Builder to mark whether executed";
            }
        };

        private MarkPerformedBuilder() {
        }

        public boolean isPerformed() {
            return this.performed;
        }

        public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
            this.performed = true;
            return true;
        }

        public Descriptor<Builder> getDescriptor() {
            return DESCRIPTOR;
        }
    }
}

