/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.conditionalbuildstep;

import hudson.Plugin;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractProject;
import hudson.model.Project;
import hudson.tasks.BuildStep;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.conditionalbuildstep.ConditionalBuilder;
import org.jenkinsci.plugins.conditionalbuildstep.singlestep.SingleConditionalBuilder;

public class ConditionalBuildStepHelper {
    private ConditionalBuildStepHelper() {
    }

    public static <T extends BuildStep> List<T> getContainedBuilders(Project<?, ?> p, Class<T> type) {
        return ConditionalBuildStepHelper.getContainedBuilders(p, type);
    }

    public static <T extends BuildStep> List<T> getContainedBuilders(AbstractProject<?, ?> ap, Class<T> type) {
        boolean mavenIsInstalled = ConditionalBuildStepHelper.isMavenPluginInstalled();
        ArrayList<BuildStep> r = new ArrayList<BuildStep>();
        ArrayList<ConditionalBuilder> cbuilders = new ArrayList<ConditionalBuilder>();
        ArrayList<SingleConditionalBuilder> scbuilders = new ArrayList<SingleConditionalBuilder>();
        if (Project.class.isAssignableFrom(ap.getClass())) {
            Project p = (Project)ap;
            cbuilders.addAll(p.getBuildersList().getAll(ConditionalBuilder.class));
            scbuilders.addAll(p.getBuildersList().getAll(SingleConditionalBuilder.class));
        } else if (mavenIsInstalled) {
            cbuilders.addAll(ConditionalBuildStepHelper.getConditionalBuildersFromMavenProject(ap));
            scbuilders.addAll(ConditionalBuildStepHelper.getSingleConditionalBuildersFromMavenProject(ap));
        }
        for (ConditionalBuilder conditionalBuilder : cbuilders) {
            List<BuildStep> cbs = conditionalBuilder.getConditionalbuilders();
            for (BuildStep buildStep : cbs) {
                if (!type.isInstance(buildStep)) continue;
                r.add((BuildStep)type.cast(buildStep));
            }
        }
        for (SingleConditionalBuilder singleConditionalBuilder : scbuilders) {
            BuildStep buildStep = singleConditionalBuilder.getBuildStep();
            if (buildStep == null || !type.isInstance(buildStep)) continue;
            r.add((BuildStep)type.cast(buildStep));
        }
        return r;
    }

    private static List<ConditionalBuilder> getConditionalBuildersFromMavenProject(AbstractProject<?, ?> ap) {
        ArrayList<ConditionalBuilder> r = new ArrayList<ConditionalBuilder>();
        if (MavenModuleSet.class.isAssignableFrom(ap.getClass())) {
            MavenModuleSet ms = (MavenModuleSet)ap;
            r.addAll(ms.getPostbuilders().getAll(ConditionalBuilder.class));
            r.addAll(ms.getPrebuilders().getAll(ConditionalBuilder.class));
        }
        return r;
    }

    private static List<SingleConditionalBuilder> getSingleConditionalBuildersFromMavenProject(AbstractProject<?, ?> ap) {
        ArrayList<SingleConditionalBuilder> r = new ArrayList<SingleConditionalBuilder>();
        if (MavenModuleSet.class.isAssignableFrom(ap.getClass())) {
            MavenModuleSet ms = (MavenModuleSet)ap;
            r.addAll(ms.getPostbuilders().getAll(SingleConditionalBuilder.class));
            r.addAll(ms.getPrebuilders().getAll(SingleConditionalBuilder.class));
        }
        return r;
    }

    public static boolean isMavenPluginInstalled() {
        Jenkins j = Jenkins.getInstance();
        if (j != null) {
            Plugin plugin = j.getPlugin("maven-plugin");
            return plugin != null ? plugin.getWrapper().isActive() : false;
        }
        return false;
    }
}

