/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.ComputerSet;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import hudson.util.FormValidation;
import hudson.util.ProcessTree;
import hudson.util.StreamCopyThread;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.command_launcher.Messages;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.UnapprovedUsageException;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.SystemCommandLanguage;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

public class CommandLauncher
extends ComputerLauncher {
    private final String agentCommand;
    private final EnvVars env;
    private static final Logger LOGGER = Logger.getLogger(CommandLauncher.class.getName());

    @DataBoundConstructor
    public CommandLauncher(String command) throws Descriptor.FormException {
        this.checkSandbox();
        this.agentCommand = command;
        this.env = null;
        ScriptApproval.get().configuring(command, SystemCommandLanguage.get(), ApprovalContext.create().withCurrentUser(), Stapler.getCurrentRequest2() == null);
    }

    public CommandLauncher(String command, EnvVars env) {
        this.agentCommand = command;
        this.env = env;
        ScriptApproval.get().preapprove(command, SystemCommandLanguage.get());
    }

    CommandLauncher(EnvVars env, String command) {
        this.agentCommand = command;
        this.env = env;
    }

    private void checkSandbox() throws Descriptor.FormException {
        if (ScriptApproval.get().isForceSandboxForCurrentUser()) {
            throw new Descriptor.FormException("This Launch Method requires scripts executions out of the sandbox. This Jenkins instance has been configured to not allow regular users to disable the sandbox", "command");
        }
    }

    private Object readResolve() {
        ScriptApproval.get().configuring(this.agentCommand, SystemCommandLanguage.get(), ApprovalContext.create(), true);
        return this;
    }

    public String getCommand() {
        return this.agentCommand;
    }

    private static String getTimestamp() {
        return String.format("[%1$tD %1$tT]", new Date());
    }

    public void launch(SlaveComputer computer, final TaskListener listener) {
        block11: {
            EnvVars _cookie = null;
            Process _proc = null;
            try {
                Slave node = computer.getNode();
                if (node == null) {
                    throw new AbortException("Cannot launch commands on deleted nodes");
                }
                listener.getLogger().println(Messages.Slave_Launching(CommandLauncher.getTimestamp()));
                String command = ScriptApproval.get().using(this.getCommand(), SystemCommandLanguage.get());
                if (command.trim().length() == 0) {
                    listener.getLogger().println(Messages.CommandLauncher_NoLaunchCommand());
                    return;
                }
                listener.getLogger().println("$ " + command);
                ProcessBuilder pb = new ProcessBuilder(Util.tokenize((String)command));
                final EnvVars cookie = _cookie = EnvVars.createCookie();
                pb.environment().putAll((Map<String, String>)cookie);
                pb.environment().put("WORKSPACE", StringUtils.defaultString((String)computer.getAbsoluteRemoteFs(), (String)node.getRemoteFS()));
                pb.environment().put("NODE_NAME", computer.getName());
                String rootUrl = Jenkins.getInstance().getRootUrl();
                if (rootUrl != null) {
                    pb.environment().put("HUDSON_URL", rootUrl);
                    pb.environment().put("JENKINS_URL", rootUrl);
                    pb.environment().put("SLAVEJAR_URL", rootUrl + "/jnlpJars/agent.jar");
                    pb.environment().put("AGENTJAR_URL", rootUrl + "/jnlpJars/agent.jar");
                }
                if (this.env != null) {
                    pb.environment().putAll((Map<String, String>)this.env);
                }
                final Process proc = _proc = pb.start();
                new StreamCopyThread("stderr copier for remote agent on " + computer.getDisplayName(), proc.getErrorStream(), (OutputStream)listener.getLogger()).start();
                computer.setChannel(proc.getInputStream(), proc.getOutputStream(), (OutputStream)listener.getLogger(), new Channel.Listener(this){
                    final /* synthetic */ CommandLauncher this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void onClosed(Channel channel, IOException cause) {
                        CommandLauncher.reportProcessTerminated(proc, listener);
                        try {
                            ProcessTree.get().killAll(proc, (Map)cookie);
                        }
                        catch (InterruptedException e) {
                            LOGGER.log(Level.INFO, "interrupted", e);
                        }
                    }
                });
                LOGGER.info("agent launched for " + computer.getDisplayName());
            }
            catch (InterruptedException e) {
                Functions.printStackTrace((Throwable)e, (PrintWriter)listener.error(Messages.CommandLauncher_abortedLaunch()));
            }
            catch (UnapprovedUsageException e) {
                listener.error(e.getMessage());
            }
            catch (Error | RuntimeException e) {
                Functions.printStackTrace((Throwable)e, (PrintWriter)listener.error(Messages.CommandLauncher_unexpectedError()));
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                Object msg = Util.getWin32ErrorMessage((IOException)e);
                msg = msg == null ? "" : " : " + (String)msg;
                msg = Messages.Slave_UnableToLaunch(computer.getDisplayName(), msg);
                LOGGER.log(Level.SEVERE, (String)msg, e);
                Functions.printStackTrace((Throwable)e, (PrintWriter)listener.error((String)msg));
                if (_proc == null) break block11;
                CommandLauncher.reportProcessTerminated(_proc, listener);
                try {
                    ProcessTree.get().killAll(_proc, (Map)_cookie);
                }
                catch (InterruptedException x) {
                    Functions.printStackTrace((Throwable)x, (PrintWriter)listener.error(Messages.CommandLauncher_abortedLaunch()));
                }
            }
        }
    }

    private static void reportProcessTerminated(Process proc, TaskListener listener) {
        try {
            int exitCode = proc.exitValue();
            listener.error("Process terminated with exit code " + exitCode);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    @Extension
    public static class DescriptorVisibilityFilterForceSandBox
    extends DescriptorVisibilityFilter {
        public boolean filter(@CheckForNull Object context, @NonNull Descriptor descriptor) {
            if (descriptor instanceof DescriptorImpl) {
                return !ScriptApproval.get().isForceSandboxForCurrentUser() || context instanceof Slave && ((Slave)context).getLauncher() instanceof CommandLauncher;
            }
            return true;
        }

        public boolean filterType(@NonNull Class<?> contextClass, @NonNull Descriptor descriptor) {
            if (descriptor instanceof DescriptorImpl) {
                return !this.isCreatingNewObject() || !ScriptApproval.get().isForceSandboxForCurrentUser();
            }
            return true;
        }

        private boolean isCreatingNewObject() {
            StaplerRequest2 req = Stapler.getCurrentRequest2();
            if (req != null) {
                List ancs = req.getAncestors();
                for (Ancestor anc : ancs) {
                    String uri;
                    if (!(anc.getObject() instanceof ComputerSet) || !(uri = req.getOriginalRequestURI()).endsWith("createItem")) continue;
                    return true;
                }
            }
            return false;
        }
    }

    @Extension
    @Symbol(value={"command"})
    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        public ComputerLauncher newInstance(@Nullable StaplerRequest2 req, @NonNull JSONObject formData) throws Descriptor.FormException {
            CommandLauncher instance = (CommandLauncher)super.newInstance(req, formData);
            if (formData.get("oldCommand") != null) {
                boolean approveIfAdmin;
                String oldCommand = formData.getString("oldCommand");
                boolean bl = approveIfAdmin = !StringUtils.equals((String)oldCommand, (String)instance.agentCommand);
                if (approveIfAdmin) {
                    ScriptApproval.get().configuring(instance.agentCommand, SystemCommandLanguage.get(), ApprovalContext.create().withCurrentUser(), true);
                }
            }
            return instance;
        }

        public String getDisplayName() {
            return Messages.CommandLauncher_displayName();
        }

        public FormValidation doCheckCommand(@QueryParameter String value, @QueryParameter String oldCommand) {
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)Messages.CommandLauncher_NoLaunchCommand());
            }
            return ScriptApproval.get().checking(value, SystemCommandLanguage.get(), !StringUtils.equals((String)value, (String)oldCommand));
        }
    }
}

