/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.collapsingconsolesections;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;

public class SectionDefinition
implements Serializable {
    private String name;
    private Pattern start;
    private Pattern end;
    private boolean collapseOnlyOneLevel;
    private boolean collapseSection;

    @Deprecated
    public SectionDefinition(String sectionName, String sectionStartPattern, String sectionEndPattern) {
        this(sectionName, sectionStartPattern, sectionEndPattern, false, false);
    }

    @Deprecated
    public SectionDefinition(String sectionName, String sectionStartPattern, String sectionEndPattern, boolean collapseOnlyOneLevel) {
        this(sectionName, sectionStartPattern, sectionEndPattern, collapseOnlyOneLevel, false);
    }

    public SectionDefinition(@Nonnull String sectionName, @Nonnull String sectionStartPattern, @Nonnull String sectionEndPattern, boolean collapseOnlyOneLevel, boolean collapseSection) throws PatternSyntaxException {
        this.name = sectionName;
        this.start = Pattern.compile(sectionStartPattern);
        this.end = Pattern.compile(sectionEndPattern);
        this.collapseOnlyOneLevel = collapseOnlyOneLevel;
        this.collapseSection = collapseSection;
    }

    @Nonnull
    public String getSectionDisplayName() {
        return this.name;
    }

    @Nonnull
    public String getSectionDisplayName(@Nonnull Matcher m) {
        String result = this.name;
        if (m.matches()) {
            for (int i = 0; i <= m.groupCount(); ++i) {
                String group = m.group(i);
                result = group != null ? result.replaceAll("\\{" + i + "\\}", group) : result.replaceAll("\\{" + i + "\\}", "");
            }
        }
        return result;
    }

    @Nonnull
    public Pattern getSectionStartPattern() {
        return this.start;
    }

    @Nonnull
    public Pattern getSectionEndPattern() {
        return this.end;
    }

    public boolean isCollapseSection() {
        return this.collapseSection;
    }

    public boolean isCollapseOnlyOneLevel() {
        return this.collapseOnlyOneLevel;
    }
}

