/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.collapsingconsolesections;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jvnet.hudson.plugins.collapsingconsolesections.CollapsingSectionNote;
import org.jvnet.hudson.plugins.collapsingconsolesections.SectionDefinition;

public class CollapsingSectionsConfiguration
implements Serializable {
    @Nonnull
    private CollapsingSectionNote[] sections;
    private final boolean numberingEnabled;

    public CollapsingSectionsConfiguration(@CheckForNull CollapsingSectionNote[] sections, boolean numberingEnabled) {
        this.sections = sections != null ? Arrays.copyOf(sections, sections.length) : new CollapsingSectionNote[]{};
        this.numberingEnabled = numberingEnabled;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Migration logic")
    private Object readResolve() {
        if (this.sections == null) {
            this.sections = new CollapsingSectionNote[0];
        }
        return this;
    }

    public boolean isNumberingEnabled() {
        return this.numberingEnabled;
    }

    @Nonnull
    public CollapsingSectionNote[] getSections() {
        return Arrays.copyOf(this.sections, this.sections.length);
    }

    @Nonnull
    public SectionDefinition[] getSectionDefinitions() {
        CollapsingSectionNote[] configs = this.getSections();
        ArrayList<SectionDefinition> defs = new ArrayList<SectionDefinition>();
        for (CollapsingSectionNote config : configs) {
            defs.add(config.getDefinition());
        }
        return defs.toArray((SectionDefinition[])Array.newInstance(SectionDefinition.class, 0));
    }
}

