/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura.targets;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.AbstractBuild;
import hudson.model.Api;
import hudson.model.Item;
import hudson.model.Run;
import hudson.plugins.cobertura.BuildUtils;
import hudson.plugins.cobertura.Chartable;
import hudson.plugins.cobertura.CoberturaBuildAction;
import hudson.plugins.cobertura.CoverageChart;
import hudson.plugins.cobertura.IOUtils;
import hudson.plugins.cobertura.Ratio;
import hudson.plugins.cobertura.targets.CoverageAggregationRule;
import hudson.plugins.cobertura.targets.CoverageElement;
import hudson.plugins.cobertura.targets.CoverageMetric;
import hudson.plugins.cobertura.targets.CoveragePaint;
import hudson.plugins.cobertura.targets.CoveragePaintRule;
import hudson.plugins.cobertura.targets.CoverageTree;
import hudson.plugins.cobertura.targets.Messages;
import hudson.util.Graph;
import hudson.util.TextFile;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=2)
public class CoverageResult
implements Serializable,
Chartable {
    private static final long serialVersionUID = -3524882671364156445L;
    private final CoverageElement element;
    private final String name;
    private final CoverageResult parent;
    private final Map<String, CoverageResult> children = new TreeMap<String, CoverageResult>();
    private final Map<CoverageMetric, Ratio> aggregateResults = new EnumMap<CoverageMetric, Ratio>(CoverageMetric.class);
    private final Map<CoverageMetric, Ratio> localResults = new EnumMap<CoverageMetric, Ratio>(CoverageMetric.class);
    private final CoveragePaint paint;
    private String relativeSourcePath;
    public transient Run<?, ?> owner = null;

    public CoverageResult(CoverageElement elementType, CoverageResult parent, String name) {
        this.element = elementType;
        this.paint = CoveragePaintRule.makePaint(this.element);
        this.parent = parent;
        this.name = name;
        this.relativeSourcePath = null;
        if (this.parent != null) {
            this.parent.children.put(name, this);
        }
    }

    public String getRelativeSourcePath() {
        return this.relativeSourcePath;
    }

    public void setRelativeSourcePath(String relativeSourcePath) {
        this.relativeSourcePath = relativeSourcePath;
    }

    public String getName() {
        return this.name == null || this.name.trim().length() == 0 ? Messages.CoverageElement_Project() : this.name;
    }

    public CoverageResult getParent() {
        return this.parent;
    }

    public CoverageElement getElement() {
        return this.element;
    }

    public boolean isSourceCodeLevel() {
        return this.relativeSourcePath != null;
    }

    public CoveragePaint getPaint() {
        return this.paint;
    }

    public void paint(int line, int hits) {
        if (this.paint != null) {
            this.paint.paint(line, hits);
        }
    }

    public void paint(int line, int hits, int branchHits, int branchTotal) {
        if (this.paint != null) {
            this.paint.paint(line, hits, branchHits, branchTotal);
        }
    }

    @Nullable
    private File getSourceFile() {
        if (this.hasPermission()) {
            File sourceFile = new File(this.owner.getParent().getRootDir(), "cobertura/" + IOUtils.sanitizeFilename(this.relativeSourcePath));
            if (sourceFile.exists()) {
                return sourceFile;
            }
            return new File(this.owner.getParent().getRootDir(), "cobertura/" + this.relativeSourcePath);
        }
        return null;
    }

    public boolean isSourceFileAvailable() {
        if (this.hasPermission()) {
            File sourceFile = this.getSourceFile();
            return this.owner == this.owner.getParent().getLastSuccessfulBuild() && sourceFile != null && sourceFile.exists();
        }
        return false;
    }

    public boolean hasPermission() {
        return this.owner.hasPermission(Item.WORKSPACE);
    }

    public String getSourceFileContent() {
        if (this.hasPermission()) {
            try {
                File sourceFile = this.getSourceFile();
                if (sourceFile == null) {
                    return null;
                }
                return new TextFile(sourceFile).read();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public List<CoverageResult> getParents() {
        ArrayList<CoverageResult> result = new ArrayList<CoverageResult>();
        for (CoverageResult p = this.getParent(); p != null; p = p.getParent()) {
            result.add(p);
        }
        Collections.reverse(result);
        return result;
    }

    public Set<CoverageElement> getChildElements() {
        EnumSet<CoverageElement> result = EnumSet.noneOf(CoverageElement.class);
        for (CoverageResult child : this.children.values()) {
            result.add(child.element);
        }
        return result;
    }

    public Set<String> getChildren(CoverageElement element) {
        TreeSet<String> result = new TreeSet<String>();
        for (CoverageResult child : this.children.values()) {
            if (!child.element.equals((Object)element)) continue;
            result.add(child.name);
        }
        return result;
    }

    public Set<CoverageMetric> getChildMetrics(CoverageElement element) {
        TreeSet<CoverageMetric> result = new TreeSet<CoverageMetric>();
        for (CoverageResult child : this.children.values()) {
            if (!child.element.equals((Object)element)) continue;
            result.addAll(child.getMetrics());
        }
        return result;
    }

    public Set<String> getChildren() {
        return this.children.keySet();
    }

    public Map<String, CoverageResult> getChildrenReal() {
        return this.children;
    }

    @Override
    public Map<CoverageMetric, Ratio> getResults() {
        return Collections.unmodifiableMap(this.aggregateResults);
    }

    @Exported(name="results")
    public CoverageTree getResultsAPI() {
        return new CoverageTree(this.name, this.aggregateResults, this.children);
    }

    public String urlTransform(String name) {
        StringBuilder buf = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if ('0' <= c && '9' >= c || 'A' <= c && 'Z' >= c || 'a' <= c && 'z' >= c) {
                buf.append(c);
                continue;
            }
            buf.append('_');
        }
        return buf.toString();
    }

    public String xmlTransform(String name) {
        return name.replaceAll("\\&", "&amp;").replaceAll("\\<", "&lt;").replaceAll("\\>", "&gt;");
    }

    public String relativeUrl(CoverageResult parent) {
        StringBuffer url = new StringBuffer("..");
        for (CoverageResult p = this.getParent(); p != null && p != parent; p = p.getParent()) {
            url.append("/..");
        }
        return url.toString();
    }

    public CoverageResult getChild(String name) {
        return this.children.get(name);
    }

    public Ratio getCoverage(CoverageMetric metric) {
        return this.aggregateResults.get((Object)metric);
    }

    public Ratio getCoverageWithEmpty(CoverageMetric metric) {
        if (this.aggregateResults.containsKey((Object)metric)) {
            return this.aggregateResults.get((Object)metric);
        }
        EnumMap<CoverageMetric, Ratio> currMetricSet = new EnumMap<CoverageMetric, Ratio>(CoverageMetric.class);
        currMetricSet.putAll(this.aggregateResults);
        if (!currMetricSet.containsKey((Object)metric)) {
            return null;
        }
        return (Ratio)currMetricSet.get((Object)metric);
    }

    public Set<CoverageMetric> getMetrics() {
        return Collections.unmodifiableSet(this.aggregateResults.isEmpty() ? EnumSet.noneOf(CoverageMetric.class) : EnumSet.copyOf(this.aggregateResults.keySet()));
    }

    public Set<CoverageMetric> getMetricsWithEmpty() {
        EnumMap<CoverageMetric, Ratio> currMetricSet = new EnumMap<CoverageMetric, Ratio>(CoverageMetric.class);
        currMetricSet.putAll(this.aggregateResults);
        this.fixEmptyMetrics(this.findEmptyMetrics(currMetricSet), currMetricSet);
        return Collections.unmodifiableSet(currMetricSet.isEmpty() ? EnumSet.noneOf(CoverageMetric.class) : EnumSet.copyOf(currMetricSet.keySet()));
    }

    private List<CoverageMetric> findEmptyMetrics(Map<CoverageMetric, Ratio> currMetricSet) {
        LinkedList<CoverageMetric> allMetrics = new LinkedList<CoverageMetric>(Arrays.asList(CoverageMetric.PACKAGES, CoverageMetric.FILES, CoverageMetric.CLASSES, CoverageMetric.METHOD, CoverageMetric.LINE, CoverageMetric.CONDITIONAL));
        LinkedList<CoverageMetric> missingMetrics = new LinkedList<CoverageMetric>();
        for (CoverageMetric currMetric : allMetrics) {
            if (currMetricSet.containsKey((Object)currMetric)) continue;
            missingMetrics.add(currMetric);
        }
        return missingMetrics;
    }

    private void fixEmptyMetrics(List<CoverageMetric> missingMetrics, Map<CoverageMetric, Ratio> currMetricSet) {
        for (CoverageMetric missing : missingMetrics) {
            currMetricSet.put(missing, Ratio.create(1.0f, 1.0f));
        }
    }

    public void updateMetric(CoverageMetric metric, Ratio additionalResult) {
        if (this.localResults.containsKey((Object)metric)) {
            Ratio existingResult = this.localResults.get((Object)metric);
            this.localResults.put(metric, CoverageAggregationRule.combine(metric, existingResult, additionalResult));
        } else {
            this.localResults.put(metric, additionalResult);
        }
    }

    @Override
    public Run<?, ?> getOwner() {
        return this.owner;
    }

    public void setOwner(Run<?, ?> owner) {
        this.owner = owner;
        this.aggregateResults.clear();
        for (CoverageResult child : this.children.values()) {
            child.setOwner(owner);
            if (this.paint != null && child.paint != null && CoveragePaintRule.propagatePaintToParent(child.element)) {
                this.paint.add(child.paint);
            }
            for (Map.Entry<CoverageMetric, Ratio> childResult : child.aggregateResults.entrySet()) {
                this.aggregateResults.putAll(CoverageAggregationRule.aggregate(child.getElement(), childResult.getKey(), childResult.getValue(), this.aggregateResults));
            }
        }
        this.aggregateResults.putAll(this.localResults);
        if (this.paint != null) {
            this.aggregateResults.putAll(this.paint.getResults());
        }
    }

    public void setOwner(AbstractBuild<?, ?> owner) {
        this.setOwner((Run<?, ?>)owner);
    }

    @Override
    public CoverageResult getPreviousResult() {
        if (this.parent == null) {
            if (this.owner == null) {
                return null;
            }
            Run<?, ?> prevBuild = BuildUtils.getPreviousNotFailedCompletedBuild(this.owner);
            CoberturaBuildAction action = null;
            while (prevBuild != null && null == (action = (CoberturaBuildAction)prevBuild.getAction(CoberturaBuildAction.class))) {
                prevBuild = BuildUtils.getPreviousNotFailedCompletedBuild(prevBuild);
            }
            return action == null ? null : action.getResult();
        }
        CoverageResult prevParent = this.parent.getPreviousResult();
        return prevParent == null ? null : prevParent.getChild(this.name);
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) throws IOException {
        token = token.toLowerCase();
        for (String name : this.children.keySet()) {
            if (!this.urlTransform(name).toLowerCase().equals(token)) continue;
            return this.getChild(name);
        }
        return null;
    }

    public void doCoverageHighlightedSource(StaplerRequest req, StaplerResponse rsp) throws IOException {
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        new Graph(this.owner.getTimestamp(), 500, 200){

            protected JFreeChart createGraph() {
                return new CoverageChart(CoverageResult.this).createChart();
            }
        }.doPng(req, rsp);
    }

    public Map<String, CoveragePaint> getPaintedSources() {
        HashMap<String, CoveragePaint> result = new HashMap<String, CoveragePaint>();
        for (CoverageResult child : this.children.values()) {
            result.putAll(child.getPaintedSources());
        }
        if (this.relativeSourcePath != null && this.paint != null) {
            result.put(this.relativeSourcePath, this.paint);
        }
        return result;
    }

    public Api getApi() {
        return new Api((Object)this);
    }
}

