/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura.targets;

import hudson.plugins.cobertura.targets.CoverageAggregationMode;
import hudson.plugins.cobertura.targets.CoverageElement;
import hudson.plugins.cobertura.targets.CoveragePaint;
import java.io.Serializable;

public class CoveragePaintRule
implements Serializable {
    private static final long serialVersionUID = 1039455096344866574L;
    private final CoverageElement element;
    private final CoverageAggregationMode mode;
    private static final CoveragePaintRule[] INITIAL_RULESET = new CoveragePaintRule[]{new CoveragePaintRule(CoverageElement.JAVA_METHOD, CoverageAggregationMode.NONE), new CoveragePaintRule(CoverageElement.JAVA_CLASS, CoverageAggregationMode.SUM)};

    public CoveragePaintRule(CoverageElement element, CoverageAggregationMode mode) {
        this.element = element;
        this.mode = mode;
    }

    public static CoveragePaint makePaint(CoverageElement element) {
        for (CoveragePaintRule rule : INITIAL_RULESET) {
            if (element != rule.element && (element != rule.element.getParent() || CoverageAggregationMode.NONE == rule.mode)) continue;
            return new CoveragePaint(element);
        }
        return null;
    }

    public static boolean propagatePaintToParent(CoverageElement element) {
        for (CoveragePaintRule rule : INITIAL_RULESET) {
            if (element != rule.element) continue;
            return CoverageAggregationMode.NONE != rule.mode;
        }
        return false;
    }
}

