/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura.targets;

import hudson.plugins.cobertura.Ratio;

public enum CoverageAggregationMode {
    NONE(null){

        @Override
        public Ratio aggregate(Ratio a, Ratio b) {
            return null;
        }
    }
    ,
    SUM(Ratio.create(0.0f, 0.0f)){

        @Override
        public Ratio aggregate(Ratio a, Ratio b) {
            return Ratio.create(a.numerator + b.numerator, a.denominator + b.denominator);
        }
    }
    ,
    PRODUCT(Ratio.create(1.0f, 1.0f)){

        @Override
        public Ratio aggregate(Ratio a, Ratio b) {
            return Ratio.create(a.numerator * b.numerator, a.denominator * b.denominator);
        }
    }
    ,
    COUNT_NON_ZERO(Ratio.create(0.0f, 0.0f)){

        @Override
        public Ratio aggregate(Ratio a, Ratio b) {
            if ((double)Math.abs(b.denominator) < 1.0E-7) {
                return a;
            }
            return Ratio.create(a.numerator + (float)((double)Math.abs(b.numerator) > 1.0E-7 ? 1 : 0), a.denominator + 1.0f);
        }
    };

    public final Ratio ZERO;

    private CoverageAggregationMode(Ratio ZERO) {
        this.ZERO = ZERO;
    }

    public abstract Ratio aggregate(Ratio var1, Ratio var2);
}

