/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura.renderers;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.plugins.cobertura.IOUtils;
import hudson.plugins.cobertura.renderers.SourceEncoding;
import hudson.plugins.cobertura.targets.CoveragePaint;
import hudson.remoting.VirtualChannel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jenkins.MasterToSlaveFileCallable;

public class SourceCodePainter
extends MasterToSlaveFileCallable<Map<String, String>>
implements Serializable {
    private final Set<String> sourcePaths;
    private final Map<String, CoveragePaint> paint;
    private final TaskListener listener;
    private final SourceEncoding sourceEncoding;

    public SourceCodePainter(Set<String> sourcePaths, Map<String, CoveragePaint> paint, TaskListener listener, SourceEncoding sourceEncoding) {
        this.sourcePaths = sourcePaths;
        this.paint = paint;
        this.listener = listener;
        this.sourceEncoding = sourceEncoding;
    }

    public void paint(FilePath workspace, FilePath paintedSourcesPath) throws IOException, InterruptedException {
        Map result = (Map)workspace.act((FilePath.FileCallable)this);
        for (String key : this.paint.keySet()) {
            FilePath canvas;
            String content = (String)result.get(key);
            if (content == null || (canvas = paintedSourcesPath.child(IOUtils.sanitizeFilename(key))) == null || canvas.getParent() == null) continue;
            canvas.getParent().mkdirs();
            canvas.write(content, "UTF-8");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String paintSourceCode(File source, CoveragePaint paint) throws IOException {
        FileInputStream is = null;
        InputStreamReader reader = null;
        BufferedReader input = null;
        StringWriter output = new StringWriter();
        int line = 0;
        try {
            String content;
            is = new FileInputStream(source);
            reader = new InputStreamReader((InputStream)is, this.getSourceEncoding().getEncodingName());
            input = new BufferedReader(reader);
            while ((content = input.readLine()) != null) {
                if (paint.isPainted(++line)) {
                    int coveragePercent;
                    int hits = paint.getHits(line);
                    int branchCoverage = paint.getBranchCoverage(line);
                    int branchTotal = paint.getBranchTotal(line);
                    int n = coveragePercent = hits == 0 ? 0 : (int)((double)branchCoverage * 100.0 / (double)branchTotal);
                    if (paint.getHits(line) > 0) {
                        if (branchTotal == branchCoverage) {
                            output.write("<tr class=\"coverFull\">\n");
                        } else {
                            output.write("<tr class=\"coverPart\" title=\"Line " + line + ": Conditional coverage " + coveragePercent + "% (" + branchCoverage + "/" + branchTotal + ")\">\n");
                        }
                    } else {
                        output.write("<tr class=\"coverNone\">\n");
                    }
                    output.write("<td class=\"line\"><a name='" + line + "'/>" + line + "</td>\n");
                    output.write("<td class=\"hits\">" + hits + "</td>\n");
                } else {
                    output.write("<tr class=\"noCover\">\n");
                    output.write("<td class=\"line\"><a name='" + line + "'/>" + line + "</td>\n");
                    output.write("<td class=\"hits\"/>\n");
                }
                output.write("<td class=\"code\">" + content.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "").replace("\r", "").replace(" ", "&nbsp;").replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;") + "</td>\n");
                output.write("</tr>\n");
            }
            paint.setTotalLines(line);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(output);
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly(output);
        IOUtils.closeQuietly(input);
        IOUtils.closeQuietly(is);
        IOUtils.closeQuietly(reader);
        return output.toString();
    }

    public Map<String, String> invoke(File workspaceDir, VirtualChannel channel) throws IOException {
        HashMap<String, String> r = new HashMap<String, String>();
        ArrayList<File> trialPaths = new ArrayList<File>(this.sourcePaths.size());
        for (String string : this.sourcePaths) {
            File trialPath2;
            File trialPath = new File(string);
            if (trialPath.exists()) {
                trialPaths.add(trialPath);
            }
            if (!(trialPath2 = new File(workspaceDir, string)).exists() || trialPath2.equals(trialPath)) continue;
            trialPaths.add(trialPath2);
        }
        for (Map.Entry entry : this.paint.entrySet()) {
            File source = new File(workspaceDir, (String)entry.getKey());
            Iterator possiblePath = trialPaths.iterator();
            while (!source.exists() && possiblePath.hasNext()) {
                source = new File((File)possiblePath.next(), (String)entry.getKey());
            }
            if (source.isFile()) {
                try {
                    r.put((String)entry.getKey(), this.paintSourceCode(source, (CoveragePaint)entry.getValue()));
                }
                catch (IOException e) {
                    e.printStackTrace(this.listener.error("ERROR: Failure to paint " + String.valueOf(source)));
                }
                continue;
            }
            this.listener.getLogger().println("Source file mentioned in coverage report not found: " + String.valueOf(source));
        }
        this.listener.getLogger().flush();
        return r;
    }

    public SourceEncoding getSourceEncoding() {
        if (this.sourceEncoding == null) {
            return SourceEncoding.UTF_8;
        }
        return this.sourceEncoding;
    }
}

