/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura;

import com.google.common.base.Charsets;
import java.io.Closeable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;

public class IOUtils {
    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static String sanitizeFilename(String inputName) {
        Pattern p = Pattern.compile("[^a-zA-Z0-9-]");
        Matcher m = p.matcher(inputName);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String match = m.group();
            m.appendReplacement(sb, "_" + Hex.encodeHexString((byte[])match.getBytes(Charsets.UTF_8)));
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

