/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Job;
import hudson.plugins.cobertura.CoberturaBuildAction;
import hudson.plugins.cobertura.CoberturaProjectAction;
import hudson.plugins.cobertura.Messages;
import hudson.plugins.cobertura.targets.CoverageMetric;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class CoverageColumn
extends ListViewColumn {
    private final String type;

    @DataBoundConstructor
    public CoverageColumn(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getColumnCaption() {
        return Messages.CoverageColumn_columnHeader();
    }

    public String getUrl(Job<?, ?> project) {
        CoberturaBuildAction action = this.getAction(project);
        if (action == null) {
            return null;
        }
        return project.getUrl() + action.getUrlName();
    }

    private CoberturaBuildAction getAction(Job<?, ?> project) {
        CoberturaProjectAction action = (CoberturaProjectAction)project.getAction(CoberturaProjectAction.class);
        if (action != null) {
            return action.getLastResult();
        }
        return null;
    }

    public boolean hasUrl(Job<?, ?> project) {
        return this.getAction(project) != null;
    }

    public String getCoverage(Job<?, ?> project) {
        CoberturaBuildAction lastResult;
        CoberturaProjectAction action = (CoberturaProjectAction)project.getAction(CoberturaProjectAction.class);
        if (action != null && (lastResult = action.getLastResult()) != null) {
            int line = 0;
            int branch = 0;
            if (lastResult.getResult().getCoverage(CoverageMetric.LINE) != null) {
                line = lastResult.getResult().getCoverage(CoverageMetric.LINE).getPercentage();
            }
            if (lastResult.getResult().getCoverage(CoverageMetric.CONDITIONAL) != null) {
                branch = lastResult.getResult().getCoverage(CoverageMetric.CONDITIONAL).getPercentage();
            }
            if ("both".equals(this.type)) {
                return Messages.CoverageColumn_both(line, branch);
            }
            if ("branch".equals(this.type)) {
                return Messages.CoverageColumn_branch(branch);
            }
            return Messages.CoverageColumn_line(line);
        }
        return Messages.CoverageColumn_empty();
    }

    @Extension
    public static class ColumnDescriptor
    extends ListViewColumnDescriptor {
        public boolean shownByDefault() {
            return false;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.CoverageColumn_columnName();
        }
    }
}

