/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.cobertura.BuildUtils;
import hudson.plugins.cobertura.CoberturaAbortException;
import hudson.plugins.cobertura.CoberturaBuildAction;
import hudson.plugins.cobertura.CoberturaCoverageParser;
import hudson.plugins.cobertura.CoberturaCoverageRecordAction;
import hudson.plugins.cobertura.CoberturaPublisherTarget;
import hudson.plugins.cobertura.Messages;
import hudson.plugins.cobertura.adapter.CoberturaReportAdapter;
import hudson.plugins.cobertura.renderers.SourceCodePainter;
import hudson.plugins.cobertura.renderers.SourceEncoding;
import hudson.plugins.cobertura.targets.CoverageMetric;
import hudson.plugins.cobertura.targets.CoverageResult;
import hudson.plugins.cobertura.targets.CoverageTarget;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class CoberturaPublisher
extends Recorder
implements SimpleBuildStep {
    private String coberturaReportFile;
    private boolean onlyStable;
    private boolean failUnhealthy;
    private boolean failUnstable;
    private boolean autoUpdateHealth;
    private boolean autoUpdateStability;
    private boolean zoomCoverageChart;
    private int maxNumberOfBuilds = 0;
    private boolean failNoReports = true;
    private String lineCoverageTargets = null;
    private String packageCoverageTargets = null;
    private String fileCoverageTargets = null;
    private String classCoverageTargets = null;
    private String methodCoverageTargets = null;
    private String conditionalCoverageTargets = null;
    private CoverageTarget healthyTarget = new CoverageTarget();
    private CoverageTarget unhealthyTarget = new CoverageTarget();
    private CoverageTarget failingTarget = new CoverageTarget();
    public static final CoberturaReportFilenameFilter COBERTURA_FILENAME_FILTER = new CoberturaReportFilenameFilter();
    private SourceEncoding sourceEncoding = SourceEncoding.UTF_8;
    private boolean enableNewApi;

    @Deprecated
    public CoberturaPublisher(String coberturaReportFile, boolean onlyStable, boolean failUnhealthy, boolean failUnstable, boolean autoUpdateHealth, boolean autoUpdateStability, boolean zoomCoverageChart, boolean failNoReports, SourceEncoding sourceEncoding, int maxNumberOfBuilds) {
        this.coberturaReportFile = coberturaReportFile;
        this.onlyStable = onlyStable;
        this.failUnhealthy = failUnhealthy;
        this.failUnstable = failUnstable;
        this.autoUpdateHealth = autoUpdateHealth;
        this.autoUpdateStability = autoUpdateStability;
        this.zoomCoverageChart = zoomCoverageChart;
        this.failNoReports = failNoReports;
        this.sourceEncoding = sourceEncoding;
        this.maxNumberOfBuilds = maxNumberOfBuilds;
        this.healthyTarget = new CoverageTarget();
        this.unhealthyTarget = new CoverageTarget();
        this.failingTarget = new CoverageTarget();
    }

    @DataBoundConstructor
    public CoberturaPublisher() {
        this("", true, true, true, true, true, true, true, SourceEncoding.UTF_8, 42);
    }

    public List<CoberturaPublisherTarget> getTargets() {
        float checker;
        CoberturaPublisherTarget target;
        TreeMap<CoverageMetric, CoberturaPublisherTarget> targets = new TreeMap<CoverageMetric, CoberturaPublisherTarget>();
        for (CoverageMetric metric : this.healthyTarget.getTargets()) {
            target = (CoberturaPublisherTarget)targets.get((Object)metric);
            if (target == null) {
                target = new CoberturaPublisherTarget();
                target.setMetric(metric);
            }
            if ((checker = (float)this.healthyTarget.getTarget(metric).intValue() / 100000.0f) <= 0.001f) {
                checker = Math.round(checker * 100000.0f);
            }
            target.setHealthy(Float.valueOf(checker));
            targets.put(metric, target);
        }
        for (CoverageMetric metric : this.unhealthyTarget.getTargets()) {
            target = (CoberturaPublisherTarget)targets.get((Object)metric);
            if (target == null) {
                target = new CoberturaPublisherTarget();
                target.setMetric(metric);
            }
            if ((checker = (float)this.unhealthyTarget.getTarget(metric).intValue() / 100000.0f) <= 0.001f) {
                checker = Math.round(checker * 100000.0f);
            }
            target.setUnhealthy(Float.valueOf(checker));
            targets.put(metric, target);
        }
        for (CoverageMetric metric : this.failingTarget.getTargets()) {
            target = (CoberturaPublisherTarget)targets.get((Object)metric);
            if (target == null) {
                target = new CoberturaPublisherTarget();
                target.setMetric(metric);
            }
            if ((checker = (float)this.failingTarget.getTarget(metric).intValue() / 100000.0f) <= 0.001f) {
                checker = Math.round(checker * 100000.0f);
            }
            target.setUnstable(Float.valueOf(checker));
            targets.put(metric, target);
        }
        ArrayList<CoberturaPublisherTarget> result = new ArrayList<CoberturaPublisherTarget>(targets.values());
        return result;
    }

    private void setTargets(List<CoberturaPublisherTarget> targets) throws AbortException {
        this.healthyTarget.clear();
        this.unhealthyTarget.clear();
        this.failingTarget.clear();
        for (CoberturaPublisherTarget target : targets) {
            float rounded;
            if (target.getHealthy() != null) {
                rounded = Math.round(100.0f * target.getHealthy().floatValue());
                rounded = this.roundDecimalFloat(Float.valueOf(rounded));
                this.healthyTarget.setTarget(target.getMetric(), (int)(100000.0f * rounded));
            }
            if (target.getUnhealthy() != null) {
                rounded = Math.round(100.0f * target.getUnhealthy().floatValue());
                rounded = this.roundDecimalFloat(Float.valueOf(rounded));
                this.unhealthyTarget.setTarget(target.getMetric(), (int)(100000.0f * rounded));
            }
            if (target.getUnstable() != null) {
                rounded = Math.round(100.0f * target.getUnstable().floatValue());
                rounded = this.roundDecimalFloat(Float.valueOf(rounded));
                this.failingTarget.setTarget(target.getMetric(), (int)(100000.0f * rounded));
            }
            this.setTargetString(target);
        }
    }

    private void setTargetString(CoberturaPublisherTarget target) throws AbortException {
        switch (target.getMetric()) {
            case PACKAGES: {
                this.setPackageCoverageTargets(MessageFormat.format("{0}", target.toString()));
                break;
            }
            case FILES: {
                this.setFileCoverageTargets(MessageFormat.format("{0}", target.toString()));
                break;
            }
            case CLASSES: {
                this.setClassCoverageTargets(MessageFormat.format("{0}", target.toString()));
                break;
            }
            case METHOD: {
                this.setMethodCoverageTargets(MessageFormat.format("{0}", target.toString()));
                break;
            }
            case LINE: {
                this.setLineCoverageTargets(MessageFormat.format("{0}", target.toString()));
                break;
            }
            case CONDITIONAL: {
                this.setConditionalCoverageTargets(MessageFormat.format("{0}", target.toString()));
            }
        }
    }

    @DataBoundSetter
    public void setCoberturaReportFile(String coberturaReportFile) {
        this.coberturaReportFile = coberturaReportFile;
    }

    public String getCoberturaReportFile() {
        return this.coberturaReportFile;
    }

    @DataBoundSetter
    public void setOnlyStable(boolean onlyStable) {
        this.onlyStable = onlyStable;
    }

    public boolean getOnlyStable() {
        return this.onlyStable;
    }

    @DataBoundSetter
    public void setMaxNumberOfBuilds(int maxNumberOfBuilds) {
        this.maxNumberOfBuilds = maxNumberOfBuilds;
    }

    public int getMaxNumberOfBuilds() {
        return this.maxNumberOfBuilds;
    }

    @DataBoundSetter
    public void setFailUnhealthy(boolean failUnhealthy) {
        this.failUnhealthy = failUnhealthy;
    }

    public boolean getFailUnhealthy() {
        return this.failUnhealthy;
    }

    @DataBoundSetter
    public void setFailUnstable(boolean failUnstable) {
        this.failUnstable = failUnstable;
    }

    public boolean getFailUnstable() {
        return this.failUnstable;
    }

    @DataBoundSetter
    public void setAutoUpdateHealth(boolean autoUpdateHealth) {
        this.autoUpdateHealth = autoUpdateHealth;
    }

    public boolean getAutoUpdateHealth() {
        return this.autoUpdateHealth;
    }

    @DataBoundSetter
    public void setAutoUpdateStability(boolean autoUpdateStability) {
        this.autoUpdateStability = autoUpdateStability;
    }

    public boolean getAutoUpdateStability() {
        return this.autoUpdateStability;
    }

    @DataBoundSetter
    public void setZoomCoverageChart(boolean zoomCoverageChart) {
        this.zoomCoverageChart = zoomCoverageChart;
    }

    public boolean getZoomCoverageChart() {
        return this.zoomCoverageChart;
    }

    @DataBoundSetter
    public void setFailNoReports(boolean failNoReports) {
        this.failNoReports = failNoReports;
    }

    public boolean isFailNoReports() {
        return this.failNoReports;
    }

    @DataBoundSetter
    public void setLineCoverageTargets(String targets) throws AbortException {
        this.lineCoverageTargets = targets;
    }

    public String getLineCoverageTargets() {
        return this.lineCoverageTargets;
    }

    @DataBoundSetter
    public void setPackageCoverageTargets(String targets) {
        this.packageCoverageTargets = targets;
    }

    public String getPackageCoverageTargets() {
        return this.packageCoverageTargets;
    }

    @DataBoundSetter
    public void setFileCoverageTargets(String targets) {
        this.fileCoverageTargets = targets;
    }

    public String getFileCoverageTargets() {
        return this.fileCoverageTargets;
    }

    @DataBoundSetter
    public void setClassCoverageTargets(String targets) {
        this.classCoverageTargets = targets;
    }

    public String getClassCoverageTargets() {
        return this.classCoverageTargets;
    }

    @DataBoundSetter
    public void setMethodCoverageTargets(String targets) {
        this.methodCoverageTargets = targets;
    }

    public String getMethodCoverageTargets() {
        return this.methodCoverageTargets;
    }

    @DataBoundSetter
    public void setConditionalCoverageTargets(String targets) {
        this.conditionalCoverageTargets = targets;
    }

    public String getConditionalCoverageTargets() {
        return this.conditionalCoverageTargets;
    }

    public CoverageTarget getHealthyTarget() {
        return this.healthyTarget;
    }

    public void setHealthyTarget(CoverageTarget healthyTarget) {
        this.healthyTarget = healthyTarget;
    }

    public CoverageTarget getUnhealthyTarget() {
        return this.unhealthyTarget;
    }

    public void setUnhealthyTarget(CoverageTarget unhealthyTarget) {
        this.unhealthyTarget = unhealthyTarget;
    }

    public CoverageTarget getFailingTarget() {
        return this.failingTarget;
    }

    public void setFailingTarget(CoverageTarget failingTarget) {
        this.failingTarget = failingTarget;
    }

    static File[] getCoberturaReports(Run<?, ?> build) {
        return build.getRootDir().listFiles(COBERTURA_FILENAME_FILTER);
    }

    public void perform(@NonNull Run<?, ?> build, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        this.setAllCoverageTargets();
        this.recoverAutoUpdatedTargets(build);
        Result threshold = this.onlyStable ? Result.SUCCESS : Result.FAILURE;
        Result buildResult = build.getResult();
        if (buildResult != null && buildResult.isWorseThan(threshold)) {
            CoberturaPublisher.logMessage(listener, "Skipping Cobertura coverage report as build was not " + threshold.toString() + " or better ...");
            return;
        }
        CoberturaPublisher.logMessage(listener, "Publishing Cobertura coverage report...");
        File buildCoberturaDir = build.getRootDir();
        FilePath buildTarget = new FilePath(buildCoberturaDir);
        EnvVars env = build.getEnvironment(listener);
        FilePath[] reports = null;
        try {
            reports = (FilePath[])workspace.act((FilePath.FileCallable)new ParseReportCallable(env.expand(this.coberturaReportFile)));
            if (buildResult != null && buildResult.isWorseOrEqualTo(Result.FAILURE) && reports.length == 0) {
                return;
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("Unable to find coverage results"));
            throw new CoberturaAbortException("Unable to find coverage results");
        }
        if (reports.length == 0) {
            String msg = "No coverage results were found using the pattern '" + this.coberturaReportFile + "' relative to '" + workspace.getRemote() + "'.  Did you enter a pattern relative to the correct directory?  Did you generate the XML report(s) for Cobertura?";
            CoberturaPublisher.logMessage(listener, msg);
            if (this.failNoReports) {
                throw new CoberturaAbortException(msg);
            }
            CoberturaPublisher.logMessage(listener, "Skipped cobertura reports.");
            return;
        }
        for (int i = 0; i < reports.length; ++i) {
            FilePath targetPath = new FilePath(buildTarget, "coverage" + String.valueOf(i == 0 ? "" : Integer.valueOf(i)) + ".xml");
            try {
                reports[i].copyTo(targetPath);
                continue;
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                String msg = "Unable to copy coverage from " + String.valueOf(reports[i]) + " to " + String.valueOf(buildTarget);
                e.printStackTrace(listener.fatalError(msg));
                throw new CoberturaAbortException(msg);
            }
        }
        CoberturaPublisher.logMessage(listener, "Publishing Cobertura coverage results...");
        HashSet<String> sourcePaths = new HashSet<String>();
        CoverageResult result = null;
        for (File coberturaXmlReport : CoberturaPublisher.getCoberturaReports(build)) {
            try {
                result = CoberturaCoverageParser.parse(coberturaXmlReport, result, sourcePaths);
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("Unable to parse " + String.valueOf(coberturaXmlReport)));
                throw new CoberturaAbortException("Unable to parse " + String.valueOf(coberturaXmlReport));
            }
        }
        if (result != null) {
            Set<CoverageMetric> unhealthyMetrics;
            Set<CoverageMetric> failingMetrics;
            CoberturaPublisher.logMessage(listener, "Cobertura coverage report found.");
            result.setOwner(build);
            FilePath paintedSourcesPath = new FilePath(new File(build.getParent().getRootDir(), "cobertura"));
            if (sourcePaths.contains(".")) {
                sourcePaths.remove(".");
                for (FilePath f : reports) {
                    FilePath p = f.getParent();
                    if (p == null || !p.isDirectory()) continue;
                    sourcePaths.add(p.getRemote());
                }
            }
            new SourceCodePainter(sourcePaths, result.getPaintedSources(), listener, this.getSourceEncoding()).paint(workspace, paintedSourcesPath);
            CoberturaBuildAction action = CoberturaBuildAction.load(result, this.healthyTarget, this.unhealthyTarget, this.getOnlyStable(), this.getFailUnhealthy(), this.getFailUnstable(), this.getAutoUpdateHealth(), this.getAutoUpdateStability(), this.getZoomCoverageChart(), this.getMaxNumberOfBuilds());
            build.addAction((Action)action);
            if (this.enableNewApi) {
                CoberturaReportAdapter newApiAdapter = new CoberturaReportAdapter(env.expand(this.coberturaReportFile));
                newApiAdapter.performCoveragePlugin(build, workspace, launcher, listener);
            }
            if (!(failingMetrics = this.failingTarget.getFailingMetrics(result)).isEmpty()) {
                CoberturaPublisher.logMessage(listener, "Code coverage enforcement failed for the following metrics:");
                for (CoverageMetric metric : failingMetrics) {
                    float oldStabilityPercent = this.failingTarget.getObservedPercent(result, metric);
                    float setStabilityPercent = this.failingTarget.getSetPercent(result, metric);
                    CoberturaPublisher.logMessage(listener, "    " + metric.getName() + "'s stability is " + this.roundDecimalFloat(Float.valueOf(oldStabilityPercent * 100.0f)) + " and set mininum stability is " + this.roundDecimalFloat(Float.valueOf(setStabilityPercent * 100.0f)) + ".");
                }
                if (!this.getFailUnstable()) {
                    CoberturaPublisher.logMessage(listener, "Setting Build to unstable.");
                    build.setResult(Result.UNSTABLE);
                } else {
                    action.setFailMessage(String.format("Build failed because following metrics did not meet stability target: %s.", failingMetrics.toString()));
                    throw new CoberturaAbortException("Failing build due to unstability.");
                }
            }
            if (this.getFailUnhealthy() && !(unhealthyMetrics = this.unhealthyTarget.getFailingMetrics(result)).isEmpty()) {
                CoberturaPublisher.logMessage(listener, "Unhealthy for the following metrics:");
                for (CoverageMetric metric : unhealthyMetrics) {
                    float oldHealthyPercent = this.unhealthyTarget.getObservedPercent(result, metric);
                    float setHealthyPercent = this.unhealthyTarget.getSetPercent(result, metric);
                    listener.getLogger().println("    " + metric.getName() + "'s health is " + this.roundDecimalFloat(Float.valueOf(oldHealthyPercent * 100.0f)) + " and set minimum health is " + this.roundDecimalFloat(Float.valueOf(setHealthyPercent * 100.0f)) + ".");
                }
                action.setFailMessage(String.format("Build failed because following metrics did not meet health target: %s.", unhealthyMetrics.toString()));
                throw new CoberturaAbortException("Failing build because it is unhealthy.");
            }
            if (build.getResult() == null || build.getResult() == Result.SUCCESS) {
                if (this.getAutoUpdateHealth()) {
                    this.setNewPercentages(result, true, listener);
                }
                if (this.getAutoUpdateStability()) {
                    this.setNewPercentages(result, false, listener);
                }
            }
        } else {
            throw new CoberturaAbortException("No coverage results were successfully parsed.  Did you generate the XML report(s) for Cobertura?");
        }
    }

    private void recoverAutoUpdatedTargets(Run<?, ?> build) {
        CoberturaCoverageRecordAction lastRecordAction;
        CoberturaCoverageRecordAction currentRecordAction = new CoberturaCoverageRecordAction();
        currentRecordAction.setAutoUpdateHealth(this.getAutoUpdateHealth());
        currentRecordAction.setAutoUpdateStability(this.getAutoUpdateStability());
        CoverageTarget currentSetUnhealthyTarget = new CoverageTarget();
        for (CoverageMetric coverageMetric : this.unhealthyTarget.getTargets()) {
            currentSetUnhealthyTarget.setTarget(coverageMetric, this.unhealthyTarget.getTarget(coverageMetric));
        }
        CoverageTarget currentSetFailingTarget = new CoverageTarget();
        for (CoverageMetric target : this.failingTarget.getTargets()) {
            currentSetFailingTarget.setTarget(target, this.failingTarget.getTarget(target));
        }
        currentRecordAction.setLastUnhealthyTarget(currentSetUnhealthyTarget);
        currentRecordAction.setLastFailingTarget(currentSetFailingTarget);
        Run<?, ?> run = BuildUtils.getPreviousNotFailedCompletedBuild(build);
        if (run != null && (lastRecordAction = (CoberturaCoverageRecordAction)run.getAction(CoberturaCoverageRecordAction.class)) != null) {
            if (this.getAutoUpdateHealth() && lastRecordAction.isAutoUpdateHealth()) {
                CoverageTarget lastSetUnhealthyTarget = lastRecordAction.getLastUnhealthyTarget();
                CoverageTarget lastUpdatedUnhealthyTarget = lastRecordAction.getLastUpdatedUnhealthyTarget();
                for (CoverageMetric target : this.unhealthyTarget.getTargets()) {
                    if (!this.unhealthyTarget.getTarget(target).equals(lastSetUnhealthyTarget.getTarget(target))) continue;
                    this.unhealthyTarget.setTarget(target, lastUpdatedUnhealthyTarget.getTarget(target));
                }
            }
            if (this.getAutoUpdateStability() && lastRecordAction.isAutoUpdateStability()) {
                CoverageTarget lastFailingTarget = lastRecordAction.getLastFailingTarget();
                CoverageTarget lastUpdatedFailingTarget = lastRecordAction.getLastUpdatedFailingTarget();
                for (CoverageMetric target : this.failingTarget.getTargets()) {
                    if (!this.failingTarget.getTarget(target).equals(lastFailingTarget.getTarget(target))) continue;
                    this.failingTarget.setTarget(target, lastUpdatedFailingTarget.getTarget(target));
                }
            }
        }
        currentRecordAction.setLastUpdatedUnhealthyTarget(this.unhealthyTarget);
        currentRecordAction.setLastUpdatedFailingTarget(this.failingTarget);
        build.addAction((Action)currentRecordAction);
    }

    private void setAllCoverageTargets() throws CoberturaAbortException {
        if (this.lineCoverageTargets != null) {
            try {
                this.setCoverageTargets(CoverageMetric.LINE, this.lineCoverageTargets);
            }
            catch (NumberFormatException e) {
                throw new CoberturaAbortException("Invalid value for lineCoverageTargets");
            }
        }
        if (this.packageCoverageTargets != null) {
            try {
                this.setCoverageTargets(CoverageMetric.PACKAGES, this.packageCoverageTargets);
            }
            catch (NumberFormatException e) {
                throw new CoberturaAbortException("Invalid value for packageCoverageTargets");
            }
        }
        if (this.fileCoverageTargets != null) {
            try {
                this.setCoverageTargets(CoverageMetric.FILES, this.fileCoverageTargets);
            }
            catch (NumberFormatException e) {
                throw new CoberturaAbortException("Invalid value for fileCoverageTargets");
            }
        }
        if (this.classCoverageTargets != null) {
            try {
                this.setCoverageTargets(CoverageMetric.CLASSES, this.classCoverageTargets);
            }
            catch (NumberFormatException e) {
                throw new CoberturaAbortException("Invalid value for classCoverageTargets");
            }
        }
        if (this.methodCoverageTargets != null) {
            try {
                this.setCoverageTargets(CoverageMetric.METHOD, this.methodCoverageTargets);
            }
            catch (NumberFormatException e) {
                throw new CoberturaAbortException("Invalid value for methodCoverageTargets");
            }
        }
        if (this.conditionalCoverageTargets != null) {
            try {
                this.setCoverageTargets(CoverageMetric.CONDITIONAL, this.conditionalCoverageTargets);
            }
            catch (NumberFormatException e) {
                throw new CoberturaAbortException("Invalid value for conditionalCoverageTargets");
            }
        }
    }

    private float[] parseCoverageTargets(String targets) {
        String[] targetValues = targets.split(",");
        float[] result = new float[3];
        for (int i = 0; i < targetValues.length && i < result.length; ++i) {
            try {
                result[i] = Float.parseFloat(targetValues[i]);
                continue;
            }
            catch (NumberFormatException ex) {
                result[i] = 0.0f;
            }
        }
        return result;
    }

    private void setCoverageTargets(CoverageMetric metric, String targets) {
        float[] targetValues = this.parseCoverageTargets(targets);
        this.healthyTarget.setTarget(metric, Math.round(targetValues[0] * 100000.0f));
        this.unhealthyTarget.setTarget(metric, Math.round(targetValues[1] * 100000.0f));
        this.failingTarget.setTarget(metric, Math.round(targetValues[2] * 100000.0f));
    }

    private void setNewPercentages(CoverageResult result, boolean select, TaskListener listener) {
        Set<CoverageMetric> healthyMetrics = this.healthyTarget.getAllMetrics(result);
        if (!healthyMetrics.isEmpty()) {
            for (CoverageMetric metric : healthyMetrics) {
                float oldPercent;
                float newPercent = this.healthyTarget.getObservedPercent(result, metric);
                newPercent = Math.round(newPercent * 100.0f);
                if (select) {
                    oldPercent = this.unhealthyTarget.getSetPercent(result, metric);
                    oldPercent = Math.round(oldPercent * 100.0f);
                } else {
                    oldPercent = this.failingTarget.getSetPercent(result, metric);
                    oldPercent = Math.round(oldPercent * 100.0f);
                }
                if (!(newPercent > oldPercent)) continue;
                if (select) {
                    this.unhealthyTarget.setTarget(metric, (int)(newPercent * 1000.0f));
                    listener.getLogger().println("    " + metric.getName() + "'s new health minimum is: " + this.roundDecimalFloat(Float.valueOf(newPercent)));
                    continue;
                }
                this.failingTarget.setTarget(metric, (int)(newPercent * 1000.0f));
                listener.getLogger().println("    " + metric.getName() + "'s new stability minimum is: " + this.roundDecimalFloat(Float.valueOf(newPercent)));
            }
        }
    }

    private static void logMessage(TaskListener listener, String message) {
        listener.getLogger().printf("%s%n", CoberturaPublisher.wrappedMessage(message));
    }

    private static String wrappedMessage(String message) {
        return String.format("[Cobertura] %s%n", message);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @DataBoundSetter
    public void setSourceEncoding(SourceEncoding sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public SourceEncoding getSourceEncoding() {
        return this.sourceEncoding;
    }

    public boolean isEnableNewApi() {
        return this.enableNewApi;
    }

    @DataBoundSetter
    public void setEnableNewApi(boolean enableNewApi) {
        this.enableNewApi = enableNewApi;
    }

    private static List<CoberturaPublisherTarget> bindTargetsFromForm(JSONObject formData) {
        ArrayList<CoberturaPublisherTarget> targets = new ArrayList<CoberturaPublisherTarget>();
        JSONArray coverageTargets = null;
        Object coverageTargetsObject = formData.get("inst");
        if (coverageTargetsObject instanceof JSONObject) {
            CoberturaPublisherTarget target = CoberturaPublisher.targetFromJSONObject((JSONObject)coverageTargetsObject);
            if (null != target) {
                targets.add(target);
            }
        } else if (coverageTargetsObject instanceof JSONArray) {
            coverageTargets = (JSONArray)coverageTargetsObject;
            for (Object targetObject : coverageTargets) {
                CoberturaPublisherTarget target = CoberturaPublisher.targetFromJSONObject((JSONObject)targetObject);
                if (null == target) continue;
                targets.add(target);
            }
        }
        return targets;
    }

    private static Float getFloat(JSONObject object, String key) {
        Float floatValue = new Float(object.optDouble(key));
        return floatValue.isNaN() ? null : floatValue;
    }

    private static CoberturaPublisherTarget targetFromJSONObject(Object targetObject) {
        if (targetObject != null && targetObject instanceof JSONObject) {
            JSONObject targetJSONObject = (JSONObject)targetObject;
            try {
                CoverageMetric metric = CoverageMetric.valueOf(targetJSONObject.getString("metric"));
                return new CoberturaPublisherTarget(metric, CoberturaPublisher.getFloat(targetJSONObject, "healthy"), CoberturaPublisher.getFloat(targetJSONObject, "unhealthy"), CoberturaPublisher.getFloat(targetJSONObject, "unstable"));
            }
            catch (JSONException ex) {
                Logger.getLogger(CoberturaPublisher.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public float roundDecimalFloat(Float input) {
        float rounded = Math.round(input.floatValue());
        return rounded /= 100.0f;
    }

    private static class CoberturaReportFilenameFilter
    implements FilenameFilter {
        private CoberturaReportFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith("coverage") && name.endsWith(".xml");
        }
    }

    public static class ParseReportCallable
    extends MasterToSlaveFileCallable<FilePath[]> {
        private static final long serialVersionUID = 1L;
        private final String reportFilePath;

        public ParseReportCallable(String reportFilePath) {
            this.reportFilePath = reportFilePath;
        }

        /*
         * Exception decompiling
         */
        public FilePath[] invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
             *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
             *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
             *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
             *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
             *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyTryCatchLeaveGoto(ClassifyGotos.java:144)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyTryLeaveGoto(ClassifyGotos.java:76)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyGotos(ClassifyGotos.java:66)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.classifyGotos(Op03Rewriters.java:105)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:752)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    @Extension
    @Symbol(value={"cobertura"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        CoverageMetric[] metrics = new CoverageMetric[]{CoverageMetric.PACKAGES, CoverageMetric.FILES, CoverageMetric.CLASSES, CoverageMetric.METHOD, CoverageMetric.LINE, CoverageMetric.CONDITIONAL};

        @NonNull
        public String getDisplayName() {
            return Messages.CoberturaPublisher_displayName();
        }

        public List<CoverageMetric> getMetrics() {
            return Arrays.asList(this.metrics);
        }

        public List<CoberturaPublisherTarget> getDefaultTargets() {
            ArrayList<CoberturaPublisherTarget> result = new ArrayList<CoberturaPublisherTarget>();
            result.add(new CoberturaPublisherTarget(CoverageMetric.METHOD, Float.valueOf(80.0f), null, null));
            result.add(new CoberturaPublisherTarget(CoverageMetric.LINE, Float.valueOf(80.0f), null, null));
            result.add(new CoberturaPublisherTarget(CoverageMetric.CONDITIONAL, Float.valueOf(70.0f), null, null));
            return result;
        }

        public List<CoberturaPublisherTarget> getTargets(CoberturaPublisher instance) {
            if (instance == null) {
                return this.getDefaultTargets();
            }
            return instance.getTargets();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindParameters((Object)this, "cobertura.");
            this.save();
            return super.configure(req, formData);
        }

        public CoberturaPublisher newInstance(StaplerRequest req, @NonNull JSONObject formData) throws Descriptor.FormException {
            if (req == null) {
                throw new Descriptor.FormException("req cannot be null", "");
            }
            CoberturaPublisher instance = (CoberturaPublisher)((Object)req.bindJSON(CoberturaPublisher.class, formData));
            ConvertUtils.register((Converter)CoberturaPublisherTarget.CONVERTER, CoverageMetric.class);
            List<CoberturaPublisherTarget> targets = req.bindParametersToList(CoberturaPublisherTarget.class, "cobertura.target.");
            if (0 == targets.size()) {
                targets = CoberturaPublisher.bindTargetsFromForm(formData);
            }
            try {
                instance.setTargets(targets);
            }
            catch (AbortException ex) {
                Logger.getLogger(CoberturaPublisher.class.getName()).log(Level.SEVERE, null, ex);
            }
            return instance;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

