/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura;

import hudson.plugins.cobertura.CoberturaXmlHandler;
import hudson.plugins.cobertura.IOUtils;
import hudson.plugins.cobertura.targets.CoverageResult;
import hudson.util.IOException2;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class CoberturaCoverageParser {
    private CoberturaCoverageParser() {
    }

    public static CoverageResult parse(File inFile, CoverageResult cumulative) throws IOException {
        return CoberturaCoverageParser.parse(inFile, cumulative, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoverageResult parse(File inFile, CoverageResult cumulative, Set<String> sourcePaths) throws IOException {
        CoverageResult coverageResult;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            fileInputStream = new FileInputStream(inFile);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            coverageResult = CoberturaCoverageParser.parse(bufferedInputStream, cumulative, sourcePaths);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedInputStream);
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(bufferedInputStream);
        IOUtils.closeQuietly(fileInputStream);
        return coverageResult;
    }

    public static CoverageResult parse(InputStream in, CoverageResult cumulative) throws IOException {
        return CoberturaCoverageParser.parse(in, cumulative, null);
    }

    public static CoverageResult parse(InputStream in, CoverageResult cumulative, Set<String> sourcePaths) throws IOException {
        if (in == null) {
            throw new NullPointerException();
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        try {
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
        try {
            SAXParser parser = factory.newSAXParser();
            CoberturaXmlHandler handler = new CoberturaXmlHandler(cumulative);
            parser.parse(in, (DefaultHandler)handler);
            if (sourcePaths != null) {
                sourcePaths.addAll(handler.getSourcePaths());
            }
            return handler.getRootCoverage();
        }
        catch (ParserConfigurationException e) {
            throw new IOException2("Cannot parse coverage results", (Throwable)e);
        }
        catch (SAXException e) {
            throw new IOException2("Cannot parse coverage results", (Throwable)e);
        }
    }
}

