/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura.targets;

import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import hudson.plugins.cobertura.Ratio;
import hudson.plugins.cobertura.targets.CoverageElement;
import hudson.plugins.cobertura.targets.CoverageMetric;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;

public class CoveragePaint
implements Serializable {
    private static final long serialVersionUID = -6265259191856193735L;
    private static final CoveragePaintDetails[] EMPTY = new CoveragePaintDetails[0];
    protected TIntObjectMap<CoveragePaintDetails> lines = new TIntObjectHashMap();
    private int totalLines = 0;

    public CoveragePaint(CoverageElement source) {
    }

    private void paint(int line, CoveragePaintDetails delta) {
        CoveragePaintDetails d = (CoveragePaintDetails)this.lines.get(line);
        if (d == null) {
            this.lines.put(line, (Object)delta);
        } else {
            this.lines.put(line, (Object)d.add(delta));
        }
    }

    public void paint(int line, int hits) {
        this.paint(line, CoveragePaintDetails.create(hits, 0, 0));
    }

    public void paint(int line, int hits, int branchCover, int branchCount) {
        this.paint(line, CoveragePaintDetails.create(hits, branchCount, branchCover));
    }

    public void add(CoveragePaint child) {
        TIntObjectIterator it = child.lines.iterator();
        while (it.hasNext()) {
            it.advance();
            this.paint(it.key(), (CoveragePaintDetails)it.value());
        }
    }

    public void setTotalLines(int totalLines) {
        this.totalLines = totalLines;
    }

    public int getTotalLines() {
        return this.totalLines;
    }

    public Ratio getLineCoverage() {
        int covered = 0;
        for (CoveragePaintDetails d : (CoveragePaintDetails[])this.lines.values((Object[])EMPTY)) {
            if (d.hitCount <= 0) continue;
            ++covered;
        }
        return Ratio.create(covered, this.lines.size());
    }

    public Ratio getConditionalCoverage() {
        long maxTotal = 0L;
        long total = 0L;
        for (CoveragePaintDetails d : (CoveragePaintDetails[])this.lines.values((Object[])EMPTY)) {
            maxTotal += (long)d.branchCount();
            total += (long)d.branchCoverage();
        }
        return Ratio.create(total, maxTotal);
    }

    public Map<CoverageMetric, Ratio> getResults() {
        EnumMap<CoverageMetric, Ratio> result = new EnumMap<CoverageMetric, Ratio>(CoverageMetric.class);
        result.put(CoverageMetric.LINE, this.getLineCoverage());
        result.put(CoverageMetric.CONDITIONAL, this.getConditionalCoverage());
        return result;
    }

    public boolean isPainted(int line) {
        return this.lines.get(line) != null;
    }

    public int getHits(int line) {
        CoveragePaintDetails d = (CoveragePaintDetails)this.lines.get(line);
        if (d == null) {
            return 0;
        }
        return d.hitCount;
    }

    public int getBranchTotal(int line) {
        CoveragePaintDetails d = (CoveragePaintDetails)this.lines.get(line);
        if (d == null) {
            return 0;
        }
        return d.branchCount();
    }

    public int getBranchCoverage(int line) {
        CoveragePaintDetails d = (CoveragePaintDetails)this.lines.get(line);
        if (d == null) {
            return 0;
        }
        return d.branchCoverage();
    }

    private static class CoveragePaintDetails
    implements Serializable {
        private static final long serialVersionUID = -9097537016381444671L;
        private static final CoveragePaintDetails[] CONSTANTS = new CoveragePaintDetails[128];
        final int hitCount;

        static CoveragePaintDetails create(int hitCount, int branchCount, int branchCoverage) {
            if (branchCount == 0 && branchCoverage == 0) {
                if (0 <= hitCount && hitCount < CONSTANTS.length) {
                    CoveragePaintDetails r = CONSTANTS[hitCount];
                    if (r == null) {
                        CoveragePaintDetails.CONSTANTS[hitCount] = r = new CoveragePaintDetails(hitCount);
                    }
                    return r;
                }
                return new CoveragePaintDetails(hitCount);
            }
            return new BranchingCoveragePaintDetails(hitCount, branchCount, branchCoverage);
        }

        private CoveragePaintDetails(int hitCount) {
            this.hitCount = hitCount;
        }

        int branchCount() {
            return 0;
        }

        int branchCoverage() {
            return 0;
        }

        CoveragePaintDetails add(CoveragePaintDetails that) {
            return CoveragePaintDetails.create(this.hitCount + that.hitCount, Math.max(this.branchCount(), that.branchCount()), Math.max(this.branchCoverage(), that.branchCoverage()));
        }
    }

    private static class BranchingCoveragePaintDetails
    extends CoveragePaintDetails {
        final int branchCount;
        final int branchCoverage;
        private static final long serialVersionUID = 1L;

        private BranchingCoveragePaintDetails(int hitCount, int branchCount, int branchCoverage) {
            super(hitCount);
            this.branchCount = branchCount;
            this.branchCoverage = branchCoverage;
        }

        @Override
        int branchCount() {
            return this.branchCount;
        }

        @Override
        int branchCoverage() {
            return this.branchCoverage;
        }
    }
}

