/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura.adapter;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.plugins.cobertura.adapter.Messages;
import io.jenkins.plugins.coverage.adapter.JavaCoverageReportAdapterDescriptor;
import io.jenkins.plugins.coverage.adapter.JavaXMLCoverageReportAdapter;
import io.jenkins.plugins.coverage.adapter.util.XMLUtils;
import io.jenkins.plugins.coverage.detector.Detectable;
import java.io.File;
import javax.xml.transform.TransformerException;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class CoberturaReportAdapter
extends JavaXMLCoverageReportAdapter {
    @DataBoundConstructor
    public CoberturaReportAdapter(String path) {
        super(path);
    }

    public String getXSL() {
        return "cobertura-to-standard.xsl";
    }

    public String getXSD() {
        return null;
    }

    @Symbol(value={"coberturaAdapter", "cobertura"})
    @Extension
    public static final class CoberturaReportAdapterDescriptor
    extends JavaCoverageReportAdapterDescriptor
    implements Detectable {
        public CoberturaReportAdapterDescriptor() {
            super(CoberturaReportAdapter.class);
        }

        public boolean detect(File file) {
            Document d;
            if (!file.exists()) {
                return false;
            }
            try {
                d = XMLUtils.getInstance().readXMLtoDocument(file);
            }
            catch (TransformerException ignore) {
                return false;
            }
            Element e = d.getDocumentElement();
            if (e == null) {
                return false;
            }
            return "coverage".equals(e.getLocalName());
        }

        @NonNull
        public String getDisplayName() {
            return Messages.CoberturaReportAdapter_displayName();
        }
    }
}

