/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura;

import hudson.plugins.cobertura.Chartable;
import hudson.plugins.cobertura.CoberturaBuildAction;
import hudson.plugins.cobertura.Ratio;
import hudson.plugins.cobertura.targets.CoverageMetric;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.Log;

public class CoverageChart {
    private CategoryDataset dataset;
    private int lowerBound;
    private int upperBound;

    public CoverageChart(Chartable chartable) {
        this(chartable, CoverageChart.isZoomCoverageChart(chartable), CoverageChart.getMaximumBuilds(chartable));
    }

    protected CoverageChart(Chartable chartable, boolean zoomCoverageChart, int maximumBuilds) {
        if (chartable == null) {
            throw new NullPointerException("Cannot draw null-chart");
        }
        if (chartable.getPreviousResult() == null) {
            throw new NullPointerException("Need at least two result to draw a chart");
        }
        DataSetBuilder dsb = new DataSetBuilder();
        int min = 100;
        int max = 0;
        int n = 0;
        for (Chartable a = chartable; a != null; a = a.getPreviousResult()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(a.getOwner());
            for (Map.Entry<CoverageMetric, Ratio> value : a.getResults().entrySet()) {
                dsb.add((Number)Float.valueOf(value.getValue().getPercentageFloat()), (Comparable)((Object)value.getKey().getName()), (Comparable)label);
                min = Math.min(min, value.getValue().getPercentage());
                max = Math.max(max, value.getValue().getPercentage());
            }
            if (maximumBuilds != 0 && ++n >= maximumBuilds) break;
        }
        int range = max - min;
        this.dataset = dsb.build();
        if (zoomCoverageChart) {
            this.lowerBound = min - 1;
            this.upperBound = max + (range < 5 ? 0 : 1);
        } else {
            this.lowerBound = -1;
            this.upperBound = 101;
        }
    }

    protected static boolean isZoomCoverageChart(Chartable chartable) {
        if (chartable == null) {
            return false;
        }
        CoberturaBuildAction action = (CoberturaBuildAction)chartable.getOwner().getAction(CoberturaBuildAction.class);
        boolean zoomCoverageChart = false;
        if (action != null) {
            return action.getZoomCoverageChart();
        }
        Log.warn((Object)"Couldn't find CoberturaPublisher to decide if the graph should be zoomed");
        return false;
    }

    protected static int getMaximumBuilds(Chartable chartable) {
        if (chartable == null) {
            return 0;
        }
        CoberturaBuildAction action = (CoberturaBuildAction)chartable.getOwner().getAction(CoberturaBuildAction.class);
        if (action != null) {
            return action.getMaxNumberOfBuilds();
        }
        Log.warn((Object)"Couldn't find CoberturaPublisher to decide the maximum number of builds to be graphed");
        return 0;
    }

    public JFreeChart createChart() {
        JFreeChart chart = ChartFactory.createLineChart(null, null, (String)"%", (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.BOTTOM);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperBound((double)this.upperBound);
        rangeAxis.setLowerBound((double)this.lowerBound);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseStroke((Stroke)new BasicStroke(1.5f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    protected CategoryDataset getDataset() {
        return this.dataset;
    }

    protected int getLowerBound() {
        return this.lowerBound;
    }

    protected int getUpperBound() {
        return this.upperBound;
    }
}

