/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura;

import hudson.model.Actionable;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.cobertura.BuildUtils;
import hudson.plugins.cobertura.CoberturaBuildAction;
import hudson.plugins.cobertura.Messages;
import java.io.IOException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class CoberturaProjectAction
extends Actionable
implements ProminentProjectAction {
    private transient Run<?, ?> run;
    private boolean onlyStable;

    public CoberturaProjectAction(Run<?, ?> run, boolean onlyStable) {
        this.run = run;
        this.onlyStable = onlyStable;
    }

    public CoberturaProjectAction(Run<?, ?> run) {
        this(run, false);
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getDisplayName() {
        return Messages.CoberturaProjectAction_displayName();
    }

    public String getUrlName() {
        return "cobertura";
    }

    public CoberturaBuildAction getLastResult() {
        Run<?, ?> b = this.getLastBuildToBeConsidered();
        while (b != null) {
            CoberturaBuildAction r;
            if (!(b.getResult() == Result.FAILURE || b.getResult() != Result.SUCCESS && this.onlyStable || (r = (CoberturaBuildAction)b.getAction(CoberturaBuildAction.class)) == null)) {
                return r;
            }
            b = BuildUtils.getPreviousNotFailedCompletedBuild(b);
        }
        return null;
    }

    private Run<?, ?> getLastBuildToBeConsidered() {
        return this.onlyStable ? this.run.getParent().getLastStableBuild() : this.run.getParent().getLastSuccessfulBuild();
    }

    public Integer getLastResultBuild() {
        Run<?, ?> b = this.getLastBuildToBeConsidered();
        while (b != null) {
            CoberturaBuildAction r;
            if (!(b.getResult() == Result.FAILURE || b.getResult() != Result.SUCCESS && this.onlyStable || (r = (CoberturaBuildAction)b.getAction(CoberturaBuildAction.class)) == null)) {
                return b.getNumber();
            }
            b = BuildUtils.getPreviousNotFailedCompletedBuild(b);
        }
        return null;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (this.getLastResult() != null) {
            this.getLastResult().doGraph(req, rsp);
        }
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Integer buildNumber = this.getLastResultBuild();
        if (buildNumber == null) {
            rsp.sendRedirect2("nodata");
        } else {
            rsp.sendRedirect2("../" + buildNumber + "/cobertura");
        }
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }
}

