/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.cobertura.BuildUtils;
import hudson.plugins.cobertura.Chartable;
import hudson.plugins.cobertura.CoberturaCoverageParser;
import hudson.plugins.cobertura.CoberturaProjectAction;
import hudson.plugins.cobertura.CoberturaPublisher;
import hudson.plugins.cobertura.CoverageChart;
import hudson.plugins.cobertura.Messages;
import hudson.plugins.cobertura.Ratio;
import hudson.plugins.cobertura.targets.CoverageMetric;
import hudson.plugins.cobertura.targets.CoverageResult;
import hudson.plugins.cobertura.targets.CoverageTarget;
import hudson.util.DescribableList;
import hudson.util.Graph;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import org.jfree.chart.JFreeChart;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class CoberturaBuildAction
implements HealthReportingAction,
StaplerProxy,
Chartable,
SimpleBuildStep.LastBuildAction,
RunAction2 {
    private transient Run<?, ?> owner;
    private CoverageTarget healthyTarget;
    private CoverageTarget unhealthyTarget;
    private final boolean failUnhealthy;
    private final boolean failUnstable;
    private final boolean autoUpdateHealth;
    private final boolean autoUpdateStability;
    private final boolean zoomCoverageChart;
    private final int maxNumberOfBuilds;
    private Map<CoverageMetric, Ratio> result;
    private HealthReport health = null;
    private transient WeakReference<CoverageResult> report;
    private final boolean onlyStable;
    private String failMessage = null;
    private static final Logger logger = Logger.getLogger(CoberturaBuildAction.class.getName());

    public HealthReport getBuildHealth() {
        Localizable localizedDescription;
        CoberturaPublisher publisher;
        DescribableList rootpublishers;
        if (this.health != null) {
            return this.health;
        }
        if (this.owner instanceof AbstractBuild && (rootpublishers = ((AbstractBuild)this.owner).getProject().getRootProject().getPublishersList()) != null && (publisher = (CoberturaPublisher)rootpublishers.get(CoberturaPublisher.class)) != null) {
            this.healthyTarget = publisher.getHealthyTarget();
            this.unhealthyTarget = publisher.getUnhealthyTarget();
        }
        if (this.healthyTarget == null || this.unhealthyTarget == null) {
            return null;
        }
        if (this.result == null) {
            CoverageResult projectCoverage = this.getResult();
            this.result = new EnumMap<CoverageMetric, Ratio>(CoverageMetric.class);
            this.result.putAll(projectCoverage.getResults());
        }
        Map<CoverageMetric, Integer> scores = this.healthyTarget.getRangeScores(this.unhealthyTarget, this.result);
        int minValue = 100;
        CoverageMetric minKey = null;
        for (Map.Entry<CoverageMetric, Integer> e : scores.entrySet()) {
            if (e.getValue() >= minValue) continue;
            minKey = e.getKey();
            minValue = e.getValue();
        }
        if (minKey == null) {
            if (this.result == null || this.result.size() == 0) {
                return null;
            }
            for (Map.Entry<CoverageMetric, Integer> e : scores.entrySet()) {
                minKey = e.getKey();
            }
            if (minKey != null) {
                localizedDescription = Messages._CoberturaBuildAction_description(this.result.get((Object)minKey).getPercentage(), this.result.get((Object)minKey).toString(), minKey.getName());
                this.health = new HealthReport(minValue, localizedDescription);
                return this.health;
            }
            return null;
        }
        localizedDescription = Messages._CoberturaBuildAction_description(this.result.get((Object)minKey).getPercentage(), this.result.get((Object)minKey).toString(), minKey.getName());
        this.health = new HealthReport(minValue, localizedDescription);
        return this.health;
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getDisplayName() {
        return Messages.CoberturaBuildAction_displayName();
    }

    public String getUrlName() {
        return "cobertura";
    }

    public Object getTarget() {
        return this.getResult();
    }

    @Override
    public Run<?, ?> getOwner() {
        return this.owner;
    }

    private synchronized void setOwner(Run<?, ?> owner) {
        CoverageResult r;
        this.owner = owner;
        if (this.report != null && (r = (CoverageResult)this.report.get()) != null) {
            r.setOwner(owner);
        }
    }

    public String getFailMessage() {
        return this.failMessage;
    }

    public void setFailMessage(String failMessage) {
        this.failMessage = failMessage;
    }

    @Override
    public Map<CoverageMetric, Ratio> getResults() {
        return this.result;
    }

    @Override
    public CoberturaBuildAction getPreviousResult() {
        return CoberturaBuildAction.getPreviousResult(this.owner);
    }

    static CoberturaBuildAction getPreviousResult(Run<?, ?> start) {
        CoberturaBuildAction r;
        Run<?, ?> b = start;
        do {
            if ((b = BuildUtils.getPreviousNotFailedCompletedBuild(b)) == null) {
                return null;
            }
            assert (b.getResult() != Result.FAILURE) : "We asked for the previous not failed build";
            r = (CoberturaBuildAction)b.getAction(CoberturaBuildAction.class);
            if (r == null || !r.includeOnlyStable() || b.getResult() == Result.SUCCESS) continue;
            r = null;
        } while (r == null);
        return r;
    }

    private boolean includeOnlyStable() {
        return this.onlyStable;
    }

    CoberturaBuildAction(CoverageResult r, CoverageTarget healthyTarget, CoverageTarget unhealthyTarget, boolean onlyStable, boolean failUnhealthy, boolean failUnstable, boolean autoUpdateHealth, boolean autoUpdateStability, boolean zoomCoverageChart, int maxNumberOfBuilds) {
        this.report = new WeakReference<CoverageResult>(r);
        this.healthyTarget = healthyTarget;
        this.unhealthyTarget = unhealthyTarget;
        this.onlyStable = onlyStable;
        this.failUnhealthy = failUnhealthy;
        this.failUnstable = failUnstable;
        this.autoUpdateHealth = autoUpdateHealth;
        this.autoUpdateStability = autoUpdateStability;
        this.zoomCoverageChart = zoomCoverageChart;
        this.maxNumberOfBuilds = maxNumberOfBuilds;
        if (this.result == null) {
            this.result = new EnumMap<CoverageMetric, Ratio>(CoverageMetric.class);
            this.result.putAll(r.getResults());
        }
        this.getBuildHealth();
    }

    public synchronized CoverageResult getResult() {
        CoverageResult r;
        if (this.report != null && (r = (CoverageResult)this.report.get()) != null) {
            return r;
        }
        r = null;
        for (File reportFile : CoberturaPublisher.getCoberturaReports(this.owner)) {
            try {
                r = CoberturaCoverageParser.parse(reportFile, r);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to load " + String.valueOf(reportFile), e);
            }
        }
        if (r != null) {
            r.setOwner(this.owner);
            this.report = new WeakReference<CoverageResult>(r);
            return r;
        }
        return null;
    }

    public static CoberturaBuildAction load(CoverageResult result, CoverageTarget healthyTarget, CoverageTarget unhealthyTarget, boolean onlyStable, boolean failUnhealthy, boolean failUnstable, boolean autoUpdateHealth, boolean autoUpdateStability, boolean zoomCoverageChart, int maxNumberOfBuilds) {
        return new CoberturaBuildAction(result, healthyTarget, unhealthyTarget, onlyStable, failUnhealthy, failUnstable, autoUpdateHealth, autoUpdateStability, zoomCoverageChart, maxNumberOfBuilds);
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        new Graph(this.owner.getTimestamp(), 500, 200){

            protected JFreeChart createGraph() {
                return new CoverageChart(CoberturaBuildAction.this).createChart();
            }
        }.doPng(req, rsp);
    }

    public boolean getZoomCoverageChart() {
        return this.zoomCoverageChart;
    }

    public int getMaxNumberOfBuilds() {
        return this.maxNumberOfBuilds;
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new CoberturaProjectAction(this.owner, this.onlyStable));
    }

    public void onAttached(Run<?, ?> r) {
        this.setOwner(r);
    }

    public void onLoad(Run<?, ?> r) {
        this.setOwner(r);
    }
}

