// CHECKSTYLE:OFF

package hudson.plugins.cobertura;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code CoverageColumn.empty}: {@code -}.
     * 
     * @return
     *     {@code -}
     */
    public static String CoverageColumn_empty() {
        return holder.format("CoverageColumn.empty");
    }

    /**
     * Key {@code CoverageColumn.empty}: {@code -}.
     * 
     * @return
     *     {@code -}
     */
    public static Localizable _CoverageColumn_empty() {
        return new Localizable(holder, "CoverageColumn.empty");
    }

    /**
     * Key {@code CoverageColumn.columnName}: {@code Cobertura coverage}.
     * 
     * @return
     *     {@code Cobertura coverage}
     */
    public static String CoverageColumn_columnName() {
        return holder.format("CoverageColumn.columnName");
    }

    /**
     * Key {@code CoverageColumn.columnName}: {@code Cobertura coverage}.
     * 
     * @return
     *     {@code Cobertura coverage}
     */
    public static Localizable _CoverageColumn_columnName() {
        return new Localizable(holder, "CoverageColumn.columnName");
    }

    /**
     * Key {@code CoverageColumn.columnHeader}: {@code Coverage %}.
     * 
     * @return
     *     {@code Coverage %}
     */
    public static String CoverageColumn_columnHeader() {
        return holder.format("CoverageColumn.columnHeader");
    }

    /**
     * Key {@code CoverageColumn.columnHeader}: {@code Coverage %}.
     * 
     * @return
     *     {@code Coverage %}
     */
    public static Localizable _CoverageColumn_columnHeader() {
        return new Localizable(holder, "CoverageColumn.columnHeader");
    }

    /**
     * Key {@code CoberturaCoverageParser.name}: {@code Cobertura Coverage
     * Report}.
     * 
     * @return
     *     {@code Cobertura Coverage Report}
     */
    public static String CoberturaCoverageParser_name() {
        return holder.format("CoberturaCoverageParser.name");
    }

    /**
     * Key {@code CoberturaCoverageParser.name}: {@code Cobertura Coverage
     * Report}.
     * 
     * @return
     *     {@code Cobertura Coverage Report}
     */
    public static Localizable _CoberturaCoverageParser_name() {
        return new Localizable(holder, "CoberturaCoverageParser.name");
    }

    /**
     * Key {@code MavenCoberturaAggregatedReport.displayName}: {@code
     * Coverage Report}.
     * 
     * @return
     *     {@code Coverage Report}
     */
    public static String MavenCoberturaAggregatedReport_displayName() {
        return holder.format("MavenCoberturaAggregatedReport.displayName");
    }

    /**
     * Key {@code MavenCoberturaAggregatedReport.displayName}: {@code
     * Coverage Report}.
     * 
     * @return
     *     {@code Coverage Report}
     */
    public static Localizable _MavenCoberturaAggregatedReport_displayName() {
        return new Localizable(holder, "MavenCoberturaAggregatedReport.displayName");
    }

    /**
     * Key {@code CoberturaPublisher.displayName}: {@code Publish Cobertura
     * Coverage Report}.
     * 
     * @return
     *     {@code Publish Cobertura Coverage Report}
     */
    public static String CoberturaPublisher_displayName() {
        return holder.format("CoberturaPublisher.displayName");
    }

    /**
     * Key {@code CoberturaPublisher.displayName}: {@code Publish Cobertura
     * Coverage Report}.
     * 
     * @return
     *     {@code Publish Cobertura Coverage Report}
     */
    public static Localizable _CoberturaPublisher_displayName() {
        return new Localizable(holder, "CoberturaPublisher.displayName");
    }

    /**
     * Key {@code CoberturaProjectAction.displayName}: {@code Coverage
     * Report}.
     * 
     * @return
     *     {@code Coverage Report}
     */
    public static String CoberturaProjectAction_displayName() {
        return holder.format("CoberturaProjectAction.displayName");
    }

    /**
     * Key {@code CoberturaProjectAction.displayName}: {@code Coverage
     * Report}.
     * 
     * @return
     *     {@code Coverage Report}
     */
    public static Localizable _CoberturaProjectAction_displayName() {
        return new Localizable(holder, "CoberturaProjectAction.displayName");
    }

    /**
     * Key {@code CoberturaBuildAction.description}: {@code Cobertura
     * Coverage: {0}% ({1}) {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cobertura Coverage: {0}% ({1}) {2}}
     */
    public static String CoberturaBuildAction_description(Object arg0, Object arg1, Object arg2) {
        return holder.format("CoberturaBuildAction.description", arg0, arg1, arg2);
    }

    /**
     * Key {@code CoberturaBuildAction.description}: {@code Cobertura
     * Coverage: {0}% ({1}) {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cobertura Coverage: {0}% ({1}) {2}}
     */
    public static Localizable _CoberturaBuildAction_description(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "CoberturaBuildAction.description", arg0, arg1, arg2);
    }

    /**
     * Key {@code MavenCoberturaPublisher.displayName}: {@code Publish
     * Cobertura Coverage Report}.
     * 
     * @return
     *     {@code Publish Cobertura Coverage Report}
     */
    public static String MavenCoberturaPublisher_displayName() {
        return holder.format("MavenCoberturaPublisher.displayName");
    }

    /**
     * Key {@code MavenCoberturaPublisher.displayName}: {@code Publish
     * Cobertura Coverage Report}.
     * 
     * @return
     *     {@code Publish Cobertura Coverage Report}
     */
    public static Localizable _MavenCoberturaPublisher_displayName() {
        return new Localizable(holder, "MavenCoberturaPublisher.displayName");
    }

    /**
     * Key {@code CoverageColumn.line}: {@code {0}%}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0}%}
     */
    public static String CoverageColumn_line(Object arg0) {
        return holder.format("CoverageColumn.line", arg0);
    }

    /**
     * Key {@code CoverageColumn.line}: {@code {0}%}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0}%}
     */
    public static Localizable _CoverageColumn_line(Object arg0) {
        return new Localizable(holder, "CoverageColumn.line", arg0);
    }

    /**
     * Key {@code CoberturaBuildAction.displayName}: {@code Coverage Report}.
     * 
     * @return
     *     {@code Coverage Report}
     */
    public static String CoberturaBuildAction_displayName() {
        return holder.format("CoberturaBuildAction.displayName");
    }

    /**
     * Key {@code CoberturaBuildAction.displayName}: {@code Coverage Report}.
     * 
     * @return
     *     {@code Coverage Report}
     */
    public static Localizable _CoberturaBuildAction_displayName() {
        return new Localizable(holder, "CoberturaBuildAction.displayName");
    }

    /**
     * Key {@code CoverageColumn.both}: {@code L:{0}% - B:{1}%}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code L:{0}% - B:{1}%}
     */
    public static String CoverageColumn_both(Object arg0, Object arg1) {
        return holder.format("CoverageColumn.both", arg0, arg1);
    }

    /**
     * Key {@code CoverageColumn.both}: {@code L:{0}% - B:{1}%}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code L:{0}% - B:{1}%}
     */
    public static Localizable _CoverageColumn_both(Object arg0, Object arg1) {
        return new Localizable(holder, "CoverageColumn.both", arg0, arg1);
    }

    /**
     * Key {@code CoverageColumn.branch}: {@code {0}%}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0}%}
     */
    public static String CoverageColumn_branch(Object arg0) {
        return holder.format("CoverageColumn.branch", arg0);
    }

    /**
     * Key {@code CoverageColumn.branch}: {@code {0}%}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0}%}
     */
    public static Localizable _CoverageColumn_branch(Object arg0) {
        return new Localizable(holder, "CoverageColumn.branch", arg0);
    }

}
