/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover.results;

import hudson.model.Run;
import hudson.plugins.clover.CloverBuildAction;
import hudson.plugins.clover.Ratio;
import hudson.plugins.clover.graphs.GraphImpl;
import hudson.plugins.clover.results.Messages;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import java.util.Calendar;

public abstract class AbstractCloverMetrics {
    private String name;
    private int methods;
    private int coveredmethods;
    private int conditionals;
    private int coveredconditionals;
    private int statements;
    private int coveredstatements;
    private int elements;
    private int coveredelements;
    private Run<?, ?> owner = null;

    public Ratio getMethodCoverage() {
        return Ratio.create(this.coveredmethods, this.methods);
    }

    public Ratio getConditionalCoverage() {
        return Ratio.create(this.coveredconditionals, this.conditionals);
    }

    public Ratio getStatementCoverage() {
        return Ratio.create(this.coveredstatements, this.statements);
    }

    public Ratio getElementCoverage() {
        return Ratio.create(this.coveredelements, this.elements);
    }

    public int getConditionals() {
        return this.conditionals;
    }

    public void setConditionals(int conditionals) {
        this.conditionals = conditionals;
    }

    public int getMethods() {
        return this.methods;
    }

    public void setMethods(int methods) {
        this.methods = methods;
    }

    public int getCoveredstatements() {
        return this.coveredstatements;
    }

    public void setCoveredstatements(int coveredstatements) {
        this.coveredstatements = coveredstatements;
    }

    public int getCoveredmethods() {
        return this.coveredmethods;
    }

    public void setCoveredmethods(int coveredmethods) {
        this.coveredmethods = coveredmethods;
    }

    public int getCoveredconditionals() {
        return this.coveredconditionals;
    }

    public void setCoveredconditionals(int coveredconditionals) {
        this.coveredconditionals = coveredconditionals;
    }

    public int getStatements() {
        return this.statements;
    }

    public void setStatements(int statements) {
        this.statements = statements;
    }

    public int getCoveredelements() {
        return this.coveredelements;
    }

    public void setCoveredelements(int coveredelements) {
        this.coveredelements = coveredelements;
    }

    public int getElements() {
        return this.elements;
    }

    public void setElements(int elements) {
        this.elements = elements;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Run<?, ?> getOwner() {
        return this.owner;
    }

    public void setOwner(Run<?, ?> owner) {
        this.owner = owner;
    }

    public abstract AbstractCloverMetrics getPreviousResult();

    protected CloverBuildAction getPreviousCloverBuildAction() {
        if (this.owner == null) {
            return null;
        }
        Run prevBuild = this.owner.getPreviousBuild();
        if (prevBuild == null) {
            return null;
        }
        CloverBuildAction action = (CloverBuildAction)prevBuild.getAction(CloverBuildAction.class);
        while (action == null && prevBuild != null) {
            if ((prevBuild = prevBuild.getPreviousBuild()) == null) continue;
            action = (CloverBuildAction)prevBuild.getAction(CloverBuildAction.class);
        }
        return action;
    }

    public Graph getTrendGraph() {
        Run<?, ?> build = this.getOwner();
        Calendar t = build.getTimestamp();
        return new GraphImpl(this, t){

            @Override
            protected DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> createDataSet(AbstractCloverMetrics metrics) {
                DataSetBuilder dsb = new DataSetBuilder();
                for (AbstractCloverMetrics m = metrics; m != null; m = m.getPreviousResult()) {
                    ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(m.getOwner());
                    dsb.add((Number)Float.valueOf(m.getMethodCoverage().getPercentageFloat()), (Comparable)((Object)Messages.AbstractCloverMetrics_Label_method()), (Comparable)label);
                    dsb.add((Number)Float.valueOf(m.getConditionalCoverage().getPercentageFloat()), (Comparable)((Object)Messages.AbstractCloverMetrics_Label_conditional()), (Comparable)label);
                    dsb.add((Number)Float.valueOf(m.getStatementCoverage().getPercentageFloat()), (Comparable)((Object)Messages.AbstractCloverMetrics_Label_statement()), (Comparable)label);
                }
                return dsb;
            }
        };
    }
}

