/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.clover.CloverBuildAction;
import hudson.plugins.clover.CloverCoverageParser;
import hudson.plugins.clover.CloverHtmlBuildAction;
import hudson.plugins.clover.Messages;
import hudson.plugins.clover.results.ProjectCoverage;
import hudson.plugins.clover.slave.GetPathFileCallable;
import hudson.plugins.clover.targets.CoverageMetric;
import hudson.plugins.clover.targets.CoverageTarget;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;

public class CloverPublisher
extends Recorder
implements SimpleBuildStep {
    private static final Pattern VALID_REPORT_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]{1,50}$");
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private final String cloverReportDir;
    private final String cloverReportFileName;
    private String reportId;
    private CoverageTarget healthyTarget;
    private CoverageTarget unhealthyTarget;
    private CoverageTarget failingTarget;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public CloverPublisher(String cloverReportDir, String cloverReportFileName) {
        this.cloverReportDir = cloverReportDir;
        this.cloverReportFileName = cloverReportFileName;
        this.reportId = "";
        this.healthyTarget = new CoverageTarget();
        this.unhealthyTarget = new CoverageTarget();
        this.failingTarget = new CoverageTarget();
    }

    @DataBoundConstructor
    public CloverPublisher(String cloverReportDir, String cloverReportFileName, CoverageTarget healthyTarget, CoverageTarget unhealthyTarget, CoverageTarget failingTarget) {
        this.cloverReportDir = cloverReportDir;
        this.cloverReportFileName = cloverReportFileName;
        this.reportId = CloverPublisher.generateUniqueReportId();
        this.healthyTarget = healthyTarget;
        this.unhealthyTarget = unhealthyTarget;
        this.failingTarget = failingTarget;
    }

    public String getCloverReportDir() {
        return this.cloverReportDir;
    }

    public String getCloverReportFileName() {
        return this.cloverReportFileName == null || this.cloverReportFileName.trim().length() == 0 ? "clover.xml" : this.cloverReportFileName;
    }

    public String getReportId() {
        return this.reportId;
    }

    @DataBoundSetter
    public void setReportId(String reportId) {
        if (reportId != null && !reportId.trim().isEmpty()) {
            String trimmed = reportId.trim();
            if (!VALID_REPORT_ID_PATTERN.matcher(trimmed).matches()) {
                throw new IllegalArgumentException("Invalid reportId '" + trimmed + "': must contain only letters, numbers, hyphens, and underscores (1-100 characters). Invalid characters detected. Valid examples: 'app1', 'backend-service', 'web_ui_123'");
            }
            this.reportId = trimmed;
        }
    }

    public CoverageTarget getHealthyTarget() {
        return this.healthyTarget;
    }

    public void setHealthyTarget(CoverageTarget healthyTarget) {
        this.healthyTarget = healthyTarget;
    }

    public CoverageTarget getUnhealthyTarget() {
        return this.unhealthyTarget;
    }

    public void setUnhealthyTarget(CoverageTarget unhealthyTarget) {
        this.unhealthyTarget = unhealthyTarget;
    }

    public CoverageTarget getFailingTarget() {
        return this.failingTarget;
    }

    public void setFailingTarget(CoverageTarget failingTarget) {
        this.failingTarget = failingTarget;
    }

    static File getCloverXmlReport(Run<?, ?> build) {
        return new File(build.getRootDir(), "clover.xml");
    }

    static File getCloverXmlReport(Run<?, ?> build, String reportId) {
        return new File(build.getRootDir(), CloverPublisher.getCloverXmlFileName(reportId));
    }

    private static String getCloverXmlFileName(String reportId) {
        return reportId == null || reportId.isEmpty() ? "clover.xml" : "clover-" + reportId + ".xml";
    }

    static String forReport(String reportId) {
        return reportId == null || reportId.isEmpty() ? "" : " for " + reportId;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        this.performImpl(run, workspace, listener);
    }

    private void performImpl(Run<?, ?> run, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        EnvVars env = run.getEnvironment(listener);
        File buildRootDir = run.getRootDir();
        FilePath buildTarget = new FilePath(buildRootDir);
        String reportDir = env.expand(this.cloverReportDir);
        FilePath coverageReportDir = workspace.child(reportDir);
        try {
            boolean missingReport;
            Result result;
            listener.getLogger().println("Publishing Clover coverage report...");
            if (!coverageReportDir.exists()) {
                coverageReportDir = this.findOneDirDeep(workspace, reportDir);
            }
            boolean buildFailure = (result = run.getResult()) != null && result.isWorseOrEqualTo(Result.FAILURE);
            boolean bl = missingReport = !coverageReportDir.exists();
            if (buildFailure || missingReport) {
                listener.getLogger().println("No Clover report will be published due to a " + (buildFailure ? "build Failure" : "missing report"));
                return;
            }
            boolean htmlExists = this.copyHtmlReport(coverageReportDir, buildTarget, listener);
            this.copyXmlReport(coverageReportDir, buildTarget, listener, env.expand(this.getCloverReportFileName()));
            if (htmlExists) {
                run.addAction((Action)new CloverHtmlBuildAction());
            }
            this.processCloverXml(run, workspace, listener, coverageReportDir, buildTarget);
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("Unable to copy coverage from " + String.valueOf(coverageReportDir) + " to " + String.valueOf(buildTarget)));
            run.setResult(Result.FAILURE);
        }
    }

    private void processCloverXml(Run<?, ?> build, FilePath workspace, TaskListener listener, FilePath coverageReport, FilePath buildTarget) throws InterruptedException {
        listener.getLogger().println(String.format("Processing Clover XML report%s ...", CloverPublisher.forReport(this.reportId)));
        String workspacePath = this.withTrailingSeparator(this.getWorkspacePath(listener, workspace));
        File cloverXmlReport = CloverPublisher.getCloverXmlReport(build, this.reportId);
        if (cloverXmlReport.exists()) {
            ProjectCoverage result = null;
            try {
                result = CloverCoverageParser.parse(cloverXmlReport, workspacePath);
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("Unable to copy coverage from " + String.valueOf(coverageReport) + " to " + String.valueOf(buildTarget)));
                build.setResult(Result.FAILURE);
            }
            listener.getLogger().println(String.format("Publishing Clover coverage results%s...", CloverPublisher.forReport(this.reportId)));
            build.addAction((Action)CloverBuildAction.load(workspacePath, result, this.reportId, this.healthyTarget, this.unhealthyTarget));
            Set<CoverageMetric> failingMetrics = this.getFailingMetrics(result);
            if (!failingMetrics.isEmpty()) {
                this.logFailingMetrics(listener, failingMetrics);
                build.setResult(Result.UNSTABLE);
            }
        } else {
            this.flagMissingCloverXml(listener);
        }
    }

    @NonNull
    private String getWorkspacePath(TaskListener listener, FilePath workspace) throws InterruptedException {
        try {
            return (String)workspace.act((FilePath.FileCallable)new GetPathFileCallable());
        }
        catch (IOException e) {
            listener.getLogger().println("IOException when checking workspace path:" + e.getMessage());
            return "";
        }
    }

    @NonNull
    private String withTrailingSeparator(@NonNull String path) {
        return path.endsWith(File.separator) ? path : path + File.separator;
    }

    @NonNull
    private Set<CoverageMetric> getFailingMetrics(ProjectCoverage result) {
        return this.failingTarget != null ? this.failingTarget.getFailingMetrics(result) : Collections.emptySet();
    }

    private void logFailingMetrics(TaskListener listener, Set<CoverageMetric> failingMetrics) {
        listener.getLogger().println("Code coverage enforcement failed for the following metrics:");
        for (CoverageMetric metric : failingMetrics) {
            listener.getLogger().println("    " + String.valueOf((Object)metric));
        }
        listener.getLogger().println("Setting Build to unstable.");
    }

    private boolean copyXmlReport(FilePath coverageReport, FilePath buildTarget, TaskListener listener, String fileName) throws IOException, InterruptedException {
        FilePath cloverXmlPath = this.findOneDirDeep(coverageReport, fileName);
        if (!cloverXmlPath.exists()) {
            listener.getLogger().printf("Clover XML file '%s' does not exist in '%s' and was not copied!%n", fileName, coverageReport);
            return false;
        }
        listener.getLogger().println(String.format("Publishing Clover XML report%s...", CloverPublisher.forReport(this.reportId)));
        String targetFileName = CloverPublisher.getCloverXmlFileName(this.reportId);
        FilePath toFile = buildTarget.child(targetFileName);
        cloverXmlPath.copyTo(toFile);
        return true;
    }

    private boolean copyHtmlReport(FilePath coverageReport, FilePath buildTarget, TaskListener listener) throws IOException, InterruptedException {
        FilePath htmlIndexHtmlPath = this.findOneDirDeep(coverageReport, "index.html");
        if (!htmlIndexHtmlPath.exists()) {
            listener.getLogger().printf("Clover HTML report '%s' does not exist and was not copied!%n", coverageReport);
            return false;
        }
        FilePath htmlDirPath = htmlIndexHtmlPath.getParent();
        if (htmlDirPath == null) {
            listener.getLogger().println("Parent directory of " + htmlIndexHtmlPath.getRemote() + " is null, not publishing Clover HTML report.");
            return false;
        }
        listener.getLogger().println("Publishing Clover HTML report...");
        htmlDirPath.copyRecursiveTo("**/*", buildTarget);
        return true;
    }

    private FilePath findOneDirDeep(FilePath startDir, String filename) throws IOException, InterruptedException {
        List dirs;
        FilePath dirContainingFile = startDir;
        if (!dirContainingFile.child(filename).exists() && (dirs = dirContainingFile.listDirectories()) != null) {
            for (FilePath dir : dirs) {
                if (!dir.child(filename).exists()) continue;
                dirContainingFile = dir;
                break;
            }
        }
        return dirContainingFile.child(filename);
    }

    private void flagMissingCloverXml(TaskListener listener) {
        listener.getLogger().println("Could not find '" + this.cloverReportDir + "/" + this.getCloverReportFileName() + "'.  Did you generate the XML report for Clover?");
    }

    private static String generateUniqueReportId() {
        long min = 78364164096L;
        long max = 2821109907455L;
        long range = max - min + 1L;
        long randomValue = min + Math.abs(SECURE_RANDOM.nextLong() % range);
        return Long.toString(randomValue, 36);
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    protected Object readResolve() {
        if (this.reportId == null || this.reportId.isEmpty()) {
            this.reportId = "";
        }
        return this;
    }

    @Symbol(value={"clover"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        DescriptorImpl() {
            super(CloverPublisher.class);
        }

        @NonNull
        public String getDisplayName() {
            return Messages.CloverPublisher_DisplayName();
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            req.bindParameters((Object)this, "clover.");
            this.save();
            return super.configure(req, formData);
        }

        public CloverPublisher newInstance(@NonNull StaplerRequest2 req, @NonNull JSONObject formData) {
            CloverPublisher instance = new CloverPublisher(req.getParameter("clover.cloverReportDir"), req.getParameter("clover.cloverReportFileName"), this.fromRequest(req, "cloverHealthyTarget."), this.fromRequest(req, "cloverUnhealthyTarget."), this.fromRequest(req, "cloverFailingTarget."));
            String id = DescriptorImpl.getReportIdFromRequest(req);
            if (id != null && !id.isEmpty()) {
                instance.setReportId(id);
            }
            if (instance.healthyTarget.isEmpty()) {
                instance.healthyTarget = new CoverageTarget(70, 80, 80);
            }
            return instance;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        private CoverageTarget fromRequest(StaplerRequest2 req, String namePrefix) {
            return new CoverageTarget(this.getIntParameter(req, namePrefix + "methodCoverage"), this.getIntParameter(req, namePrefix + "conditionalCoverage"), this.getIntParameter(req, namePrefix + "statementCoverage"));
        }

        private static String getReportIdFromRequest(@NonNull StaplerRequest2 req) {
            String reportIdStr = req.getParameter("clover.reportId");
            if (reportIdStr != null && !reportIdStr.trim().isEmpty()) {
                return reportIdStr.trim();
            }
            return null;
        }

        private Integer getIntParameter(StaplerRequest2 req, String name) {
            try {
                return Integer.valueOf(req.getParameter(name));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }
}

