/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import hudson.model.Action;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.clover.CloverCoverageParser;
import hudson.plugins.clover.CloverProjectAction;
import hudson.plugins.clover.CloverPublisher;
import hudson.plugins.clover.Messages;
import hudson.plugins.clover.Ratio;
import hudson.plugins.clover.results.AbstractPackageAggregatedMetrics;
import hudson.plugins.clover.results.ClassCoverage;
import hudson.plugins.clover.results.FileCoverage;
import hudson.plugins.clover.results.PackageCoverage;
import hudson.plugins.clover.results.ProjectCoverage;
import hudson.plugins.clover.targets.CoverageMetric;
import hudson.plugins.clover.targets.CoverageTarget;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import org.jetbrains.annotations.NotNull;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.StaplerProxy;

public class CloverBuildAction
extends AbstractPackageAggregatedMetrics
implements HealthReportingAction,
StaplerProxy,
RunAction2,
SimpleBuildStep.LastBuildAction {
    private transient Run<?, ?> owner;
    private String buildBaseDir;
    private final CoverageTarget healthyTarget;
    private final CoverageTarget unhealthyTarget;
    private transient List<CloverProjectAction> projectActions;
    private static final CacheLoader<CloverBuildAction, ProjectCoverage> coverageCacheLoader = new CacheLoader<CloverBuildAction, ProjectCoverage>(){

        public ProjectCoverage load(@NotNull CloverBuildAction k) throws IOException {
            return k.computeResult();
        }
    };
    private static final LoadingCache<CloverBuildAction, ProjectCoverage> reports = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(60L, TimeUnit.MINUTES).build(coverageCacheLoader);
    private static final Logger logger = Logger.getLogger(CloverBuildAction.class.getName());

    static void invalidateReportCache() {
        reports.invalidateAll();
    }

    public HealthReport getBuildHealth() {
        Localizable description;
        if (this.healthyTarget == null || this.unhealthyTarget == null) {
            return null;
        }
        ProjectCoverage projectCoverage = this.getResult();
        Map<CoverageMetric, Integer> scores = this.healthyTarget.getRangeScores(this.unhealthyTarget, projectCoverage);
        int minValue = 100;
        Enum minKey = null;
        for (Map.Entry<CoverageMetric, Integer> e : scores.entrySet()) {
            if (e.getValue() >= minValue) continue;
            minKey = e.getKey();
            minValue = e.getValue();
        }
        if (minKey == null) {
            return null;
        }
        switch (2.$SwitchMap$hudson$plugins$clover$targets$CoverageMetric[minKey.ordinal()]) {
            case 1: {
                description = Messages._CloverBuildAction_MethodCoverage(projectCoverage.getMethodCoverage().getPercentage(), projectCoverage.getMethodCoverage().toString());
                break;
            }
            case 2: {
                description = Messages._CloverBuildAction_ConditionalCoverage(projectCoverage.getConditionalCoverage().getPercentage(), projectCoverage.getConditionalCoverage().toString());
                break;
            }
            case 3: {
                description = Messages._CloverBuildAction_StatementCoverage(projectCoverage.getStatementCoverage().getPercentage(), projectCoverage.getStatementCoverage().toString());
                break;
            }
            case 4: {
                description = Messages._CloverBuildAction_ElementCoverage(projectCoverage.getElementCoverage().getPercentage(), projectCoverage.getElementCoverage().toString());
                break;
            }
            default: {
                return null;
            }
        }
        return new HealthReport(minValue, description);
    }

    public String getIconFileName() {
        return "/plugin/clover/clover_48x48.png";
    }

    public String getDisplayName() {
        return Messages.CloverBuildAction_DisplayName();
    }

    public String getUrlName() {
        return "clover";
    }

    public Object getTarget() {
        return this.getResult();
    }

    @Override
    public CloverBuildAction getPreviousResult() {
        return this.getPreviousResult(this.owner);
    }

    private CloverBuildAction getPreviousResult(Run<?, ?> start) {
        CloverBuildAction r;
        Run b = start;
        do {
            if ((b = b.getPreviousBuild()) != null) continue;
            return null;
        } while (b.getResult() == Result.FAILURE || (r = (CloverBuildAction)b.getAction(CloverBuildAction.class)) == null);
        return r;
    }

    private List<CloverProjectAction> getActions() {
        if (this.projectActions == null) {
            this.projectActions = new ArrayList<CloverProjectAction>();
        }
        return this.projectActions;
    }

    CloverBuildAction(String workspacePath, ProjectCoverage r, CoverageTarget healthyTarget, CoverageTarget unhealthyTarget) {
        if (r != null) {
            reports.put((Object)this, (Object)r);
        }
        this.projectActions = new ArrayList<CloverProjectAction>();
        this.buildBaseDir = workspacePath;
        if (this.buildBaseDir == null) {
            this.buildBaseDir = File.separator;
        } else if (!this.buildBaseDir.endsWith(File.separator)) {
            this.buildBaseDir = this.buildBaseDir + File.separator;
        }
        this.healthyTarget = healthyTarget;
        this.unhealthyTarget = unhealthyTarget;
    }

    public void onAttached(Run<?, ?> build) {
        this.owner = build;
        ProjectCoverage c = (ProjectCoverage)reports.getIfPresent((Object)this);
        if (c != null) {
            c.setOwner(build);
        }
        this.getActions().add(new CloverProjectAction(build.getParent()));
    }

    public void onLoad(Run<?, ?> r) {
        this.owner = r;
        this.getActions().add(new CloverProjectAction(r.getParent()));
    }

    public synchronized ProjectCoverage getResult() {
        try {
            return (ProjectCoverage)reports.get((Object)this);
        }
        catch (ExecutionException e) {
            logger.log(Level.WARNING, "Failed to load " + String.valueOf(CloverPublisher.getCloverXmlReport(this.owner)), e);
            return null;
        }
    }

    private ProjectCoverage computeResult() throws IOException {
        File reportFile = CloverPublisher.getCloverXmlReport(this.owner);
        ProjectCoverage r = CloverCoverageParser.parse(reportFile, this.buildBaseDir);
        r.setOwner(this.owner);
        return r;
    }

    @Override
    public PackageCoverage findPackageCoverage(String name) {
        return this.getResult().findPackageCoverage(name);
    }

    @Override
    public FileCoverage findFileCoverage(String name) {
        return this.getResult().findFileCoverage(name);
    }

    @Override
    public ClassCoverage findClassCoverage(String name) {
        return this.getResult().findClassCoverage(name);
    }

    @Override
    public int getPackages() {
        return this.getResult().getPackages();
    }

    @Override
    public int getFiles() {
        return this.getResult().getFiles();
    }

    @Override
    public int getClasses() {
        return this.getResult().getClasses();
    }

    @Override
    public int getLoc() {
        return this.getResult().getLoc();
    }

    @Override
    public int getNcloc() {
        return this.getResult().getNcloc();
    }

    @Override
    public Ratio getMethodCoverage() {
        return this.getResult().getMethodCoverage();
    }

    @Override
    public Ratio getStatementCoverage() {
        return this.getResult().getStatementCoverage();
    }

    @Override
    public Ratio getConditionalCoverage() {
        return this.getResult().getConditionalCoverage();
    }

    @Override
    public Ratio getElementCoverage() {
        return this.getResult().getElementCoverage();
    }

    @Override
    public int getConditionals() {
        return this.getResult().getConditionals();
    }

    @Override
    public int getMethods() {
        return this.getResult().getMethods();
    }

    @Override
    public int getCoveredstatements() {
        return this.getResult().getCoveredstatements();
    }

    @Override
    public int getCoveredmethods() {
        return this.getResult().getCoveredmethods();
    }

    @Override
    public int getCoveredconditionals() {
        return this.getResult().getCoveredconditionals();
    }

    @Override
    public int getStatements() {
        return this.getResult().getStatements();
    }

    @Override
    public int getCoveredelements() {
        return this.getResult().getCoveredelements();
    }

    @Override
    public int getElements() {
        return this.getResult().getElements();
    }

    public Collection<? extends Action> getProjectActions() {
        return this.getActions();
    }

    public static CloverBuildAction load(String workspacePath, ProjectCoverage result, CoverageTarget healthyTarget, CoverageTarget unhealthyTarget) {
        return new CloverBuildAction(workspacePath, result, healthyTarget, unhealthyTarget);
    }
}

