// CHECKSTYLE:OFF

package hudson.plugins.clover;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code CloverBuildWrapper.DisplayName}: {@code Automatically
     * record and report code coverage using OpenClover. Currently for Ant
     * builds only.}.
     * 
     * @return
     *     {@code Automatically record and report code coverage using OpenClover.
     *     Currently for Ant builds only.}
     */
    public static String CloverBuildWrapper_DisplayName() {
        return holder.format("CloverBuildWrapper.DisplayName");
    }

    /**
     * Key {@code CloverBuildWrapper.DisplayName}: {@code Automatically
     * record and report code coverage using OpenClover. Currently for Ant
     * builds only.}.
     * 
     * @return
     *     {@code Automatically record and report code coverage using OpenClover.
     *     Currently for Ant builds only.}
     */
    public static Localizable _CloverBuildWrapper_DisplayName() {
        return new Localizable(holder, "CloverBuildWrapper.DisplayName");
    }

    /**
     * Key {@code CloverBuildAction.StatementCoverage}: {@code OpenClover
     * Coverage: Statements {0}% ({1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code OpenClover Coverage: Statements {0}% ({1})}
     */
    public static String CloverBuildAction_StatementCoverage(Object arg0, Object arg1) {
        return holder.format("CloverBuildAction.StatementCoverage", arg0, arg1);
    }

    /**
     * Key {@code CloverBuildAction.StatementCoverage}: {@code OpenClover
     * Coverage: Statements {0}% ({1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code OpenClover Coverage: Statements {0}% ({1})}
     */
    public static Localizable _CloverBuildAction_StatementCoverage(Object arg0, Object arg1) {
        return new Localizable(holder, "CloverBuildAction.StatementCoverage", arg0, arg1);
    }

    /**
     * Key {@code CloverBuildAction.DisplayName}: {@code OpenClover summary
     * report}.
     * 
     * @return
     *     {@code OpenClover summary report}
     */
    public static String CloverBuildAction_DisplayName() {
        return holder.format("CloverBuildAction.DisplayName");
    }

    /**
     * Key {@code CloverBuildAction.DisplayName}: {@code OpenClover summary
     * report}.
     * 
     * @return
     *     {@code OpenClover summary report}
     */
    public static Localizable _CloverBuildAction_DisplayName() {
        return new Localizable(holder, "CloverBuildAction.DisplayName");
    }

    /**
     * Key {@code CloverProjectAction.PDF.DisplayName}: {@code OpenClover PDF
     * coverage report}.
     * 
     * @return
     *     {@code OpenClover PDF coverage report}
     */
    public static String CloverProjectAction_PDF_DisplayName() {
        return holder.format("CloverProjectAction.PDF.DisplayName");
    }

    /**
     * Key {@code CloverProjectAction.PDF.DisplayName}: {@code OpenClover PDF
     * coverage report}.
     * 
     * @return
     *     {@code OpenClover PDF coverage report}
     */
    public static Localizable _CloverProjectAction_PDF_DisplayName() {
        return new Localizable(holder, "CloverProjectAction.PDF.DisplayName");
    }

    /**
     * Key {@code CloverPublisher.DisplayName}: {@code Publish OpenClover
     * coverage report}.
     * 
     * @return
     *     {@code Publish OpenClover coverage report}
     */
    public static String CloverPublisher_DisplayName() {
        return holder.format("CloverPublisher.DisplayName");
    }

    /**
     * Key {@code CloverPublisher.DisplayName}: {@code Publish OpenClover
     * coverage report}.
     * 
     * @return
     *     {@code Publish OpenClover coverage report}
     */
    public static Localizable _CloverPublisher_DisplayName() {
        return new Localizable(holder, "CloverPublisher.DisplayName");
    }

    /**
     * Key {@code CloverBuildAction.ConditionalCoverage}: {@code OpenClover
     * Coverage: Conditionals {0}% ({1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code OpenClover Coverage: Conditionals {0}% ({1})}
     */
    public static String CloverBuildAction_ConditionalCoverage(Object arg0, Object arg1) {
        return holder.format("CloverBuildAction.ConditionalCoverage", arg0, arg1);
    }

    /**
     * Key {@code CloverBuildAction.ConditionalCoverage}: {@code OpenClover
     * Coverage: Conditionals {0}% ({1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code OpenClover Coverage: Conditionals {0}% ({1})}
     */
    public static Localizable _CloverBuildAction_ConditionalCoverage(Object arg0, Object arg1) {
        return new Localizable(holder, "CloverBuildAction.ConditionalCoverage", arg0, arg1);
    }

    /**
     * Key {@code CloverBuildAction.ElementCoverage}: {@code OpenClover
     * Coverage: Elements {0}% ({1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code OpenClover Coverage: Elements {0}% ({1})}
     */
    public static String CloverBuildAction_ElementCoverage(Object arg0, Object arg1) {
        return holder.format("CloverBuildAction.ElementCoverage", arg0, arg1);
    }

    /**
     * Key {@code CloverBuildAction.ElementCoverage}: {@code OpenClover
     * Coverage: Elements {0}% ({1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code OpenClover Coverage: Elements {0}% ({1})}
     */
    public static Localizable _CloverBuildAction_ElementCoverage(Object arg0, Object arg1) {
        return new Localizable(holder, "CloverBuildAction.ElementCoverage", arg0, arg1);
    }

    /**
     * Key {@code CloverBuildAction.MethodCoverage}: {@code OpenClover
     * Coverage: Methods {0}% ({1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code OpenClover Coverage: Methods {0}% ({1})}
     */
    public static String CloverBuildAction_MethodCoverage(Object arg0, Object arg1) {
        return holder.format("CloverBuildAction.MethodCoverage", arg0, arg1);
    }

    /**
     * Key {@code CloverBuildAction.MethodCoverage}: {@code OpenClover
     * Coverage: Methods {0}% ({1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code OpenClover Coverage: Methods {0}% ({1})}
     */
    public static Localizable _CloverBuildAction_MethodCoverage(Object arg0, Object arg1) {
        return new Localizable(holder, "CloverBuildAction.MethodCoverage", arg0, arg1);
    }

    /**
     * Key {@code CloverHtmlBuildAction.DisplayName}: {@code OpenClover HTML
     * Report}.
     * 
     * @return
     *     {@code OpenClover HTML Report}
     */
    public static String CloverHtmlBuildAction_DisplayName() {
        return holder.format("CloverHtmlBuildAction.DisplayName");
    }

    /**
     * Key {@code CloverHtmlBuildAction.DisplayName}: {@code OpenClover HTML
     * Report}.
     * 
     * @return
     *     {@code OpenClover HTML Report}
     */
    public static Localizable _CloverHtmlBuildAction_DisplayName() {
        return new Localizable(holder, "CloverHtmlBuildAction.DisplayName");
    }

    /**
     * Key {@code CloverProjectAction.HTML.DisplayName}: {@code OpenClover
     * HTML coverage report}.
     * 
     * @return
     *     {@code OpenClover HTML coverage report}
     */
    public static String CloverProjectAction_HTML_DisplayName() {
        return holder.format("CloverProjectAction.HTML.DisplayName");
    }

    /**
     * Key {@code CloverProjectAction.HTML.DisplayName}: {@code OpenClover
     * HTML coverage report}.
     * 
     * @return
     *     {@code OpenClover HTML coverage report}
     */
    public static Localizable _CloverProjectAction_HTML_DisplayName() {
        return new Localizable(holder, "CloverProjectAction.HTML.DisplayName");
    }

    /**
     * Key {@code CloverProjectAction.XML.DisplayName}: {@code Coverage
     * report}.
     * 
     * @return
     *     {@code Coverage report}
     */
    public static String CloverProjectAction_XML_DisplayName() {
        return holder.format("CloverProjectAction.XML.DisplayName");
    }

    /**
     * Key {@code CloverProjectAction.XML.DisplayName}: {@code Coverage
     * report}.
     * 
     * @return
     *     {@code Coverage report}
     */
    public static Localizable _CloverProjectAction_XML_DisplayName() {
        return new Localizable(holder, "CloverProjectAction.XML.DisplayName");
    }

}
