/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.advisor.casc;

import com.cloudbees.jenkins.plugins.advisor.AdvisorGlobalConfiguration;
import com.cloudbees.jenkins.plugins.advisor.client.model.Recipient;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.RootElementConfigurator;
import io.jenkins.plugins.casc.SecretSourceResolver;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import io.jenkins.plugins.casc.model.Scalar;
import io.jenkins.plugins.casc.model.Sequence;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang.BooleanUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension(optional=true)
@Restricted(value={NoExternalUse.class})
public class AdvisorRootConfigurator
extends BaseConfigurator<AdvisorGlobalConfiguration>
implements RootElementConfigurator<AdvisorGlobalConfiguration> {
    static final String ACCEPT_TOS_ATTR = "acceptToS";
    static final String EMAIL_ATTR = "email";
    static final String CCS_ATTR = "ccs";
    static final String EXCLUDED_COMPONENTS_ATTR = "excludedComponents";
    static final String NAG_DISABLED_ATTR = "nagDisabled";
    private static final Logger LOG = Logger.getLogger(AdvisorRootConfigurator.class.getName());

    @NonNull
    public String getName() {
        return "advisor";
    }

    public String getDisplayName() {
        return this.getConfiguration().getDisplayName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AdvisorGlobalConfiguration instance(Mapping mapping, ConfigurationContext configurationContext) throws ConfiguratorException {
        String email = configurationContext.getSecretSourceResolver().resolve(mapping.get((Object)EMAIL_ATTR) != null ? mapping.getScalarValue(EMAIL_ATTR) : "");
        boolean nagDisabled = mapping.get((Object)NAG_DISABLED_ATTR) != null && BooleanUtils.toBoolean((String)mapping.getScalarValue(NAG_DISABLED_ATTR));
        boolean acceptToS = mapping.get((Object)ACCEPT_TOS_ATTR) != null && BooleanUtils.toBoolean((String)mapping.getScalarValue(ACCEPT_TOS_ATTR));
        ArrayList<Recipient> cc = new ArrayList<Recipient>();
        CNode ccCN = (CNode)mapping.get((Object)CCS_ATTR);
        if (ccCN != null) {
            if (!(ccCN instanceof Sequence)) throw new ConfiguratorException((Configurator)this, "ccs is expected to be a list.");
            Sequence s = (Sequence)ccCN;
            for (CNode cNode : s) {
                cc.add(new Recipient(configurationContext.getSecretSourceResolver().resolve(cNode.asScalar().getValue())));
            }
            mapping.remove((Object)CCS_ATTR);
        }
        HashSet<String> excludedComponents = new HashSet<String>();
        CNode excludedCN = (CNode)mapping.get((Object)EXCLUDED_COMPONENTS_ATTR);
        if (excludedCN != null) {
            if (!(excludedCN instanceof Sequence)) throw new ConfiguratorException((Configurator)this, "excludedComponents is expected to be a list.");
            Sequence s = (Sequence)excludedCN;
            for (CNode cNode : s) {
                excludedComponents.add(cNode.asScalar().getValue());
            }
            if (excludedComponents.isEmpty()) {
                excludedComponents.add("SENDALL");
            }
        } else {
            excludedComponents.add("SENDALL");
        }
        AdvisorGlobalConfiguration advisor = this.getTargetComponent(configurationContext);
        if (!AdvisorGlobalConfiguration.isValid(true, acceptToS, email, cc)) {
            throw new ConfiguratorException((Configurator)this, "Invalid configuration for CloudBees Jenkins Advisor. Please check the logs and review the content in the yaml file.");
        }
        this.updateConfiguration(advisor, email, cc, true, nagDisabled, excludedComponents);
        return advisor;
    }

    private void updateConfiguration(AdvisorGlobalConfiguration conf, String email, List<Recipient> ccs, boolean acceptToS, boolean nagDisabled, Set<String> excludedComponents) {
        conf.setEmail(email);
        conf.setCcs(ccs);
        conf.setAcceptToS(acceptToS);
        conf.setNagDisabled(nagDisabled);
        conf.setExcludedComponents(excludedComponents);
    }

    public AdvisorGlobalConfiguration getTargetComponent(ConfigurationContext configurationContext) {
        return this.getConfiguration();
    }

    public Class<AdvisorGlobalConfiguration> getTarget() {
        return AdvisorGlobalConfiguration.class;
    }

    @CheckForNull
    public CNode describe(AdvisorGlobalConfiguration instance, ConfigurationContext context) throws Exception {
        Mapping mapping = new Mapping();
        if (instance.isValid()) {
            block14: for (Attribute attribute : this.describe()) {
                switch (attribute.getName()) {
                    case "acceptToS": {
                        mapping.put((Object)ACCEPT_TOS_ATTR, (Object)attribute.describe((Object)instance, context));
                        continue block14;
                    }
                    case "email": {
                        mapping.put(EMAIL_ATTR, String.valueOf(attribute.describe((Object)instance, context)));
                        continue block14;
                    }
                    case "ccs": {
                        SecretSourceResolver r = context.getSecretSourceResolver();
                        Sequence ccs = new Sequence();
                        instance.getCcs().stream().map(Recipient::getEmail).map(arg_0 -> ((SecretSourceResolver)r).encode(arg_0)).map(Scalar::new).forEach(arg_0 -> ccs.add(arg_0));
                        if (ccs.isEmpty()) continue block14;
                        mapping.put((Object)CCS_ATTR, (Object)ccs);
                        continue block14;
                    }
                    case "excludedComponents": {
                        Sequence seq;
                        CNode excludedCNode = attribute.describe((Object)instance, context);
                        if (excludedCNode instanceof Sequence && (seq = (Sequence)excludedCNode).isEmpty()) {
                            seq.add((Object)new Scalar("SENDALL"));
                        }
                        mapping.put((Object)EXCLUDED_COMPONENTS_ATTR, (Object)excludedCNode);
                        continue block14;
                    }
                    case "nagDisabled": {
                        mapping.put((Object)NAG_DISABLED_ATTR, (Object)attribute.describe((Object)instance, context));
                        continue block14;
                    }
                }
                LOG.fine("Unknown attribute:" + attribute.getName());
            }
        }
        return mapping;
    }

    private AdvisorGlobalConfiguration getConfiguration() {
        AdvisorGlobalConfiguration current = AdvisorGlobalConfiguration.getInstance();
        return current != null ? current : new AdvisorGlobalConfiguration();
    }
}

