/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.advisor;

import com.cloudbees.jenkins.plugins.advisor.Messages;
import com.cloudbees.jenkins.plugins.advisor.client.AdvisorClient;
import com.cloudbees.jenkins.plugins.advisor.client.model.Recipient;
import com.cloudbees.jenkins.plugins.advisor.utils.EmailUtil;
import com.cloudbees.jenkins.plugins.advisor.utils.EmailValidator;
import com.cloudbees.jenkins.support.SupportAction;
import com.cloudbees.jenkins.support.SupportPlugin;
import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.configfiles.AgentsConfigFile;
import com.cloudbees.jenkins.support.configfiles.ConfigFileComponent;
import com.cloudbees.jenkins.support.configfiles.OtherConfigFilesComponent;
import com.cloudbees.jenkins.support.impl.AboutBrowser;
import com.cloudbees.jenkins.support.impl.AboutJenkins;
import com.cloudbees.jenkins.support.impl.AboutUser;
import com.cloudbees.jenkins.support.impl.AdministrativeMonitors;
import com.cloudbees.jenkins.support.impl.BuildQueue;
import com.cloudbees.jenkins.support.impl.EnvironmentVariables;
import com.cloudbees.jenkins.support.impl.FileDescriptorLimit;
import com.cloudbees.jenkins.support.impl.JVMProcessSystemMetricsContents;
import com.cloudbees.jenkins.support.impl.JenkinsLogs;
import com.cloudbees.jenkins.support.impl.LoggerManager;
import com.cloudbees.jenkins.support.impl.NodeMonitors;
import com.cloudbees.jenkins.support.impl.ReverseProxy;
import com.cloudbees.jenkins.support.impl.RunningBuilds;
import com.cloudbees.jenkins.support.impl.SlaveLaunchLogs;
import com.cloudbees.jenkins.support.impl.SlaveLogs;
import com.cloudbees.jenkins.support.impl.SystemConfiguration;
import com.cloudbees.jenkins.support.impl.SystemProperties;
import com.cloudbees.jenkins.support.impl.ThreadDumps;
import com.cloudbees.jenkins.support.impl.UpdateCenter;
import com.cloudbees.jenkins.support.slowrequest.SlowRequestComponent;
import com.cloudbees.jenkins.support.threaddump.HighLoadComponent;
import com.cloudbees.jenkins.support.timer.DeadlockRequestComponent;
import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.Functions;
import hudson.PluginWrapper;
import hudson.XmlFile;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.util.io.OnMaster;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;

@Extension
public class AdvisorGlobalConfiguration
extends ManagementLink
implements Describable<AdvisorGlobalConfiguration>,
ExtensionPoint,
Saveable,
OnMaster {
    public static final String PLUGIN_NAME = "cloudbees-jenkins-advisor";
    public static final String SEND_ALL_COMPONENTS = "SENDALL";
    public static final String INVALID_CONFIGURATION = "invalid-configuration";
    public static final String SERVICE_OPERATIONAL = "service-operational";
    private static final Logger LOG = Logger.getLogger(AdvisorGlobalConfiguration.class.getName());
    private static final Set<Class<? extends Component>> ALLOWED_SUPPORT_CORE_COMPONENTS = Set.of(AboutBrowser.class, AboutJenkins.class, AboutUser.class, AdministrativeMonitors.class, SystemConfiguration.class, UpdateCenter.class, ThreadDumps.class, SystemProperties.class, SlowRequestComponent.class, SlaveLogs.class, SlaveLaunchLogs.class, RunningBuilds.class, JVMProcessSystemMetricsContents.Agents.class, SystemConfiguration.Agents.class, AgentsConfigFile.class, BuildQueue.class, ConfigFileComponent.class, DeadlockRequestComponent.class, EnvironmentVariables.class, FileDescriptorLimit.class, HighLoadComponent.class, JenkinsLogs.class, LoggerManager.class, JVMProcessSystemMetricsContents.Master.class, SystemConfiguration.Master.class, NodeMonitors.class, OtherConfigFilesComponent.class, ReverseProxy.class);
    private static final Set<String> ALLOWED_EXTRA_COMPONENTS = Set.of("com.cloudbees.opscenter.server.model.ConnectedMasterSupportComponent", "org.jenkinsci.plugins.useractivity.support.UserActivityComponent", "com.cloudbees.opscenter.support.FIPSSupport", "com.cloudbees.jenkins.plugins.assurance.CloudBeesAssuranceSupport");
    private static final Set<String> ALLOWED_COMPONENTS;
    private String email;
    private List<Recipient> ccs;
    private Set<String> excludedComponents;
    private boolean nagDisabled;
    private boolean acceptToS;
    private String lastBundleResult;
    @Deprecated
    private transient String cc;
    @Deprecated
    private transient boolean isValid;

    public AdvisorGlobalConfiguration() {
        this.load();
    }

    public AdvisorGlobalConfiguration(String email, List<Recipient> ccs, Set<String> excludedComponents) {
        this.setEmail(email);
        this.setCcs(ccs);
        this.setExcludedComponents(excludedComponents);
    }

    public static AdvisorGlobalConfiguration getInstance() {
        return (AdvisorGlobalConfiguration)((Object)Jenkins.get().getExtensionList(AdvisorGlobalConfiguration.class).get(0));
    }

    @CheckForNull
    public String getIconFileName() {
        return "symbol-medkit-outline plugin-ionicons-api";
    }

    @CheckForNull
    public String getUrlName() {
        return PLUGIN_NAME;
    }

    @CheckForNull
    public String getDisplayName() {
        return Messages.Insights_DisplayName();
    }

    @Nonnull
    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.TROUBLESHOOTING;
    }

    @CheckForNull
    public String getDescription() {
        return Messages.Insights_Description();
    }

    public String getActionTitle() {
        return Messages.Insights_Title();
    }

    public String getActionDisclaimer() {
        return Messages.Insights_Disclaimer();
    }

    public String getDisclaimer() {
        return Messages.Insights_Disclaimer();
    }

    public boolean isNagDisabled() {
        return this.nagDisabled;
    }

    @DataBoundSetter
    public void setNagDisabled(boolean nagDisabled) {
        if (this.nagDisabled != nagDisabled) {
            this.nagDisabled = nagDisabled;
        }
    }

    public boolean isAcceptToS() {
        return this.acceptToS;
    }

    @DataBoundSetter
    public void setAcceptToS(boolean acceptToS) {
        if (this.acceptToS != acceptToS) {
            this.acceptToS = acceptToS;
        }
    }

    public String getLastBundleResult() {
        return this.lastBundleResult;
    }

    @DataBoundSetter
    public void setLastBundleResult(String lastBundleResult) {
        this.lastBundleResult = lastBundleResult;
    }

    protected Object readResolve() {
        if (this.cc != null) {
            this.setCcs(Arrays.stream(StringUtils.split((String)EmailUtil.fixEmptyAndTrimAllSpaces(this.cc), (String)",")).map(EmailUtil::fixEmptyAndTrimAllSpaces).filter(Objects::nonNull).map(Recipient::new).collect(Collectors.toList()));
            this.save();
        }
        return this;
    }

    @RequirePOST
    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public HttpResponse doConfigure(@Nonnull StaplerRequest2 req) {
        Jenkins jenkins = Jenkins.get();
        jenkins.checkPermission(Jenkins.ADMINISTER);
        try {
            this.configureDescriptor(req, req.getSubmittedForm(), this.getDescriptor());
            this.save();
            if (!this.isValid() || StringUtils.isNotBlank((String)req.getParameter("advisor:apply"))) {
                return HttpResponses.redirectToDot();
            }
            return HttpResponses.redirectTo((String)(req.getContextPath() + "/manage"));
        }
        catch (Exception e) {
            LOG.severe("Unable to save Jenkins Health Advisor by CloudBees configuration: " + Functions.printThrowable((Throwable)e));
            return FormValidation.error((String)("Unable to save configuration: " + e.getMessage()));
        }
    }

    private boolean configureDescriptor(StaplerRequest2 req, JSONObject json, Descriptor<?> d) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        return d.configure(req, json);
    }

    public Descriptor<AdvisorGlobalConfiguration> getDescriptor() {
        return Jenkins.get().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    public String getEmail() {
        return this.email;
    }

    @DataBoundSetter
    public void setEmail(@CheckForNull String email) {
        this.email = EmailUtil.fixEmptyAndTrimAllSpaces(email);
    }

    @Nonnull
    public List<Recipient> getCcs() {
        return this.ccs != null ? this.ccs : Collections.emptyList();
    }

    @DataBoundSetter
    public void setCcs(List<Recipient> ccs) {
        this.ccs = ccs;
    }

    @Nonnull
    public Set<String> getExcludedComponents() {
        return this.excludedComponents != null ? this.excludedComponents : Collections.emptySet();
    }

    @DataBoundSetter
    public void setExcludedComponents(Set<String> excludedComponents) {
        this.excludedComponents = excludedComponents;
    }

    public List<Component> getIncludedComponents() {
        ArrayList<Component> included = new ArrayList<Component>();
        if (this.getExcludedComponents().isEmpty()) {
            for (Component c : this.getComponents()) {
                if (!c.isSelectedByDefault()) continue;
                included.add(c);
            }
        } else {
            for (Component c : this.getComponents()) {
                if (this.getExcludedComponents().contains(c.getId())) continue;
                included.add(c);
            }
        }
        return included;
    }

    public boolean selectedByDefault(Component c) {
        if (this.getExcludedComponents().isEmpty()) {
            return c.isSelectedByDefault();
        }
        return !this.getExcludedComponents().contains(c.getId());
    }

    public List<Component> getComponents() {
        return SupportPlugin.getComponents().stream().filter(c -> ALLOWED_COMPONENTS.contains(c.getClass().getName())).collect(Collectors.toUnmodifiableList());
    }

    public boolean isValid() {
        return AdvisorGlobalConfiguration.isValid(false, this.isAcceptToS(), this.getEmail(), this.getCcs());
    }

    public static boolean isValid(boolean logErrors, boolean acceptToS, String email, List<Recipient> ccs) {
        List<String> erroneousCCEmails;
        if (!acceptToS) {
            if (logErrors) {
                LOG.warning("acceptToS is invalid, it must be set to true");
            }
            return false;
        }
        if (!EmailValidator.isValidEmail(email)) {
            if (logErrors) {
                LOG.warning(() -> String.format("email \"%s\" is not valid", email));
            }
            return false;
        }
        if (!ccs.isEmpty() && !(erroneousCCEmails = ccs.stream().map(Recipient::getEmail).filter(s -> !EmailValidator.isValidEmail(s)).collect(Collectors.toList())).isEmpty()) {
            erroneousCCEmails.forEach(s -> {
                if (logErrors) {
                    LOG.warning(() -> String.format("cc \"%s\" is not valid", s));
                }
            });
            return false;
        }
        return true;
    }

    boolean isPluginEnabled() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            PluginWrapper plugin = jenkins.getPluginManager().getPlugin(PLUGIN_NAME);
            if (plugin == null) {
                LOG.severe("Expected to find plugin: [cloudbees-jenkins-advisor] but none found");
                return false;
            }
            return plugin.isEnabled();
        }
        return false;
    }

    public synchronized void save() {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        try {
            this.getConfigFile().write((Object)this);
            SaveableListener.fireOnChange((Saveable)this, (XmlFile)this.getConfigFile());
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to save " + String.valueOf(this.getConfigFile()), e);
        }
    }

    public synchronized void load() {
        XmlFile file = this.getConfigFile();
        if (!file.exists()) {
            return;
        }
        try {
            file.unmarshal((Object)this);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to load " + String.valueOf(file), e);
        }
    }

    private XmlFile getConfigFile() {
        return new XmlFile(new File(Jenkins.get().getRootDir(), ((Object)((Object)this)).getClass().getName() + ".xml"));
    }

    static {
        HashSet<String> allowedComponents = new HashSet<String>();
        allowedComponents.addAll(ALLOWED_EXTRA_COMPONENTS);
        allowedComponents.addAll(ALLOWED_SUPPORT_CORE_COMPONENTS.stream().map(Class::getName).collect(Collectors.toSet()));
        ALLOWED_COMPONENTS = Collections.unmodifiableSet(allowedComponents);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<AdvisorGlobalConfiguration> {
        @Nonnull
        public String getDisplayName() {
            return Messages.Insights_DisplayName();
        }

        public FormValidation doCheckAcceptToS(@QueryParameter boolean value) {
            if (!value) {
                return FormValidation.error((String)"Accepting our Terms and Conditions is mandatory to use this service.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckEmail(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return EmailValidator.validateEmail(value);
        }

        @POST
        public FormValidation doTestSendEmail(@QueryParameter(value="email") String value, @QueryParameter(value="acceptToS") boolean acceptToS) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return EmailValidator.testSendEmail(value, acceptToS);
        }

        public String validateServerConnection() {
            AdvisorGlobalConfiguration config = AdvisorGlobalConfiguration.getInstance();
            if (!config.isValid()) {
                return AdvisorGlobalConfiguration.INVALID_CONFIGURATION;
            }
            try {
                AdvisorClient advisorClient = new AdvisorClient(new Recipient(null));
                advisorClient.doCheckHealth();
                return AdvisorGlobalConfiguration.SERVICE_OPERATIONAL;
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) {
            AdvisorGlobalConfiguration advisorGlobalConfiguration;
            boolean acceptToS = json.getBoolean("acceptToS");
            String email = json.getString("email");
            List ccs = req.bindJSONToList(Recipient.class, json.get("ccs"));
            boolean nagDisabled = json.getBoolean("nagDisabled");
            JSONObject advanced = json.getJSONObject("advanced");
            HashSet<String> remove = new HashSet<String>();
            for (SupportAction.Selection s : req.bindJSONToList(SupportAction.Selection.class, advanced.get("components"))) {
                if (s.isSelected()) continue;
                LOG.log(Level.FINER, "Excluding ''{0}'' from list of components to include", s.getName());
                remove.add(s.getName());
            }
            if (remove.isEmpty()) {
                remove.add(AdvisorGlobalConfiguration.SEND_ALL_COMPONENTS);
            }
            if ((advisorGlobalConfiguration = AdvisorGlobalConfiguration.getInstance()) != null) {
                advisorGlobalConfiguration.setAcceptToS(acceptToS);
                advisorGlobalConfiguration.setEmail(email);
                advisorGlobalConfiguration.setCcs(ccs);
                advisorGlobalConfiguration.setNagDisabled(nagDisabled);
                advisorGlobalConfiguration.setExcludedComponents(remove);
            }
            try {
                return advisorGlobalConfiguration != null && advisorGlobalConfiguration.isValid();
            }
            catch (Exception e) {
                LOG.severe("Unexpected error while validating form: " + Functions.printThrowable((Throwable)e));
                return false;
            }
        }
    }
}

