/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.advisor.utils;

import com.cloudbees.jenkins.plugins.advisor.client.AdvisorClient;
import com.cloudbees.jenkins.plugins.advisor.client.model.Recipient;
import com.cloudbees.jenkins.plugins.advisor.utils.EmailUtil;
import hudson.util.FormValidation;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class EmailValidator {
    private static final String EMAIL_REGEX = "^[\\w-+]+(\\.[\\w]+)*@[\\w-]+(\\.[\\w]+)*(\\.[a-z]{2,})$";
    private static final Pattern PATTERN = Pattern.compile("^[\\w-+]+(\\.[\\w]+)*@[\\w-]+(\\.[\\w]+)*(\\.[a-z]{2,})$", 2);

    private EmailValidator() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    public static boolean isValidEmail(String value) {
        String emailAddress = EmailUtil.fixEmptyAndTrimAllSpaces(value);
        return StringUtils.isNotBlank((CharSequence)emailAddress);
    }

    public static FormValidation validateEmail(String value) {
        String emailAddress = EmailUtil.fixEmptyAndTrimAllSpaces(value);
        if (StringUtils.isBlank((CharSequence)emailAddress)) {
            return FormValidation.error((String)"Email cannot be blank");
        }
        if (emailAddress.contains(";") || emailAddress.contains(",")) {
            return FormValidation.error((String)"Email cannot contain illegal character ';' or ','. Consider using the CC fields if multiple recipients are required");
        }
        return FormValidation.ok();
    }

    public static FormValidation testSendEmail(String value, boolean acceptToS) {
        try {
            if (!acceptToS) {
                return FormValidation.warning((String)"It is impossible to launch a test without accepting our Terms and Conditions");
            }
            if (!EmailValidator.validateEmail((String)value).kind.equals((Object)FormValidation.Kind.OK)) {
                return FormValidation.warning((String)"It is impossible to launch a test without providing a valid email");
            }
            AdvisorClient advisorClient = new AdvisorClient(new Recipient(value.trim()));
            advisorClient.doTestEmail();
            return FormValidation.ok((String)"A request to send a test email from the server was done. Please check your inbox and filters.");
        }
        catch (Exception e) {
            return FormValidation.error((String)("The test failed: " + e.getMessage()));
        }
    }
}

