/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.advisor.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class AdvisorClientConfig {
    private AdvisorClientConfig() {
        throw new IllegalAccessError("Utility class");
    }

    public static String advisorURL() {
        return AdvisorClientConfig.removeEnd(AdvisorClientConfig.resolveProperty("com.cloudbees.jenkins.plugins.advisor.client.AdvisorClientConfig.advisorURL"), "/");
    }

    public static Integer advisorUploadTimeoutMinutes() {
        return Integer.valueOf(AdvisorClientConfig.removeEnd(AdvisorClientConfig.resolveProperty("com.cloudbees.jenkins.plugins.advisor.client.AdvisorClientConfig.advisorUploadTimeoutMinutes"), "/"));
    }

    public static Integer insightsUploadTimeoutMilliseconds() {
        return (int)TimeUnit.MINUTES.toMillis(AdvisorClientConfig.advisorUploadTimeoutMinutes().intValue());
    }

    public static Integer advisorUploadIdleTimeoutMinutes() {
        return Integer.valueOf(AdvisorClientConfig.removeEnd(AdvisorClientConfig.resolveProperty("com.cloudbees.jenkins.plugins.advisor.client.AdvisorClientConfig.advisorUploadIdleTimeoutMinutes"), "/"));
    }

    public static Integer insightsUploadIdleTimeoutMilliseconds() {
        return (int)TimeUnit.MINUTES.toMillis(AdvisorClientConfig.advisorUploadIdleTimeoutMinutes().intValue());
    }

    public static String healthURI() {
        return AdvisorClientConfig.advisorURL() + "/api/health";
    }

    public static String testEmailURI() {
        return AdvisorClientConfig.advisorURL() + "/api/test/emails";
    }

    public static String apiUploadURI(String username, String instanceId) {
        return AdvisorClientConfig.advisorURL() + String.format("/api/users/%s/upload/%s", username, instanceId);
    }

    public static String apiUploadURI(String username, String instanceId, String cc) {
        if (StringUtils.isNotBlank((CharSequence)cc)) {
            return AdvisorClientConfig.advisorURL() + String.format("/api/users/%s/upload/%s?cc=%s", username, instanceId, cc);
        }
        return AdvisorClientConfig.apiUploadURI(username, instanceId);
    }

    private static String resolveProperty(String key) {
        int i1;
        StringBuilder result = new StringBuilder();
        Object value = System.getProperty(key, ResourceHolder.INSTANCE.getProperty(key));
        if (value == null) {
            return null;
        }
        while ((i1 = ((String)value).indexOf("${")) >= 0) {
            result.append((CharSequence)value, 0, i1);
            value = ((String)value).substring(i1 + 2);
            int i2 = ((String)value).indexOf(125);
            if (i2 < 0) break;
            String tmpKey = ((String)value).substring(0, i2);
            value = ((String)value).substring(i2 + 1);
            String tmpValue = System.getProperty(tmpKey, ResourceHolder.INSTANCE.getProperty(tmpKey));
            if (tmpValue == null || tmpValue.equals(key) || key.equals(tmpKey)) {
                result.append("${").append(tmpKey).append("}");
                continue;
            }
            value = tmpValue + (String)value;
        }
        result.append((String)value);
        return result.toString();
    }

    private static String removeEnd(String str, String remove) {
        if (AdvisorClientConfig.isEmpty(str) || AdvisorClientConfig.isEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private static final class ResourceHolder {
        private static final Properties INSTANCE = ResourceHolder.loadProperties();

        private ResourceHolder() {
        }

        private static Properties loadProperties() {
            Properties properties = new Properties();
            InputStream inputStream = AdvisorClientConfig.class.getResourceAsStream("/" + AdvisorClientConfig.class.getName().replace('.', '/') + ".properties");
            if (inputStream != null) {
                try {
                    properties.load(inputStream);
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return properties;
        }
    }
}

