/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.advisor;

import com.cloudbees.jenkins.plugins.advisor.AdvisorGlobalConfiguration;
import com.cloudbees.jenkins.plugins.advisor.client.AdvisorClient;
import com.cloudbees.jenkins.plugins.advisor.client.PluginHelper;
import com.cloudbees.jenkins.plugins.advisor.client.model.ClientResponse;
import com.cloudbees.jenkins.plugins.advisor.client.model.ClientUploadRequest;
import com.cloudbees.jenkins.plugins.advisor.client.model.Recipient;
import com.cloudbees.jenkins.support.SupportPlugin;
import hudson.Extension;
import hudson.Util;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jenkinsci.Symbol;

@Extension
@Symbol(value={"bundleUpload"})
public class BundleUpload
extends AsyncPeriodicWork {
    public static final int RECURRENCE_PERIOD_HOURS = Integer.getInteger(BundleUpload.class.getName() + ".recurrencePeriodHours", 24);
    public static final int INITIAL_DELAY_MINUTES = Integer.getInteger(BundleUpload.class.getName() + ".initialDelayMinutes", 30);
    public static final String TEMP_BUNDLE_DIRECTORY = System.getProperty(BundleUpload.class.getName() + ".tempBundleDirectory", Paths.get(SupportPlugin.getRootDirectory().toString(), "advisor").toString());
    private static final Logger LOG = Logger.getLogger(BundleUpload.class.getName());
    private static final String UNABLE_TO_GENERATE_SUPPORT_BUNDLE = "Unable to generate support bundle";
    private static final String COULD_NOT_SAVE_SUPPORT_BUNDLE = "Unable to save support bundle";
    private static final String BUNDLE_DIR_DOES_NOT_EXIST = "Bundle root directory does not exist and could not be created";
    protected static final String BUNDLE_SUCCESSFULLY_UPLOADED = "Bundle uploaded";
    private TaskListener task;

    public BundleUpload() {
        super("Bundle Upload");
    }

    protected void execute(TaskListener listener) {
        this.task = listener;
        AdvisorGlobalConfiguration config = AdvisorGlobalConfiguration.getInstance();
        if (config == null) {
            return;
        }
        if (!config.isPluginEnabled()) {
            this.log(Level.INFO, "Jenkins Health Advisor by CloudBees plugin disabled. Skipping bundle upload.");
            this.updateLastBundleResult(config, this.createTimestampedWarnMessage("<strong>Plugin disabled</strong>, the upload was skipped"));
            return;
        }
        if (!config.isValid()) {
            this.log(Level.INFO, "Invalid configuration. Skipping bundle upload.");
            this.updateLastBundleResult(config, this.createTimestampedWarnMessage("<strong>Invalid configuration</strong>, the upload was skipped"));
            return;
        }
        File bundle = this.generateBundle();
        String pluginVersion = PluginHelper.getPluginVersion();
        if (bundle != null) {
            this.executeInternal(config.getEmail(), bundle, pluginVersion);
        } else {
            this.log(Level.SEVERE, UNABLE_TO_GENERATE_SUPPORT_BUNDLE);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private File generateBundle() {
        AdvisorGlobalConfiguration config = AdvisorGlobalConfiguration.getInstance();
        File file = null;
        try (ACLContext ignored = ACL.as((Authentication)ACL.SYSTEM);){
            File file2;
            File bundleDir = new File(TEMP_BUNDLE_DIRECTORY);
            if (!bundleDir.exists() && !bundleDir.mkdirs()) {
                this.log(Level.SEVERE, String.format("%s: %s", COULD_NOT_SAVE_SUPPORT_BUNDLE, BUNDLE_DIR_DOES_NOT_EXIST));
                this.updateLastBundleResult(config, this.createTimestampedErrorMessage("<strong>%s</strong>: %s", COULD_NOT_SAVE_SUPPORT_BUNDLE, BUNDLE_DIR_DOES_NOT_EXIST));
                File file3 = null;
                return file3;
            }
            file = new File(bundleDir, SupportPlugin.getBundleFileName());
            try (FileOutputStream fos = new FileOutputStream(file);){
                SupportPlugin.writeBundle((OutputStream)fos, config.getIncludedComponents());
                file2 = file;
            }
            return file2;
        }
        catch (Exception e) {
            this.logError(COULD_NOT_SAVE_SUPPORT_BUNDLE, e);
            String sanitizedMessage = Util.xmlEscape((String)e.getMessage());
            this.updateLastBundleResult(config, this.createTimestampedErrorMessage("<strong>%s</strong><br/><pre><code>%s</code></pre>", COULD_NOT_SAVE_SUPPORT_BUNDLE, sanitizedMessage));
            if (file != null && file.exists() && !file.delete()) {
                this.log(Level.WARNING, "Could not delete bundle {0}" + String.valueOf(file));
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInternal(String email, File file, String pluginVersion) {
        AdvisorGlobalConfiguration config = AdvisorGlobalConfiguration.getInstance();
        try {
            AdvisorClient advisorClient = new AdvisorClient(new Recipient(email));
            ClientResponse response = advisorClient.uploadFile(new ClientUploadRequest(Jenkins.get().getLegacyInstanceId(), file, config.getCcs(), pluginVersion));
            if (response.getCode() == 200) {
                this.updateLastBundleResult(config, this.createTimestampedInfoMessage(BUNDLE_SUCCESSFULLY_UPLOADED));
            } else {
                String sanitizedMessage = Util.xmlEscape((String)response.getMessage());
                this.updateLastBundleResult(config, this.createTimestampedErrorMessage("<strong>Bundle upload failed</strong><br/>Server response is: <code>%d - %s</code>", response.getCode(), sanitizedMessage));
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Issue while uploading file to bundle upload service: " + e.getMessage());
            this.log(Level.FINEST, "Exception while uploading file to bundle upload service. Cause: " + ExceptionUtils.getStackTrace((Throwable)e));
            String sanitizedMessage = Util.xmlEscape((String)e.getMessage());
            this.updateLastBundleResult(config, this.createTimestampedErrorMessage("<strong>Bundle upload failed</strong><br/><pre><code>%s</code></pre>", sanitizedMessage));
        }
        finally {
            if (!file.delete()) {
                this.log(Level.WARNING, "Could not delete bundle {0}" + String.valueOf(file));
            }
            this.cleanup(new File(TEMP_BUNDLE_DIRECTORY));
        }
    }

    private void cleanup(File bundleDir) {
        File[] files = bundleDir.listFiles((dir, name) -> name.endsWith(".zip"));
        if (files == null) {
            this.log(Level.WARNING, "Could not list files under" + bundleDir.getAbsolutePath());
            return;
        }
        long maxAge = System.currentTimeMillis() - TimeUnit.HOURS.toMillis(RECURRENCE_PERIOD_HOURS);
        for (File f : files) {
            if (f.lastModified() >= maxAge) continue;
            this.log(Level.INFO, "Deleting bundle" + String.valueOf(f));
            if (f.delete()) continue;
            this.log(Level.WARNING, "Could not delete bundle {0}" + String.valueOf(f));
        }
    }

    public long getRecurrencePeriod() {
        return TimeUnit.HOURS.toMillis(RECURRENCE_PERIOD_HOURS);
    }

    private void log(Level level, String message) {
        if (this.task != null) {
            if (level.equals(Level.SEVERE) || level.equals(Level.WARNING)) {
                this.task.error(message);
            } else {
                this.task.getLogger().println(message);
            }
        }
        LOG.log(level, message);
    }

    private void logError(String message, Throwable t) {
        if (this.task != null) {
            this.task.error(message, new Object[]{t});
        }
        LOG.log(Level.SEVERE, message, t);
    }

    private String createTimestampedInfoMessage(String message) {
        return this.createTimestampedMessage(null, message);
    }

    private String createTimestampedWarnMessage(String message) {
        return this.createTimestampedMessage("WARNING", message);
    }

    private String createTimestampedErrorMessage(String format, Object ... args) {
        return this.createTimestampedMessage("ERROR", format, args);
    }

    private String createTimestampedMessage(String level, String format, Object ... args) {
        return this.createTimestampedMessage(level, String.format(format, args));
    }

    private String createTimestampedMessage(String level, String message) {
        if (level != null) {
            return String.format("%1$s - %2$tF %2$tT - %3$s", level, Calendar.getInstance().getTime(), message);
        }
        return String.format("%1$tF %1$tT - %2$s", Calendar.getInstance().getTime(), message);
    }

    private void updateLastBundleResult(AdvisorGlobalConfiguration config, String message) {
        config.setLastBundleResult(message);
        config.save();
    }

    public long getInitialDelay() {
        return TimeUnit.MINUTES.toMillis(INITIAL_DELAY_MINUTES);
    }

    public String getTempBundleDirectory() {
        return TEMP_BUNDLE_DIRECTORY;
    }
}

