/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.advisor.client;

import com.cloudbees.jenkins.plugins.advisor.client.AdvisorClientConfig;
import com.cloudbees.jenkins.plugins.advisor.client.model.ClientResponse;
import hudson.ProxyConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;

public class MultipartConnection {
    private static final String LINE_FEED = "\r\n";
    private final String boundary = "===" + System.currentTimeMillis() + "===";
    private final HttpURLConnection httpConn;
    private final Charset charset;
    private OutputStream outputStream;
    private PrintWriter writer;

    public MultipartConnection(String requestURL, Charset charset) throws IOException {
        this.httpConn = (HttpURLConnection)ProxyConfiguration.open((URL)new URL(requestURL));
        this.httpConn.setUseCaches(false);
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
        this.httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        this.httpConn.setConnectTimeout(AdvisorClientConfig.insightsUploadIdleTimeoutMilliseconds());
        this.httpConn.setReadTimeout(AdvisorClientConfig.insightsUploadTimeoutMilliseconds());
        this.httpConn.setInstanceFollowRedirects(true);
        this.charset = charset;
    }

    public void connect() {
        try {
            this.outputStream = this.httpConn.getOutputStream();
            this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, this.charset), true);
        }
        catch (IOException e) {
            throw new MultipartConnectionException("Unable to connect", e);
        }
    }

    public void addHeader(String key, String value) {
        this.httpConn.addRequestProperty(key, value);
    }

    public void addFilePart(String fieldName, File uploadFile) throws IOException {
        String fileName = uploadFile.getName();
        this.writer.append("--").append(this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"").append(fieldName).append("\"; filename=\"").append(fileName).append("\"").append(LINE_FEED);
        this.writer.append("Content-Type: ").append(URLConnection.guessContentTypeFromName(fileName)).append(LINE_FEED);
        this.writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.flush();
        try (FileInputStream inputStream = new FileInputStream(uploadFile);){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                this.outputStream.write(buffer, 0, bytesRead);
            }
            this.outputStream.flush();
        }
        this.writer.append(LINE_FEED);
        this.writer.flush();
    }

    public ClientResponse finish() throws IOException {
        String line;
        StringBuilder response = new StringBuilder();
        this.writer.append(LINE_FEED).flush();
        this.writer.append("--").append(this.boundary).append("--").append(LINE_FEED);
        this.writer.close();
        int status = this.httpConn.getResponseCode();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.httpConn.getInputStream(), this.charset));
        while ((line = reader.readLine()) != null) {
            response.append(line);
        }
        reader.close();
        this.httpConn.disconnect();
        return new ClientResponse(status, response.toString());
    }

    private static final class MultipartConnectionException
    extends RuntimeException {
        public MultipartConnectionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

