/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.advisor;

import com.cloudbees.jenkins.plugins.advisor.AdvisorGlobalConfiguration;
import com.cloudbees.jenkins.plugins.advisor.Messages;
import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import jakarta.servlet.ServletException;
import java.io.IOException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class BundleUploadMonitor
extends AdministrativeMonitor {
    public boolean isActivated() {
        AdvisorGlobalConfiguration config = AdvisorGlobalConfiguration.getInstance();
        return config.isPluginEnabled() && config.getLastBundleResult() != null && (config.getLastBundleResult().contains("ERROR") || config.getLastBundleResult().contains("Bundle upload failed"));
    }

    public String getDisplayName() {
        return Messages.BundleUploadMonitor_DisplayName();
    }

    @Restricted(value={NoExternalUse.class})
    @RequirePOST
    public void doAct(StaplerRequest2 req, StaplerResponse2 rsp) throws ServletException, IOException {
        AdvisorGlobalConfiguration config = AdvisorGlobalConfiguration.getInstance();
        if (req.hasParameter("yes")) {
            rsp.sendRedirect(req.getContextPath() + "/manage/" + config.getUrlName());
        } else {
            rsp.forwardToPreviousPage(req);
        }
    }

    public String getFailureMessage() {
        return AdvisorGlobalConfiguration.getInstance().getLastBundleResult();
    }
}

