/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.computed;

import com.cloudbees.hudson.plugins.folder.AbstractFolderDescriptor;
import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.hudson.plugins.folder.computed.ChildObserver;
import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.cloudbees.hudson.plugins.folder.computed.DefaultOrphanedItemStrategy;
import com.cloudbees.hudson.plugins.folder.computed.FolderComputation;
import com.cloudbees.hudson.plugins.folder.computed.Messages;
import com.cloudbees.hudson.plugins.folder.computed.OrphanedItemStrategy;
import com.cloudbees.hudson.plugins.folder.computed.OrphanedParent;
import com.cloudbees.hudson.plugins.folder.computed.PeriodicFolderTrigger;
import com.cloudbees.hudson.plugins.folder.views.AbstractFolderViewHolder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.AllView;
import hudson.model.Cause;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.Failure;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.ListView;
import hudson.model.MyView;
import hudson.model.OneOffExecutor;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.model.labels.LabelAtom;
import hudson.model.queue.QueueTaskFuture;
import hudson.triggers.TimerTrigger;
import hudson.triggers.Trigger;
import hudson.util.StreamTaskListener;
import hudson.views.DefaultViewsTabBar;
import hudson.views.ViewsTabBar;
import jakarta.servlet.ServletException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import jenkins.model.CauseOfInterruption;
import jenkins.model.InterruptedBuildAction;
import jenkins.model.Jenkins;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.htmlunit.html.HtmlPage;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.test.steps.SemaphoreStep;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.SleepBuilder;
import org.jvnet.hudson.test.TestExtension;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

@WithJenkins
class ComputedFolderTest {
    private JenkinsRule r;

    ComputedFolderTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) {
        this.r = rule;
    }

    @Test
    void duplicateEntries() throws Exception {
        SampleComputedFolder d = (SampleComputedFolder)this.r.jenkins.createProject(SampleComputedFolder.class, "d");
        d.recompute(Result.SUCCESS);
        d.assertItemNames(1, new String[0]);
        d.kids.addAll(Arrays.asList("A", "B", "A", "C"));
        d.recompute(Result.SUCCESS);
        d.assertItemNames(2, "A", "B", "C");
        Assertions.assertEquals((Object)"[A, B, C]", (Object)d.created.toString());
        Assertions.assertDoesNotThrow(() -> this.r.createWebClient().getPage((Item)d), (String)"ComputedFolder<FreeStyleProject> cannot be opened: ");
        d.recompute(Result.SUCCESS);
        d.assertItemNames(3, "A", "B", "C");
        Assertions.assertEquals((Object)"[A, B, C]", (Object)d.created.toString());
        d.kids.remove("B");
        d.recompute(Result.SUCCESS);
        d.assertItemNames(4, "A", "C");
        Assertions.assertEquals((Object)"[A, B, C]", (Object)d.created.toString());
        Assertions.assertEquals((Object)"[B]", (Object)d.deleted.toString());
        d.kids.addAll(Arrays.asList("D", "B"));
        d.recompute(Result.SUCCESS);
        d.assertItemNames(5, "A", "B", "C", "D");
        Assertions.assertEquals((Object)"[A, B, C, D, B]", (Object)d.created.toString());
        Assertions.assertEquals((Object)"[B]", (Object)d.deleted.toString());
        TreeMap<String, String> descriptions = new TreeMap<String, String>();
        for (FreeStyleProject p : d.getItems()) {
            descriptions.put(p.getName(), p.getDescription());
        }
        Assertions.assertEquals((Object)"{A=updated in round #5, B=created in round #5, C=updated in round #5, D=created in round #5}", (Object)((Object)descriptions).toString());
    }

    @Test
    void disableOrphans() throws Exception {
        SampleComputedFolder d = (SampleComputedFolder)this.r.jenkins.createProject(SampleComputedFolder.class, "d");
        d.setOrphanedItemStrategy((OrphanedItemStrategy)new DefaultOrphanedItemStrategy(true, "-1", "1"));
        d.recompute(Result.SUCCESS);
        d.assertItemNames(1, new String[0]);
        d.kids.addAll(Arrays.asList("A", "B", "C"));
        d.recompute(Result.SUCCESS);
        d.assertItemNames(2, "A", "B", "C");
        d.kids.remove("B");
        d.recompute(Result.SUCCESS);
        d.assertItemNames(3, "A", "B", "C");
        MatcherAssert.assertThat((Object)((FreeStyleProject)d.getItem("A")).isDisabled(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)((FreeStyleProject)d.getItem("B")).isDisabled(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((FreeStyleProject)d.getItem("C")).isDisabled(), (Matcher)Matchers.is((Object)false));
        d.kids.remove("C");
        d.recompute(Result.SUCCESS);
        d.assertItemNames(4, "A", "C");
        MatcherAssert.assertThat((Object)((FreeStyleProject)d.getItem("A")).isDisabled(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)((FreeStyleProject)d.getItem("C")).isDisabled(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void disableFolder() throws Exception {
        SampleComputedFolder d = (SampleComputedFolder)this.r.jenkins.createProject(SampleComputedFolder.class, "d");
        d.recompute(Result.SUCCESS);
        d.assertItemNames(1, new String[0]);
        d.kids.addAll(Arrays.asList("A", "B", "C"));
        d.recompute(Result.SUCCESS);
        d.assertItemNames(2, "A", "B", "C");
        MatcherAssert.assertThat((Object)((FreeStyleProject)d.getItem("A")).scheduleBuild2(0), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        d.makeDisabled(true);
        MatcherAssert.assertThat((Object)d.scheduleBuild2(0, new Action[0]), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((FreeStyleProject)d.getItem("A")).scheduleBuild2(0), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        d.assertItemNames(2, "A", "B", "C");
        d.makeDisabled(false);
        d.recompute(Result.SUCCESS);
        MatcherAssert.assertThat((Object)((FreeStyleProject)d.getItem("A")).scheduleBuild2(0), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        d.assertItemNames(3, "A", "B", "C");
        this.r.waitUntilNoActivityUpTo((int)TimeUnit.MINUTES.toMillis(1L));
    }

    @Test
    void roundTrip() throws Exception {
        SampleComputedFolder d = (SampleComputedFolder)this.r.jenkins.createProject(SampleComputedFolder.class, "d");
        d.makeDisabled(true);
        d = (SampleComputedFolder)this.r.configRoundtrip((Item)d);
        Assertions.assertTrue((boolean)d.isDisabled());
    }

    @Test
    void foldersAsChildren() throws Exception {
        SampleComputedFolderWithFoldersAsChildren d = (SampleComputedFolderWithFoldersAsChildren)this.r.jenkins.createProject(SampleComputedFolderWithFoldersAsChildren.class, "d");
        d.recompute(Result.SUCCESS);
        d.kids.add("A");
        d.recompute(Result.SUCCESS);
        Assertions.assertDoesNotThrow(() -> {
            Folder a = (Folder)d.getItems().iterator().next();
            this.r.createWebClient().getPage((Item)a);
        }, (String)"Folder inside ComputedFolder cannot be opened: ");
        Assertions.assertDoesNotThrow(() -> this.r.createWebClient().getPage((Item)d), (String)"ComputedFolder<Folder> cannot be opened: ");
    }

    @Test
    void abortException() throws Exception {
        SampleComputedFolder d = (SampleComputedFolder)this.r.jenkins.createProject(SampleComputedFolder.class, "d");
        d.setDisplayName("My Folder");
        d.kids.addAll(Arrays.asList("A", "B"));
        d.recompute(Result.SUCCESS);
        d.assertItemNames(1, "A", "B");
        d.kids.add("Z");
        d.kids.remove("A");
        String log = d.recompute(Result.FAILURE);
        d.assertItemNames(2, "A", "B");
        Assertions.assertTrue((boolean)log.contains("not adding Z"), (String)log);
        Assertions.assertFalse((boolean)log.contains(SampleComputedFolder.class.getName()), (String)log);
    }

    @Test
    void runningBuild() throws Exception {
        SampleComputedFolder d = (SampleComputedFolder)this.r.jenkins.createProject(SampleComputedFolder.class, "d");
        d.kids.addAll(Arrays.asList("A", "B"));
        d.recompute(Result.SUCCESS);
        d.assertItemNames(1, "A", "B");
        ((FreeStyleProject)d.getItem("B")).getBuildersList().add((Object)new SleepBuilder(Long.MAX_VALUE));
        ((FreeStyleProject)d.getItem("B")).setConcurrentBuild(true);
        FreeStyleBuild b1 = (FreeStyleBuild)((FreeStyleProject)d.getItem("B")).scheduleBuild2(0).waitForStart();
        FreeStyleBuild b2 = (FreeStyleBuild)((FreeStyleProject)d.getItem("B")).scheduleBuild2(0).waitForStart();
        d.kids.remove("B");
        d.recompute(Result.SUCCESS);
        d.assertItemNames(2, "A", "B");
        for (FreeStyleBuild b : new FreeStyleBuild[]{b1, b2}) {
            Assertions.assertTrue((boolean)b.isBuilding());
            b.doStop();
            this.r.assertBuildStatus(Result.ABORTED, (Run)((FreeStyleBuild)this.r.waitForCompletion((Run)b)));
        }
        d.recompute(Result.SUCCESS);
        d.assertItemNames(3, "A");
        FreeStyleBuild a1 = (FreeStyleBuild)((FreeStyleProject)d.getItem("A")).scheduleBuild2(0).get();
        FreeStyleBuild a2 = (FreeStyleBuild)((FreeStyleProject)d.getItem("A")).scheduleBuild2(0).get();
        a1.keepLog(true);
        d.kids.remove("A");
        d.recompute(Result.SUCCESS);
        d.assertItemNames(4, "A");
        a1.keepLog(false);
        d.recompute(Result.SUCCESS);
        d.assertItemNames(5, new String[0]);
    }

    @Test
    void runningBuildWithAbortBuildsOption() throws Exception {
        SampleComputedFolder folder = (SampleComputedFolder)this.r.jenkins.createProject(SampleComputedFolder.class, "d");
        DefaultOrphanedItemStrategy strategy = new DefaultOrphanedItemStrategy(true, -1, -1);
        strategy.setAbortBuilds(true);
        folder.setOrphanedItemStrategy((OrphanedItemStrategy)strategy);
        folder.kids.addAll(Arrays.asList("A", "B"));
        folder.recompute(Result.SUCCESS);
        folder.assertItemNames(1, "A", "B");
        ((FreeStyleProject)folder.getItem("B")).getBuildersList().add((Object)new SleepBuilder(Long.MAX_VALUE));
        ((FreeStyleProject)folder.getItem("B")).setConcurrentBuild(true);
        FreeStyleBuild bBuild1 = (FreeStyleBuild)((FreeStyleProject)folder.getItem("B")).scheduleBuild2(0).waitForStart();
        FreeStyleBuild bBuild2 = (FreeStyleBuild)((FreeStyleProject)folder.getItem("B")).scheduleBuild2(0).waitForStart();
        folder.kids.remove("B");
        folder.recompute(Result.SUCCESS);
        folder.assertItemNames(2, "A");
        for (FreeStyleBuild bBuild : new FreeStyleBuild[]{bBuild1, bBuild2}) {
            Assertions.assertFalse((boolean)bBuild.isBuilding());
            this.r.assertBuildStatus(Result.ABORTED, (Run)((FreeStyleBuild)this.r.waitForCompletion((Run)bBuild)));
            InterruptedBuildAction interruptedBuildAction = (InterruptedBuildAction)bBuild.getAction(InterruptedBuildAction.class);
            CauseOfInterruption causeOfInterruption = (CauseOfInterruption)interruptedBuildAction.getCauses().stream().findFirst().orElseThrow(NoSuchElementException::new);
            Assertions.assertInstanceOf(OrphanedParent.class, (Object)causeOfInterruption);
        }
        folder.recompute(Result.SUCCESS);
        folder.assertItemNames(3, "A");
        FreeStyleBuild aBuild1 = (FreeStyleBuild)((FreeStyleProject)folder.getItem("A")).scheduleBuild2(0).get();
        FreeStyleBuild aBuild2 = (FreeStyleBuild)((FreeStyleProject)folder.getItem("A")).scheduleBuild2(0).get();
        aBuild1.keepLog(true);
        folder.kids.remove("A");
        folder.recompute(Result.SUCCESS);
        folder.assertItemNames(4, "A");
        aBuild1.keepLog(false);
        folder.recompute(Result.SUCCESS);
        folder.assertItemNames(5, new String[0]);
    }

    @Test
    void runningWorkflowJobBuildWithAbortBuildsOption() throws Exception {
        SampleComputedFolderWithWorkflowJobAsChildren folder = (SampleComputedFolderWithWorkflowJobAsChildren)this.r.jenkins.createProject(SampleComputedFolderWithWorkflowJobAsChildren.class, "d");
        DefaultOrphanedItemStrategy strategy = new DefaultOrphanedItemStrategy(true, -1, -1);
        strategy.setAbortBuilds(true);
        folder.setOrphanedItemStrategy((OrphanedItemStrategy)strategy);
        folder.kids.add("kid");
        folder.recompute(Result.SUCCESS);
        folder.assertItemNames(1, "kid");
        ((WorkflowJob)folder.getItem("kid")).setDefinition((FlowDefinition)new CpsFlowDefinition("semaphore('wait')", true));
        WorkflowRun build1 = (WorkflowRun)((WorkflowJob)folder.getItem("kid")).scheduleBuild2(0, new Action[0]).waitForStart();
        WorkflowRun build2 = (WorkflowRun)((WorkflowJob)folder.getItem("kid")).scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"wait/1", (Run)build1);
        SemaphoreStep.waitForStart((String)"wait/2", (Run)build2);
        folder.kids.remove("kid");
        folder.recompute(Result.SUCCESS);
        folder.assertItemNames(2, new String[0]);
        for (WorkflowRun build : new WorkflowRun[]{build1, build2}) {
            Assertions.assertFalse((boolean)build.isBuilding());
            this.r.assertBuildStatus(Result.ABORTED, (Run)((WorkflowRun)this.r.waitForCompletion((Run)build)));
            InterruptedBuildAction interruptedBuildAction = (InterruptedBuildAction)build.getAction(InterruptedBuildAction.class);
            CauseOfInterruption causeOfInterruption = (CauseOfInterruption)interruptedBuildAction.getCauses().stream().findFirst().orElseThrow(NoSuchElementException::new);
            Assertions.assertInstanceOf(OrphanedParent.class, (Object)causeOfInterruption);
        }
    }

    @Test
    void pendingBuildWithAbortBuildsOption() throws Exception {
        SampleComputedFolder folder = (SampleComputedFolder)this.r.jenkins.createProject(SampleComputedFolder.class, "d");
        DefaultOrphanedItemStrategy strategy = new DefaultOrphanedItemStrategy(true, -1, -1);
        strategy.setAbortBuilds(true);
        folder.setOrphanedItemStrategy((OrphanedItemStrategy)strategy);
        folder.kids.add("kid");
        folder.recompute(Result.SUCCESS);
        folder.assertItemNames(1, "kid");
        ((FreeStyleProject)folder.getItem("kid")).setAssignedLabel((Label)new LabelAtom("never-matching-label"));
        ((FreeStyleProject)folder.getItem("kid")).setConcurrentBuild(true);
        Queue jenkinsQueue = Jenkins.get().getQueue();
        Queue.WaitingItem pendingBuild = jenkinsQueue.schedule((Queue.Task)folder.getItem("kid"), 0);
        Assertions.assertNotNull((Object)pendingBuild);
        folder.kids.remove("kid");
        folder.recompute(Result.SUCCESS);
        folder.assertItemNames(2, new String[0]);
        Assertions.assertThrows(CancellationException.class, () -> pendingBuild.getFuture().get());
    }

    @Test
    void notAddChildren() throws Exception {
        JenkinsRule.WebClient client = this.r.createWebClient();
        SampleComputedFolder s = (SampleComputedFolder)this.r.jenkins.createProject(SampleComputedFolder.class, "s");
        Assertions.assertEquals((int)0, (int)client.getPage((Item)s).getByXPath("//a[contains(text(), \"New Item\")]").size());
        s.kids.add("A");
        s.recompute(Result.SUCCESS);
        Assertions.assertEquals((int)0, (int)client.getPage((Item)s).getByXPath("//a[contains(text(), \"New Item\")]").size());
    }

    @Test
    void runByTrigger() throws Exception {
        SampleComputedFolder s = (SampleComputedFolder)this.r.jenkins.createProject(SampleComputedFolder.class, "s");
        s.assertItemNames(0, new String[0]);
        PeriodicFolderTrigger t = new PeriodicFolderTrigger("1m");
        s.addTrigger((Trigger)t);
        t.run();
        this.r.waitUntilNoActivity();
        s.assertItemNames(1, new String[0]);
    }

    @Test
    void runningBuildMeta() throws Exception {
        SecondOrderComputedFolder org = (SecondOrderComputedFolder)this.r.jenkins.createProject(SecondOrderComputedFolder.class, "org");
        org.metakids.add(Arrays.asList("A", "B"));
        org.metakids.add(Arrays.asList("C", "D"));
        org.assertItemNames("A+B", "C+D");
        FreeStyleProject b = (FreeStyleProject)this.r.jenkins.getItemByFullName("org/A+B/B", FreeStyleProject.class);
        b.getBuildersList().add((Object)new SleepBuilder(Long.MAX_VALUE));
        FreeStyleBuild b1 = (FreeStyleBuild)b.scheduleBuild2(0).waitForStart();
        org.metakids.remove(0);
        org.assertItemNames("A+B", "C+D");
        Assertions.assertTrue((boolean)b1.isBuilding());
        b1.doStop();
        this.r.assertBuildStatus(Result.ABORTED, (Run)((FreeStyleBuild)this.r.waitForCompletion((Run)b1)));
        org.assertItemNames("C+D");
    }

    @Test
    void viewHolderRestrictions() throws Exception {
        LockedDownSampleComputedFolder org = (LockedDownSampleComputedFolder)this.r.jenkins.createProject(LockedDownSampleComputedFolder.class, "org");
        MatcherAssert.assertThat((Object)org.getViews().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)org.getPrimaryView().getViewName(), (Matcher)Matchers.is((Object)"Empty"));
        MatcherAssert.assertThat((Object)org.getView("All"), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)org.getFolderViews().isPrimaryModifiable(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)org.getFolderViews().isViewsModifiable(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)org.getFolderViews().isTabBarModifiable(), (Matcher)Matchers.is((Object)false));
        org.setPrimaryView(org.getView("All"));
        MatcherAssert.assertThat((Object)org.getPrimaryView().getViewName(), (Matcher)Matchers.is((Object)"Empty"));
        org.addView((View)new MyView("mine", (ViewGroup)org));
        MatcherAssert.assertThat((Object)org.getViews().size(), (Matcher)Matchers.is((Object)2));
        JenkinsRule.WebClient client = this.r.createWebClient();
        HtmlPage configure = client.getPage((Item)org, "configure");
        MatcherAssert.assertThat((Object)configure.getElementsByName("primaryView"), (Matcher)Matchers.is(Collections.emptyList()));
        SampleComputedFolder org2 = (SampleComputedFolder)this.r.jenkins.createProject(SampleComputedFolder.class, "org2");
        configure = client.getPage((Item)org, "configure");
        MatcherAssert.assertThat((Object)configure.getElementsByName("primaryView"), (Matcher)Matchers.is(Collections.emptyList()));
        org2.addView((View)new MyView("mine", (ViewGroup)org2));
        configure = client.getPage((Item)org2, "configure");
        MatcherAssert.assertThat((Object)configure.getElementsByName("primaryView"), (Matcher)Matchers.not((Matcher)Matchers.is(Collections.emptyList())));
    }

    @Test
    void recomputationSuppression() throws Exception {
        VariableRecomputationComputedFolder org = (VariableRecomputationComputedFolder)this.r.jenkins.createProject(VariableRecomputationComputedFolder.class, "org");
        this.r.waitUntilNoActivity();
        int round = org.round;
        this.r.configRoundtrip((Item)org);
        this.r.waitUntilNoActivity();
        MatcherAssert.assertThat((Object)org.round, (Matcher)Matchers.is((Object)(round + 1)));
        org.submit = () -> org.recalculateAfterSubmitted(true);
        round = org.round;
        this.r.configRoundtrip((Item)org);
        this.r.waitUntilNoActivity();
        MatcherAssert.assertThat((Object)org.round, (Matcher)Matchers.is((Object)(round + 1)));
        org.submit = () -> org.recalculateAfterSubmitted(false);
        round = org.round;
        this.r.configRoundtrip((Item)org);
        this.r.waitUntilNoActivity();
        MatcherAssert.assertThat((Object)org.round, (Matcher)Matchers.is((Object)round));
    }

    @Test
    void recomputationSuppressionMulti() throws Exception {
        VariableRecomputationComputedFolder org = (VariableRecomputationComputedFolder)this.r.jenkins.createProject(VariableRecomputationComputedFolder.class, "org");
        org.submit = () -> {
            org.recalculateAfterSubmitted(true);
            org.recalculateAfterSubmitted(true);
        };
        int round = org.round;
        this.r.configRoundtrip((Item)org);
        this.r.waitUntilNoActivity();
        MatcherAssert.assertThat((Object)org.round, (Matcher)Matchers.is((Object)(round + 1)));
        org.submit = () -> {
            org.recalculateAfterSubmitted(true);
            org.recalculateAfterSubmitted(false);
        };
        round = org.round;
        this.r.configRoundtrip((Item)org);
        this.r.waitUntilNoActivity();
        MatcherAssert.assertThat((Object)org.round, (Matcher)Matchers.is((Object)(round + 1)));
        org.submit = () -> {
            org.recalculateAfterSubmitted(false);
            org.recalculateAfterSubmitted(true);
        };
        round = org.round;
        this.r.configRoundtrip((Item)org);
        this.r.waitUntilNoActivity();
        MatcherAssert.assertThat((Object)org.round, (Matcher)Matchers.is((Object)(round + 1)));
        org.submit = () -> {
            org.recalculateAfterSubmitted(false);
            org.recalculateAfterSubmitted(false);
        };
        round = org.round;
        this.r.configRoundtrip((Item)org);
        this.r.waitUntilNoActivity();
        MatcherAssert.assertThat((Object)org.round, (Matcher)Matchers.is((Object)round));
    }

    @Test
    void triggersRoundtrip() throws Exception {
        SampleComputedFolder s = (SampleComputedFolder)this.r.jenkins.createProject(SampleComputedFolder.class, "s");
        s.addTrigger((Trigger)new PeriodicFolderTrigger("30m"));
        SampleComputedFolder s2 = (SampleComputedFolder)this.r.configRoundtrip((Item)s);
        Trigger trigger = (Trigger)s2.getTriggers().get(this.r.jenkins.getDescriptorByType(PeriodicFolderTrigger.DescriptorImpl.class));
        MatcherAssert.assertThat((Object)trigger, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)trigger, (Matcher)Matchers.instanceOf(PeriodicFolderTrigger.class));
        MatcherAssert.assertThat((Object)((PeriodicFolderTrigger)trigger).getInterval(), (Matcher)Matchers.is((Object)"30m"));
    }

    @Test
    void cleanTriggers() throws Exception {
        SampleComputedFolder s = (SampleComputedFolder)this.r.jenkins.createProject(SampleComputedFolder.class, "s");
        s.addTrigger((Trigger)new PeriodicFolderTrigger("30m"));
        Assertions.assertEquals((int)1, (int)s.getTriggers().size());
        s.removeTrigger((Trigger)new PeriodicFolderTrigger("30m"));
        Assertions.assertEquals((int)0, (int)s.getTriggers().size());
    }

    @Test
    void concurrentEvents() throws Exception {
        CoordinatedComputedFolder d = (CoordinatedComputedFolder)this.r.jenkins.createProject(CoordinatedComputedFolder.class, "d");
        d.kids.addAll(Arrays.asList("A", "B"));
        QueueTaskFuture future = d.scheduleBuild2(0, new Action[0]).getFuture();
        d.onKid("B");
        future.get();
        this.waitUntilNoActivityIgnoringThreadDeathUpTo(10000);
        ArrayList<Throwable> deaths = new ArrayList<Throwable>();
        for (Computer comp : this.r.jenkins.getComputers()) {
            for (Executor e : comp.getExecutors()) {
                if (e.getCauseOfDeath() == null) continue;
                deaths.add(e.getCauseOfDeath());
            }
            for (Executor e : comp.getOneOffExecutors()) {
                if (e.getCauseOfDeath() == null) continue;
                deaths.add(e.getCauseOfDeath());
            }
        }
        MatcherAssert.assertThat((String)"None of the executors have died abnormally", deaths, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[0]));
    }

    @Test
    void deleteWhileComputing() throws Exception {
        FolderComputation computation;
        CoordinatedComputedFolder d = (CoordinatedComputedFolder)this.r.jenkins.createProject(CoordinatedComputedFolder.class, "d");
        d.kids.addAll(Arrays.asList("A", "B"));
        QueueTaskFuture future = d.scheduleBuild2(0, new Action[0]).getFuture();
        while (Executor.of((Queue.Executable)(computation = d.getComputation())) == null) {
            Thread.sleep(50L);
        }
        d.delete();
        MatcherAssert.assertThat((Object)computation.getResult(), (Matcher)Matchers.is((Object)Result.ABORTED));
    }

    @Test
    void renameWhileComputing() throws Exception {
        CoordinatedComputedFolder d = (CoordinatedComputedFolder)this.r.jenkins.createProject(CoordinatedComputedFolder.class, "d");
        d.kids.addAll(Arrays.asList("A", "B"));
        QueueTaskFuture future = d.scheduleBuild2(0, new Action[0]).getFuture();
        future.waitForStart();
        Failure f = (Failure)Assertions.assertThrows(Failure.class, () -> d.checkRename("d2"), (String)"Should be blocked while computation is in progress");
        MatcherAssert.assertThat((Object)f.getMessage(), (Matcher)Matchers.is((Object)Messages.ComputedFolder_ComputationInProgress()));
        d.onKid("B");
        future.get();
        this.waitUntilNoActivityIgnoringThreadDeathUpTo(10000);
        d.checkRename("d2");
    }

    @Test
    void failAllDeletedOnes() throws Exception {
        OneUndeletableChildComputedFolder d = (OneUndeletableChildComputedFolder)this.r.jenkins.createProject(OneUndeletableChildComputedFolder.class, "d");
        d.kids.addAll(Arrays.asList("A", "B"));
        d.recompute(Result.SUCCESS);
        d.assertItemNames(1, "A", "B");
        d.kids.clear();
        d.recompute(Result.FAILURE);
        d.assertItemNames(2, "A");
    }

    @Test
    void disabledWarningFromUiViews() throws Exception {
        LockedDownSampleComputedFolder folder = (LockedDownSampleComputedFolder)this.r.jenkins.createProject(LockedDownSampleComputedFolder.class, "d");
        Assertions.assertFalse((boolean)folder.isDisabled(), (String)"by default, a folder is disabled");
        for (View view : folder.getViews()) {
            Assertions.assertNull((Object)this.r.createWebClient().goTo(view.getViewUrl()).getElementById("disabled-message"));
        }
        folder.setDisabled(true);
        folder.save();
        for (View view : folder.getViews()) {
            Assertions.assertNotNull((Object)this.r.createWebClient().goTo(view.getViewUrl()).getElementById("disabled-message"));
        }
    }

    public void waitUntilNoActivityIgnoringThreadDeathUpTo(int timeout) throws Exception {
        long startTime = System.currentTimeMillis();
        int streak = 0;
        do {
            Thread.sleep(10L);
            streak = this.isSomethingHappeningIgnoringThreadDeath() ? 0 : ++streak;
            if (streak <= 5) continue;
            return;
        } while (System.currentTimeMillis() - startTime <= (long)timeout);
        ArrayList<Queue.Executable> building = new ArrayList<Queue.Executable>();
        ArrayList<Throwable> deaths = new ArrayList<Throwable>();
        for (Computer c : this.r.jenkins.getComputers()) {
            for (Executor e : c.getExecutors()) {
                if (!e.isBusy()) continue;
                if (e.getCauseOfDeath() == null) {
                    building.add(e.getCurrentExecutable());
                    continue;
                }
                deaths.add(e.getCauseOfDeath());
            }
            for (Executor e : c.getOneOffExecutors()) {
                if (!e.isBusy()) continue;
                if (e.getCauseOfDeath() == null) {
                    building.add(e.getCurrentExecutable());
                    continue;
                }
                deaths.add(e.getCauseOfDeath());
            }
        }
        ThreadInfo[] threadInfos = Functions.getThreadInfos();
        Functions.ThreadGroupMap m = Functions.sortThreadsAndGetGroupMap((ThreadInfo[])threadInfos);
        for (ThreadInfo ti : threadInfos) {
            System.err.println(Functions.dumpThreadInfo((ThreadInfo)ti, (Functions.ThreadGroupMap)m));
        }
        throw new AssertionError((Object)String.format("Jenkins is still doing something after %dms: queue=%s building=%s deaths=%s", timeout, Arrays.asList(this.r.jenkins.getQueue().getItems()), building, deaths));
    }

    public boolean isSomethingHappeningIgnoringThreadDeath() {
        if (!this.r.jenkins.getQueue().isEmpty()) {
            return true;
        }
        for (Computer n : this.r.jenkins.getComputers()) {
            for (OneOffExecutor e : n.getOneOffExecutors()) {
                if (e.getCauseOfDeath() != null || !e.isBusy()) continue;
                return true;
            }
            for (OneOffExecutor e : n.getExecutors()) {
                if (e.getCauseOfDeath() != null || !e.isBusy()) continue;
                return true;
            }
        }
        return false;
    }

    static String doRecompute(ComputedFolder<?> d, Result result) throws Exception {
        if (d.isDisabled()) {
            Assertions.assertEquals((Object)Result.NOT_BUILT, (Object)result, (String)("Folder " + d.getFullName() + " is disabled"));
            return "DISABLED";
        }
        d.scheduleBuild2(0, new Action[0]).getFuture().get();
        FolderComputation computation = d.getComputation();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        computation.writeWholeLogTo((OutputStream)baos);
        String log = baos.toString();
        Assertions.assertEquals((Object)result, (Object)computation.getResult(), (String)log);
        return log;
    }

    public static class SampleComputedFolder
    extends ComputedFolder<FreeStyleProject> {
        List<String> kids = new ArrayList<String>();
        int round;
        List<String> created = new ArrayList<String>();
        List<String> deleted = new ArrayList<String>();

        private SampleComputedFolder(ItemGroup parent, String name) {
            super(parent, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void computeChildren(ChildObserver<FreeStyleProject> observer, TaskListener listener) throws IOException, InterruptedException {
            ++this.round;
            listener.getLogger().println("=== Round #" + this.round + " ===");
            for (String kid : this.kids) {
                if (kid.equals("Z")) {
                    throw new AbortException("not adding Z");
                }
                listener.getLogger().println("considering " + kid);
                FreeStyleProject p = (FreeStyleProject)observer.shouldUpdate(kid);
                try {
                    if (p == null) {
                        if (observer.mayCreate(kid)) {
                            listener.getLogger().println("creating a child");
                            p = new FreeStyleProject((ItemGroup)this, kid);
                            p.setDescription("created in round #" + this.round);
                            observer.created((TopLevelItem)p);
                            this.created.add(kid);
                            continue;
                        }
                        listener.getLogger().println("not allowed to create a child");
                        continue;
                    }
                    listener.getLogger().println("updated existing child with description " + p.getDescription());
                    p.setDescription("updated in round #" + this.round);
                }
                finally {
                    observer.completed(kid);
                }
            }
        }

        protected Collection<FreeStyleProject> orphanedItems(Collection<FreeStyleProject> orphaned, TaskListener listener) throws IOException, InterruptedException {
            Collection deleting = super.orphanedItems(orphaned, listener);
            for (FreeStyleProject p : deleting) {
                String kid = p.getName();
                listener.getLogger().println("deleting " + kid + " in round #" + this.round);
                this.deleted.add(kid);
            }
            return deleting;
        }

        String recompute(Result result) throws Exception {
            return ComputedFolderTest.doRecompute(this, result);
        }

        void assertItemNames(int round, String ... names) {
            Assertions.assertEquals((int)round, (int)this.round);
            TreeSet<String> actual = new TreeSet<String>();
            for (FreeStyleProject p : this.getItems()) {
                actual.add(p.getName());
            }
            Assertions.assertEquals((Object)new TreeSet<String>(Arrays.asList(names)).toString(), (Object)((Object)actual).toString());
        }

        @TestExtension
        public static class DescriptorImpl
        extends AbstractFolderDescriptor {
            public TopLevelItem newInstance(ItemGroup parent, String name) {
                return new SampleComputedFolder(parent, name);
            }
        }
    }

    public static class SampleComputedFolderWithFoldersAsChildren
    extends ComputedFolder<Folder> {
        List<String> kids = new ArrayList<String>();
        int round;

        private SampleComputedFolderWithFoldersAsChildren(ItemGroup parent, String name) {
            super(parent, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void computeChildren(ChildObserver<Folder> observer, TaskListener listener) throws IOException, InterruptedException {
            ++this.round;
            listener.getLogger().println("=== Round #" + this.round + " ===");
            for (String kid : this.kids) {
                listener.getLogger().println("considering " + kid);
                Folder p = (Folder)observer.shouldUpdate(kid);
                try {
                    if (p == null) {
                        if (observer.mayCreate(kid)) {
                            listener.getLogger().println("creating a child");
                            p = new Folder((ItemGroup)this, kid);
                            p.setDescription("created in round #" + this.round);
                            observer.created((TopLevelItem)p);
                            continue;
                        }
                        listener.getLogger().println("not allowed to create a child");
                        continue;
                    }
                    listener.getLogger().println("updated existing child with description " + p.getDescription());
                    p.setDescription("updated in round #" + this.round);
                }
                finally {
                    observer.completed(kid);
                }
            }
        }

        String recompute(Result result) throws Exception {
            return ComputedFolderTest.doRecompute(this, result);
        }

        @TestExtension
        public static class DescriptorImpl
        extends AbstractFolderDescriptor {
            public TopLevelItem newInstance(ItemGroup parent, String name) {
                return new SampleComputedFolderWithFoldersAsChildren(parent, name);
            }
        }
    }

    public static class SampleComputedFolderWithWorkflowJobAsChildren
    extends ComputedFolder<WorkflowJob> {
        List<String> kids = new ArrayList<String>();
        int round;

        private SampleComputedFolderWithWorkflowJobAsChildren(ItemGroup parent, String name) {
            super(parent, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void computeChildren(ChildObserver<WorkflowJob> observer, TaskListener listener) throws IOException, InterruptedException {
            ++this.round;
            listener.getLogger().println("=== Round #" + this.round + " ===");
            for (String kid : this.kids) {
                listener.getLogger().println("considering " + kid);
                WorkflowJob p = (WorkflowJob)observer.shouldUpdate(kid);
                try {
                    if (p == null) {
                        if (observer.mayCreate(kid)) {
                            listener.getLogger().println("creating a child");
                            p = new WorkflowJob((ItemGroup)this, kid);
                            p.setDescription("created in round #" + this.round);
                            observer.created((TopLevelItem)p);
                            continue;
                        }
                        listener.getLogger().println("not allowed to create a child");
                        continue;
                    }
                    listener.getLogger().println("updated existing child with description " + p.getDescription());
                    p.setDescription("updated in round #" + this.round);
                }
                finally {
                    observer.completed(kid);
                }
            }
        }

        String recompute(Result result) throws Exception {
            return ComputedFolderTest.doRecompute(this, result);
        }

        void assertItemNames(int round, String ... names) {
            Assertions.assertEquals((int)round, (int)this.round);
            TreeSet<String> actual = new TreeSet<String>();
            for (WorkflowJob p : this.getItems()) {
                actual.add(p.getName());
            }
            Assertions.assertEquals((Object)new TreeSet<String>(Arrays.asList(names)).toString(), (Object)((Object)actual).toString());
        }

        @TestExtension
        public static class DescriptorImpl
        extends AbstractFolderDescriptor {
            public TopLevelItem newInstance(ItemGroup parent, String name) {
                return new SampleComputedFolderWithWorkflowJobAsChildren(parent, name);
            }
        }
    }

    public static class SecondOrderComputedFolder
    extends ComputedFolder<SampleComputedFolder> {
        List<List<String>> metakids = new ArrayList<List<String>>();

        private SecondOrderComputedFolder(ItemGroup parent, String name) {
            super(parent, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void computeChildren(ChildObserver<SampleComputedFolder> observer, TaskListener listener) throws IOException, InterruptedException {
            for (List<String> kids : this.metakids) {
                String childName = String.join((CharSequence)"+", kids);
                listener.getLogger().println("considering " + childName);
                SampleComputedFolder d = (SampleComputedFolder)observer.shouldUpdate(childName);
                try {
                    if (d == null) {
                        if (observer.mayCreate(childName)) {
                            listener.getLogger().println("creating a child");
                            d = new SampleComputedFolder((ItemGroup)this, childName);
                            d.kids = kids;
                            observer.created((TopLevelItem)d);
                            continue;
                        }
                        listener.getLogger().println("not allowed to create a child");
                        continue;
                    }
                    listener.getLogger().println("left existing child");
                }
                finally {
                    observer.completed(childName);
                }
            }
        }

        String assertItemNames(String ... names) throws Exception {
            String log = ComputedFolderTest.doRecompute(this, this.isDisabled() ? Result.NOT_BUILT : Result.SUCCESS);
            TreeSet<String> actual = new TreeSet<String>();
            Iterator iterator = this.getItems().iterator();
            while (iterator.hasNext()) {
                SampleComputedFolder d;
                d.recompute((d = (SampleComputedFolder)((Object)iterator.next())).isDisabled() || this.isDisabled() ? Result.NOT_BUILT : Result.SUCCESS);
                d.assertItemNames(d.round, d.kids.toArray(new String[0]));
                actual.add(d.getName());
            }
            Assertions.assertEquals((Object)new TreeSet<String>(Arrays.asList(names)).toString(), (Object)((Object)actual).toString());
            return log;
        }

        @TestExtension
        public static class DescriptorImpl
        extends AbstractFolderDescriptor {
            public TopLevelItem newInstance(ItemGroup parent, String name) {
                return new SecondOrderComputedFolder(parent, name);
            }
        }
    }

    public static class LockedDownSampleComputedFolder
    extends SampleComputedFolder {
        private LockedDownSampleComputedFolder(ItemGroup parent, String name) {
            super(parent, name);
        }

        protected AbstractFolderViewHolder newFolderViewHolder() {
            return new FixedViewHolder((ViewGroup)this);
        }

        private static class FixedViewHolder
        extends AbstractFolderViewHolder {
            final List<View> views;
            final ViewsTabBar tabBar = new DefaultViewsTabBar();

            public FixedViewHolder(ViewGroup owner) {
                this.views = new ArrayList<View>(Arrays.asList(new AllView("All", owner), new ListView("Empty", owner)));
            }

            @NonNull
            public List<View> getViews() {
                return Collections.unmodifiableList(this.views);
            }

            public void setViews(@NonNull List<? extends View> views) {
                throw new UnsupportedOperationException("Blow up if called");
            }

            public boolean isViewsModifiable() {
                return false;
            }

            public boolean isPrimaryModifiable() {
                return false;
            }

            public boolean isTabBarModifiable() {
                return false;
            }

            public String getPrimaryView() {
                return "Empty";
            }

            public void setPrimaryView(@CheckForNull String name) {
                throw new UnsupportedOperationException("Blow up if called");
            }

            @NonNull
            public ViewsTabBar getTabBar() {
                return this.tabBar;
            }

            public void setTabBar(@NonNull ViewsTabBar tabBar) {
                throw new UnsupportedOperationException("Blow up if called");
            }
        }

        @TestExtension
        public static class DescriptorImpl
        extends AbstractFolderDescriptor {
            public TopLevelItem newInstance(ItemGroup parent, String name) {
                return new LockedDownSampleComputedFolder(parent, name);
            }
        }
    }

    public static class VariableRecomputationComputedFolder
    extends SampleComputedFolder {
        private transient Runnable submit;

        private VariableRecomputationComputedFolder(ItemGroup parent, String name) {
            super(parent, name);
        }

        protected void submit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, Descriptor.FormException {
            super.submit(req, rsp);
            if (this.submit != null) {
                this.submit.run();
            }
        }

        @TestExtension
        public static class DescriptorImpl
        extends AbstractFolderDescriptor {
            public TopLevelItem newInstance(ItemGroup parent, String name) {
                return new VariableRecomputationComputedFolder(parent, name);
            }
        }
    }

    public static class CoordinatedComputedFolder
    extends ComputedFolder<FreeStyleProject> {
        List<String> kids = new ArrayList<String>();
        int round;
        List<String> created = new ArrayList<String>();
        List<String> deleted = new ArrayList<String>();
        transient CountDownLatch compute = new CountDownLatch(2);

        private CoordinatedComputedFolder(ItemGroup parent, String name) {
            super(parent, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void computeChildren(ChildObserver<FreeStyleProject> observer, TaskListener listener) throws IOException, InterruptedException {
            ++this.round;
            listener.getLogger().println("=== Round #" + this.round + " ===");
            ArrayList<String> kids = new ArrayList<String>(this.kids);
            this.compute.countDown();
            this.compute.await();
            for (String kid : kids) {
                Thread.sleep(25L);
                if (kid.equals("Z")) {
                    throw new AbortException("not adding Z");
                }
                listener.getLogger().println("considering " + kid);
                FreeStyleProject p = (FreeStyleProject)observer.shouldUpdate(kid);
                try {
                    if (p == null) {
                        if (observer.mayCreate(kid)) {
                            listener.getLogger().println("creating a child");
                            p = new FreeStyleProject((ItemGroup)this, kid);
                            p.setDescription("created in round #" + this.round);
                            p.getBuildersList().add((Object)new SleepBuilder(500L));
                            observer.created((TopLevelItem)p);
                            this.created.add(kid);
                            p.scheduleBuild(0, (Cause)new TimerTrigger.TimerTriggerCause());
                            continue;
                        }
                        listener.getLogger().println("not allowed to create a child");
                        continue;
                    }
                    listener.getLogger().println("updated existing child with description " + p.getDescription());
                    p.setDescription("updated in round #" + this.round);
                }
                finally {
                    observer.completed(kid);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onKid(String kid) throws InterruptedException {
            this.compute.countDown();
            this.compute.await();
            Thread.sleep(25L);
            try (StreamTaskListener listener = this.getComputation().createEventsListener();
                 ChildObserver observer = this.openEventsChildObserver();){
                listener.getLogger().println("considering " + kid);
                FreeStyleProject p = (FreeStyleProject)observer.shouldUpdate(kid);
                try {
                    if (p == null) {
                        if (observer.mayCreate(kid)) {
                            listener.getLogger().println("creating a child");
                            p = new FreeStyleProject((ItemGroup)this, kid);
                            p.setDescription("created in event #" + this.round);
                            p.getBuildersList().add((Object)new SleepBuilder(500L));
                            observer.created((TopLevelItem)p);
                            this.created.add(kid);
                            p.scheduleBuild(0, (Cause)new TimerTrigger.TimerTriggerCause());
                        } else {
                            listener.getLogger().println("not allowed to create a child");
                        }
                    } else {
                        listener.getLogger().println("updated existing child with description " + p.getDescription());
                        p.setDescription("updated in event #" + this.round);
                    }
                }
                finally {
                    observer.completed(kid);
                }
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        }

        protected Collection<FreeStyleProject> orphanedItems(Collection<FreeStyleProject> orphaned, TaskListener listener) throws IOException, InterruptedException {
            Collection deleting = super.orphanedItems(orphaned, listener);
            for (FreeStyleProject p : deleting) {
                String kid = p.getName();
                listener.getLogger().println("deleting " + kid + " in round #" + this.round);
                this.deleted.add(kid);
            }
            return deleting;
        }

        String recompute(Result result) throws Exception {
            return ComputedFolderTest.doRecompute(this, result);
        }

        void assertItemNames(int round, String ... names) {
            Assertions.assertEquals((int)round, (int)this.round);
            TreeSet<String> actual = new TreeSet<String>();
            for (FreeStyleProject p : this.getItems()) {
                actual.add(p.getName());
            }
            Assertions.assertEquals((Object)new TreeSet<String>(Arrays.asList(names)).toString(), (Object)((Object)actual).toString());
        }

        @TestExtension
        public static class DescriptorImpl
        extends AbstractFolderDescriptor {
            public TopLevelItem newInstance(ItemGroup parent, String name) {
                return new CoordinatedComputedFolder(parent, name);
            }
        }
    }

    public static class OneUndeletableChildComputedFolder
    extends ComputedFolder<FreeStyleProject> {
        List<String> kids = new ArrayList<String>();
        int round;

        private OneUndeletableChildComputedFolder(ItemGroup parent, String name) {
            super(parent, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void computeChildren(ChildObserver<FreeStyleProject> observer, TaskListener listener) throws IOException, InterruptedException {
            ++this.round;
            listener.getLogger().println("=== Round #" + this.round + " ===");
            for (final String kid : this.kids) {
                if (kid.equals("Z")) {
                    throw new AbortException("not adding Z");
                }
                listener.getLogger().println("considering " + kid);
                FreeStyleProject p = (FreeStyleProject)observer.shouldUpdate(kid);
                try {
                    if (p == null) {
                        if (observer.mayCreate(kid)) {
                            listener.getLogger().println("creating a child");
                            p = kid.equals("A") ? new FreeStyleProject(this, (ItemGroup)this, kid){
                                final /* synthetic */ OneUndeletableChildComputedFolder this$0;
                                {
                                    this.this$0 = this$0;
                                    super(parent, name);
                                }

                                public void delete() throws IOException, InterruptedException {
                                    throw new IOException(kid + " cannot be deleted");
                                }
                            } : new FreeStyleProject((ItemGroup)this, kid);
                            p.setDescription("created in round #" + this.round);
                            observer.created((TopLevelItem)p);
                            continue;
                        }
                        listener.getLogger().println("not allowed to create a child");
                        continue;
                    }
                    listener.getLogger().println("updated existing child with description " + p.getDescription());
                    p.setDescription("updated in round #" + this.round);
                }
                finally {
                    observer.completed(kid);
                }
            }
        }

        String recompute(Result result) throws Exception {
            return ComputedFolderTest.doRecompute(this, result);
        }

        void assertItemNames(int round, String ... names) {
            Assertions.assertEquals((int)round, (int)this.round);
            TreeSet<String> actual = new TreeSet<String>();
            for (FreeStyleProject p : this.getItems()) {
                actual.add(p.getName());
            }
            Assertions.assertEquals((Object)new TreeSet<String>(Arrays.asList(names)).toString(), (Object)((Object)actual).toString());
        }

        @TestExtension
        public static class DescriptorImpl
        extends AbstractFolderDescriptor {
            public TopLevelItem newInstance(ItemGroup parent, String name) {
                return new OneUndeletableChildComputedFolder(parent, name);
            }
        }
    }
}

