/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.hudson.plugins.folder.config.AbstractFolderConfiguration;
import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetricDescriptor;
import hudson.util.DescribableList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class FolderSystemPropertyTest {
    private static final String HEALTH_METRIC_PROPERTY = System.getProperty(AbstractFolderConfiguration.class.getName() + ".ADD_HEALTH_METRICS");
    private JenkinsRule r;

    FolderSystemPropertyTest() {
    }

    @BeforeAll
    static void beforeAll() {
        System.setProperty(AbstractFolderConfiguration.class.getName() + ".ADD_HEALTH_METRICS", "true");
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) {
        this.r = rule;
    }

    @AfterAll
    static void afterAll() {
        if (HEALTH_METRIC_PROPERTY != null) {
            System.setProperty(AbstractFolderConfiguration.class.getName() + ".ADD_HEALTH_METRICS", HEALTH_METRIC_PROPERTY);
        } else {
            System.clearProperty(AbstractFolderConfiguration.class.getName() + ".ADD_HEALTH_METRICS");
        }
    }

    @Test
    void shouldHaveHealthMetricConfiguredGloballyOnSystemProperty() throws Exception {
        MatcherAssert.assertThat((String)"if used .ADD_HEALTH_METRICS system property, global configuration should have all folder health metrics", (Object)AbstractFolderConfiguration.get().getHealthMetrics(), (Matcher)Matchers.hasSize((int)((int)FolderHealthMetricDescriptor.all().stream().filter(d -> d.createDefault() != null).count())));
        Folder folder = (Folder)this.r.jenkins.createProject(Folder.class, "myFolder");
        DescribableList healthMetrics = folder.getHealthMetrics();
        MatcherAssert.assertThat((String)"a new created folder should have all the folder health metrics configured globally", (Object)healthMetrics.toList(), (Matcher)Matchers.containsInAnyOrder((Object[])AbstractFolderConfiguration.get().getHealthMetrics().toArray()));
        AbstractFolderConfiguration.get().setHealthMetrics(null);
        folder = (Folder)this.r.jenkins.createProject(Folder.class, "myFolder2");
        healthMetrics = folder.getHealthMetrics();
        MatcherAssert.assertThat((String)"a new created folder should have all the folder health metrics configured globally", (Object)healthMetrics, (Matcher)Matchers.iterableWithSize((int)0));
    }
}

