/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderDescriptor;
import com.cloudbees.hudson.plugins.folder.ChildNameGenerator;
import com.cloudbees.hudson.plugins.folder.ChildNameGeneratorAltTest;
import com.cloudbees.hudson.plugins.folder.computed.ChildObserver;
import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.cloudbees.hudson.plugins.folder.computed.FolderComputation;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.BulkChange;
import hudson.Util;
import hudson.model.Action;
import hudson.model.FreeStyleProject;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Result;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import net.sf.json.JSONObject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.jvnet.hudson.test.TestExtension;
import org.jvnet.hudson.test.junit.jupiter.JenkinsSessionExtension;
import org.kohsuke.stapler.StaplerRequest2;

class ChildNameGeneratorRecTest {
    @RegisterExtension
    private final JenkinsSessionExtension extension = new JenkinsSessionExtension();

    ChildNameGeneratorRecTest() {
    }

    @Test
    void createdFromScratch() throws Throwable {
        this.extension.then(j -> {
            ComputedFolderImpl instance = (ComputedFolderImpl)j.createProject(ComputedFolderImpl.class, "instance");
            instance.assertItemNames(0, new String[0]);
            instance.recompute(Result.SUCCESS);
            instance.assertItemNames(1, new String[0]);
            instance.addKids("child-one", "child_two", "child three", "leanbh c\u00faig", "\u0440\u0435\u0431\u0435\u043d\u043e\u043a \u043f\u044f\u0442\u044c", "\u513f\u7ae5\u516d", "\uc544\uc774 7", "ni\u00f1o ocho");
            instance.recompute(Result.SUCCESS);
            this.checkComputedFolder(instance, 2);
        });
        this.extension.then(j -> {
            TopLevelItem i = j.jenkins.getItem("instance");
            MatcherAssert.assertThat((String)"Item loaded from disk", (Object)i, (Matcher)Matchers.instanceOf(ComputedFolderImpl.class));
            ComputedFolderImpl instance = (ComputedFolderImpl)i;
            this.checkComputedFolder(instance, 0);
            j.jenkins.reload();
            i = j.jenkins.getItem("instance");
            MatcherAssert.assertThat((String)"Item loaded from disk", (Object)i, (Matcher)Matchers.instanceOf(ComputedFolderImpl.class));
            instance = (ComputedFolderImpl)i;
            this.checkComputedFolder(instance, 0);
            instance.doReload();
            this.checkComputedFolder(instance, 0);
        });
    }

    private void checkComputedFolder(ComputedFolderImpl instance, int round) {
        instance.assertItemNames(round, "child-one", "child_two", "child three", "leanbh c\u00faig", "\u0440\u0435\u0431\u0435\u043d\u043e\u043a \u043f\u044f\u0442\u044c", "\u513f\u7ae5\u516d", "\uc544\uc774 7", "ni\u00f1o ocho");
        instance.assertItemShortUrls(round, "job/child-one/", "job/child_two/", "job/child%20three/", "job/leanbh%20c%C3%BAig/", "job/%D1%80%D0%B5%D0%B1%D0%B5%D0%BD%D0%BE%D0%BA%20%D0%BF%D1%8F%D1%82%D1%8C/", "job/%E5%84%BF%E7%AB%A5%E5%85%AD/", "job/%EC%95%84%EC%9D%B4%207/", "job/ni%C3%B1o%20ocho/");
        instance.assertItemDirs(round, "child_on-1ec93354e47959489d1440d", "child_tw-bca7d461e11f4f3ed12fd0d", "child_th-b7a6e5662f26eb036090308", "leanbh_c-cde398abd1bc432e87c49ca", "________-97e4b38574769f9d9968fe9", "___-d22e9fe51690274d8262bda", "_____7-d57fff123224bd679e4213b", "nin_o_oc-1a0c91070942136ba398919");
        for (String name : Arrays.asList("child-one", "child_two", "child three", "leanbh c\u00faig", "\u0440\u0435\u0431\u0435\u043d\u043e\u043a \u043f\u044f\u0442\u044c", "\u513f\u7ae5\u516d", "\uc544\uc774 7", "ni\u00f1o ocho")) {
            this.checkChild(instance, name);
        }
    }

    private void checkChild(ComputedFolderImpl instance, String idealName) {
        String encodedName = ChildNameGeneratorRecTest.encode(idealName);
        FreeStyleProject item = (FreeStyleProject)instance.getItem(encodedName);
        MatcherAssert.assertThat((String)("We have an item for name " + idealName), (Object)item, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)("The root directory of the item for name " + idealName + " is mangled"), (Object)item.getRootDir().getName(), (Matcher)Matchers.is((Object)ChildNameGeneratorRecTest.mangle(idealName)));
    }

    private static String encode(String s) {
        return s;
    }

    private static String mangle(String s) {
        String hash = Util.getDigestOf((String)s);
        String base = Normalizer.normalize(s, Normalizer.Form.NFD).toLowerCase(Locale.ENGLISH);
        StringBuilder buf = new StringBuilder(32);
        for (char c : base.toCharArray()) {
            if (buf.length() >= 8) break;
            if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9') {
                buf.append(Character.toLowerCase(c));
                continue;
            }
            buf.append('_');
        }
        buf.append('-');
        buf.append(hash, 0, 23);
        return buf.toString();
    }

    @NonNull
    public static String rawDecode(@NonNull String s) {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == 37 && i + 2 < bytes.length) {
                int u = Character.digit((char)bytes[++i], 16);
                int l = Character.digit((char)bytes[++i], 16);
                if (u != -1 && l != -1) {
                    buffer.write((char)((u << 4) + l));
                    continue;
                }
                i -= 2;
            }
            buffer.write(b);
        }
        return buffer.toString(StandardCharsets.UTF_8);
    }

    public static class ComputedFolderImpl
    extends ComputedFolder<FreeStyleProject> {
        private Set<String> fatalKids = new TreeSet<String>();
        private List<String> kids = new ArrayList<String>();
        private transient int round;
        private transient List<String> created;
        private transient List<String> deleted;

        private ComputedFolderImpl(ItemGroup parent, String name) {
            super(parent, name);
        }

        public int getRound() {
            return this.round;
        }

        public List<String> getCreated() {
            return this.created == null ? new ArrayList() : this.created;
        }

        public List<String> getDeleted() {
            return this.deleted == null ? new ArrayList() : this.deleted;
        }

        public Set<String> getFatalKids() {
            return this.fatalKids;
        }

        public void setFatalKids(Set<String> fatalKids) {
            if (!this.fatalKids.equals(fatalKids)) {
                this.fatalKids = new TreeSet<String>(fatalKids);
                try {
                    this.save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void setFatalKids(String ... fatalKids) {
            this.setFatalKids(new TreeSet<String>(Arrays.asList(fatalKids)));
        }

        public List<String> getKids() {
            return this.kids;
        }

        public void setKids(List<String> kids) {
            if (!this.kids.equals(kids)) {
                this.kids = new ArrayList<String>(kids);
                try {
                    this.save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void setKids(String ... kids) {
            this.setKids(Arrays.asList(kids));
        }

        public void addKid(String kid) {
            if (!this.kids.contains(kid)) {
                this.kids.add(kid);
                try {
                    this.save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void removeKid(String kid) {
            if (this.kids.remove(kid)) {
                try {
                    this.save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void addKids(String ... kids) {
            ArrayList<String> k = new ArrayList<String>(Arrays.asList(kids));
            k.removeAll(this.kids);
            if (this.kids.addAll(k)) {
                try {
                    this.save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void removeKids(String ... kid) {
            if (this.kids.removeAll(Arrays.asList(kid))) {
                try {
                    this.save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void computeChildren(ChildObserver<FreeStyleProject> observer, TaskListener listener) throws IOException, InterruptedException {
            ++this.round;
            this.created = new ArrayList<String>();
            this.deleted = new ArrayList<String>();
            listener.getLogger().println("=== Round #" + this.round + " ===");
            for (String kid : this.kids) {
                if (this.fatalKids.contains(kid)) {
                    throw new AbortException("not adding " + kid);
                }
                listener.getLogger().println("considering " + kid);
                String encodedKid = ChildNameGeneratorRecTest.encode(kid);
                FreeStyleProject p = (FreeStyleProject)observer.shouldUpdate(encodedKid);
                try {
                    if (p == null) {
                        if (observer.mayCreate(encodedKid)) {
                            listener.getLogger().println("creating a child");
                            p = new FreeStyleProject((ItemGroup)this, encodedKid);
                            BulkChange bc = new BulkChange((Saveable)p);
                            try {
                                p.addProperty((JobProperty)new NameProperty(kid));
                                p.setDescription("created in round #" + this.round);
                            }
                            finally {
                                bc.commit();
                            }
                            observer.created((TopLevelItem)p);
                            this.created.add(kid);
                            continue;
                        }
                        listener.getLogger().println("not allowed to create a child");
                        continue;
                    }
                    listener.getLogger().println("updated existing child with description " + p.getDescription());
                    p.setDescription("updated in round #" + this.round);
                }
                finally {
                    observer.completed(encodedKid);
                }
            }
        }

        protected Collection<FreeStyleProject> orphanedItems(Collection<FreeStyleProject> orphaned, TaskListener listener) throws IOException, InterruptedException {
            Collection deleting = super.orphanedItems(orphaned, listener);
            for (FreeStyleProject p : deleting) {
                String kid = p.getName();
                listener.getLogger().println("deleting " + kid + " in round #" + this.round);
                this.deleted.add(kid);
            }
            return deleting;
        }

        public String recompute(Result result) throws Exception {
            this.scheduleBuild2(0, new Action[0]).getFuture().get();
            FolderComputation computation = this.getComputation();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            computation.writeWholeLogTo((OutputStream)baos);
            String log = baos.toString();
            Assertions.assertEquals((Object)result, (Object)computation.getResult(), (String)log);
            return log;
        }

        public void assertItemNames(int round, String ... names) {
            Assertions.assertEquals((int)round, (int)this.round);
            TreeSet<String> actual = new TreeSet<String>();
            for (FreeStyleProject p : this.getItems()) {
                actual.add(p.getName());
            }
            MatcherAssert.assertThat(actual, (Matcher)Matchers.anyOf((Matcher)Matchers.is(new TreeSet<String>(Arrays.asList(names))), (Matcher)Matchers.is(ChildNameGeneratorAltTest.windowsFFS(names))));
        }

        public void assertItemShortUrls(int round, String ... names) {
            Assertions.assertEquals((int)round, (int)this.round);
            TreeSet<String> actual = new TreeSet<String>();
            for (FreeStyleProject p : this.getItems()) {
                actual.add(p.getShortUrl());
            }
            MatcherAssert.assertThat(actual, (Matcher)Matchers.is(new TreeSet<String>(Arrays.asList(names))));
        }

        public void assertItemDirs(int round, String ... names) {
            Assertions.assertEquals((int)round, (int)this.round);
            TreeSet<String> actual = new TreeSet<String>();
            for (FreeStyleProject p : this.getItems()) {
                actual.add(p.getRootDir().getName());
            }
            MatcherAssert.assertThat(actual, (Matcher)Matchers.is(new TreeSet<String>(Arrays.asList(names))));
        }

        @TestExtension
        public static class DescriptorImpl
        extends AbstractFolderDescriptor {
            private static final ChildNameGeneratorImpl GENERATOR = new ChildNameGeneratorImpl();

            public TopLevelItem newInstance(ItemGroup parent, String name) {
                return new ComputedFolderImpl(parent, name);
            }

            @NonNull
            public <I extends TopLevelItem> ChildNameGenerator<AbstractFolder<I>, I> childNameGenerator() {
                return GENERATOR;
            }
        }
    }

    private static class ChildNameGeneratorImpl<F extends AbstractFolder<J>, J extends FreeStyleProject>
    extends ChildNameGenerator<F, J> {
        private ChildNameGeneratorImpl() {
        }

        public String itemNameFromItem(@NonNull F parent, @NonNull J item) {
            NameProperty property = (NameProperty)item.getProperty(NameProperty.class);
            if (property != null) {
                return ChildNameGeneratorRecTest.encode(property.getName());
            }
            String name = item.getName();
            return name == null ? null : ChildNameGeneratorRecTest.encode(name);
        }

        public String dirNameFromItem(@NonNull F parent, @NonNull J item) {
            NameProperty property = (NameProperty)item.getProperty(NameProperty.class);
            if (property != null) {
                return ChildNameGeneratorRecTest.mangle(property.getName());
            }
            String name = item.getName();
            return name == null ? null : ChildNameGeneratorRecTest.mangle(name);
        }

        @NonNull
        public String itemNameFromLegacy(@NonNull F parent, @NonNull String legacyDirName) {
            return ChildNameGeneratorRecTest.rawDecode(legacyDirName);
        }

        @NonNull
        public String dirNameFromLegacy(@NonNull F parent, @NonNull String legacyDirName) {
            return ChildNameGeneratorRecTest.mangle(ChildNameGeneratorRecTest.rawDecode(legacyDirName));
        }
    }

    public static class NameProperty
    extends JobProperty<FreeStyleProject> {
        private final String name;

        public NameProperty(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public JobProperty<?> reconfigure(StaplerRequest2 req, JSONObject form) {
            return this;
        }

        @TestExtension
        public static class DescriptorImpl
        extends JobPropertyDescriptor {
            public boolean isApplicable(Class<? extends Job> jobType) {
                return FreeStyleProject.class.isAssignableFrom(jobType);
            }

            public String getDisplayName() {
                return null;
            }
        }
    }
}

