// CHECKSTYLE:OFF

package com.cloudbees.hudson.plugins.folder.properties;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code folder}: {@code Folder}.
     * 
     * @return
     *     {@code Folder}
     */
    public static String folder() {
        return holder.format("folder");
    }

    /**
     * Key {@code folder}: {@code Folder}.
     * 
     * @return
     *     {@code Folder}
     */
    public static Localizable _folder() {
        return new Localizable(holder, "folder");
    }

    /**
     * Key {@code FolderCredentialsProvider_DisplayName}: {@code

     * Credentials}.
     * 
     * @return
     *     {@code Credentials}
     */
    public static String FolderCredentialsProvider_DisplayName() {
        return holder.format("FolderCredentialsProvider_DisplayName");
    }

    /**
     * Key {@code FolderCredentialsProvider_DisplayName}: {@code

     * Credentials}.
     * 
     * @return
     *     {@code Credentials}
     */
    public static Localizable _FolderCredentialsProvider_DisplayName() {
        return new Localizable(holder, "FolderCredentialsProvider_DisplayName");
    }

}
