// CHECKSTYLE:OFF

package com.cloudbees.hudson.plugins.folder.health;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code WorstChildHealthMetric.DisplayName}: {@code Child item with
     * worst health}.
     * 
     * @return
     *     {@code Child item with worst health}
     */
    public static String WorstChildHealthMetric_DisplayName() {
        return holder.format("WorstChildHealthMetric.DisplayName");
    }

    /**
     * Key {@code WorstChildHealthMetric.DisplayName}: {@code Child item with
     * worst health}.
     * 
     * @return
     *     {@code Child item with worst health}
     */
    public static Localizable _WorstChildHealthMetric_DisplayName() {
        return new Localizable(holder, "WorstChildHealthMetric.DisplayName");
    }

    /**
     * Key {@code NamedChildHealthMetric.DisplayName}: {@code Child item with
     * the given name}.
     * 
     * @return
     *     {@code Child item with the given name}
     */
    public static String NamedChildHealthMetric_DisplayName() {
        return holder.format("NamedChildHealthMetric.DisplayName");
    }

    /**
     * Key {@code NamedChildHealthMetric.DisplayName}: {@code Child item with
     * the given name}.
     * 
     * @return
     *     {@code Child item with the given name}
     */
    public static Localizable _NamedChildHealthMetric_DisplayName() {
        return new Localizable(holder, "NamedChildHealthMetric.DisplayName");
    }

    /**
     * Key {@code Folder.HealthWrap}: {@code Worst health: {0}: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Worst health: {0}: {1}}
     */
    public static String Folder_HealthWrap(Object arg0, Object arg1) {
        return holder.format("Folder.HealthWrap", arg0, arg1);
    }

    /**
     * Key {@code Folder.HealthWrap}: {@code Worst health: {0}: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Worst health: {0}: {1}}
     */
    public static Localizable _Folder_HealthWrap(Object arg0, Object arg1) {
        return new Localizable(holder, "Folder.HealthWrap", arg0, arg1);
    }

}
