/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.properties;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.hudson.plugins.folder.properties.FolderCredentialsProvider;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import jenkins.security.QueueItemAuthenticatorConfiguration;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.MockAuthorizationStrategy;
import org.jvnet.hudson.test.MockQueueItemAuthenticator;
import org.jvnet.hudson.test.TestBuilder;
import org.springframework.security.core.Authentication;

public class FolderCredentialsProviderTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();

    @Test
    public void foldersHaveTheirOwnStore() throws Exception {
        Folder f = this.createFolder();
        CredentialsStore folderStore = this.getFolderStore(f);
        MatcherAssert.assertThat((Object)folderStore, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void credentialsAvailableAtFolderScope() throws Exception {
        Folder f = this.createFolder();
        List asGroup = CredentialsProvider.lookupCredentialsInItemGroup(StandardUsernamePasswordCredentials.class, (ItemGroup)f, (Authentication)ACL.SYSTEM2, Collections.emptyList());
        List asItem = CredentialsProvider.lookupCredentialsInItem(StandardUsernamePasswordCredentials.class, (Item)f, (Authentication)ACL.SYSTEM2, Collections.emptyList());
        MatcherAssert.assertThat((Object)asGroup, (Matcher)Matchers.is((Object)asItem));
        CredentialsStore folderStore = this.getFolderStore(f);
        UsernamePasswordCredentialsImpl credentials = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "test-id", "description", "test-user", "secret");
        folderStore.addCredentials(Domain.global(), (Credentials)credentials);
        asGroup = CredentialsProvider.lookupCredentialsInItemGroup(StandardUsernamePasswordCredentials.class, (ItemGroup)f, (Authentication)ACL.SYSTEM2, Collections.emptyList());
        asItem = CredentialsProvider.lookupCredentialsInItem(StandardUsernamePasswordCredentials.class, (Item)f, (Authentication)ACL.SYSTEM2, Collections.emptyList());
        MatcherAssert.assertThat((Object)asGroup, (Matcher)Matchers.is((Object)asItem));
        MatcherAssert.assertThat((Object)asGroup, (Matcher)Matchers.hasItem((Object)credentials));
        MatcherAssert.assertThat((Object)asItem, (Matcher)Matchers.hasItem((Object)credentials));
    }

    @Test
    public void credentialsListableAtFolderScope() throws Exception {
        Folder f = this.createFolder();
        ListBoxModel asGroup = CredentialsProvider.listCredentialsInItemGroup(StandardUsernamePasswordCredentials.class, (ItemGroup)f, (Authentication)ACL.SYSTEM2, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.always());
        ListBoxModel asItem = CredentialsProvider.listCredentialsInItem(StandardUsernamePasswordCredentials.class, (Item)f, (Authentication)ACL.SYSTEM2, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.always());
        MatcherAssert.assertThat((Object)asGroup, (Matcher)Matchers.is((Object)asItem));
        MatcherAssert.assertThat((Object)asGroup.size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)asItem.size(), (Matcher)Matchers.is((Object)0));
        CredentialsStore folderStore = this.getFolderStore(f);
        UsernamePasswordCredentialsImpl credentials = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "test-id", "description", "test-user", "secret");
        folderStore.addCredentials(Domain.global(), (Credentials)credentials);
        asGroup = CredentialsProvider.listCredentialsInItemGroup(StandardUsernamePasswordCredentials.class, (ItemGroup)f, (Authentication)ACL.SYSTEM2, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.always());
        asItem = CredentialsProvider.listCredentialsInItem(StandardUsernamePasswordCredentials.class, (Item)f, (Authentication)ACL.SYSTEM2, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.always());
        MatcherAssert.assertThat((Object)asGroup.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ListBoxModel.Option)asGroup.get((int)0)).value, (Matcher)Matchers.is((Object)"test-id"));
        MatcherAssert.assertThat((Object)asItem.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ListBoxModel.Option)asItem.get((int)0)).value, (Matcher)Matchers.is((Object)"test-id"));
    }

    @Test
    public void given_folderCredential_when_builtAsSystem_then_credentialFound() throws Exception {
        Folder f = this.createFolder();
        CredentialsStore folderStore = this.getFolderStore(f);
        folderStore.addCredentials(Domain.global(), (Credentials)new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "foo-manchu", "Dr. Fu Manchu", "foo", "manchu"));
        FreeStyleProject prj = (FreeStyleProject)f.createProject(FreeStyleProject.class, "job");
        prj.getBuildersList().add((Object)new HasCredentialBuilder("foo-manchu"));
        this.r.buildAndAssertSuccess(prj);
    }

    @Test
    public void given_folderCredential_when_builtAsUserWithUseItem_then_credentialFound() throws Exception {
        Folder f = this.createFolder();
        CredentialsStore folderStore = this.getFolderStore(f);
        folderStore.addCredentials(Domain.global(), (Credentials)new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "foo-manchu", "Dr. Fu Manchu", "foo", "manchu"));
        FreeStyleProject prj = (FreeStyleProject)f.createProject(FreeStyleProject.class, "job");
        prj.getBuildersList().add((Object)new HasCredentialBuilder("foo-manchu"));
        JenkinsRule.DummySecurityRealm realm = this.r.createDummySecurityRealm();
        this.r.jenkins.setSecurityRealm((SecurityRealm)realm);
        MockAuthorizationStrategy strategy = new MockAuthorizationStrategy();
        strategy.grant(new Permission[]{CredentialsProvider.USE_ITEM}).everywhere().to(new String[]{"bob"});
        strategy.grant(new Permission[]{Item.BUILD}).everywhere().to(new String[]{"bob"});
        strategy.grant(new Permission[]{Computer.BUILD}).everywhere().to(new String[]{"bob"});
        this.r.jenkins.setAuthorizationStrategy((AuthorizationStrategy)strategy);
        MockQueueItemAuthenticator authenticator = new MockQueueItemAuthenticator().authenticate(prj.getFullName(), User.getById((String)"bob", (boolean)true).impersonate2());
        QueueItemAuthenticatorConfiguration.get().getAuthenticators().clear();
        QueueItemAuthenticatorConfiguration.get().getAuthenticators().add((Object)authenticator);
        this.r.buildAndAssertSuccess(prj);
    }

    @Test
    public void given_folderCredential_when_builtAsUserWithoutUseItem_then_credentialNotFound() throws Exception {
        Folder f = this.createFolder();
        CredentialsStore folderStore = this.getFolderStore(f);
        folderStore.addCredentials(Domain.global(), (Credentials)new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "foo-manchu", "Dr. Fu Manchu", "foo", "manchu"));
        FreeStyleProject prj = (FreeStyleProject)f.createProject(FreeStyleProject.class, "job");
        prj.getBuildersList().add((Object)new HasCredentialBuilder("foo-manchu"));
        JenkinsRule.DummySecurityRealm realm = this.r.createDummySecurityRealm();
        this.r.jenkins.setSecurityRealm((SecurityRealm)realm);
        MockAuthorizationStrategy strategy = new MockAuthorizationStrategy();
        strategy.grant(new Permission[]{Item.BUILD}).everywhere().to(new String[]{"bob"});
        strategy.grant(new Permission[]{Computer.BUILD}).everywhere().to(new String[]{"bob"});
        this.r.jenkins.setAuthorizationStrategy((AuthorizationStrategy)strategy);
        MockQueueItemAuthenticator authenticator = new MockQueueItemAuthenticator().authenticate(prj.getFullName(), User.getById((String)"bob", (boolean)true).impersonate2());
        QueueItemAuthenticatorConfiguration.get().getAuthenticators().clear();
        QueueItemAuthenticatorConfiguration.get().getAuthenticators().add((Object)authenticator);
        this.r.assertBuildStatus(Result.FAILURE, (Run)((FreeStyleBuild)prj.scheduleBuild2(0).get()));
    }

    @Test
    public void given_folderAndSystemCredentials_when_builtAsUserWithUseItem_then_folderCredentialFound() throws Exception {
        SystemCredentialsProvider.getInstance().getCredentials().add(new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "foo-manchu", "You don't want me", "bar", "fly"));
        Folder f = this.createFolder();
        CredentialsStore folderStore = this.getFolderStore(f);
        folderStore.addCredentials(Domain.global(), (Credentials)new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "foo-manchu", "Dr. Fu Manchu", "foo", "manchu"));
        FreeStyleProject prj = (FreeStyleProject)f.createProject(FreeStyleProject.class, "job");
        prj.getBuildersList().add((Object)new HasCredentialBuilder("foo-manchu", Matchers.hasProperty((String)"username", (Matcher)Matchers.is((Object)"foo"))));
        JenkinsRule.DummySecurityRealm realm = this.r.createDummySecurityRealm();
        this.r.jenkins.setSecurityRealm((SecurityRealm)realm);
        MockAuthorizationStrategy strategy = new MockAuthorizationStrategy();
        strategy.grant(new Permission[]{CredentialsProvider.USE_ITEM}).everywhere().to(new String[]{"bob"});
        strategy.grant(new Permission[]{Item.BUILD}).everywhere().to(new String[]{"bob"});
        strategy.grant(new Permission[]{Computer.BUILD}).everywhere().to(new String[]{"bob"});
        this.r.jenkins.setAuthorizationStrategy((AuthorizationStrategy)strategy);
        MockQueueItemAuthenticator authenticator = new MockQueueItemAuthenticator().authenticate(prj.getFullName(), User.getById((String)"bob", (boolean)true).impersonate2());
        QueueItemAuthenticatorConfiguration.get().getAuthenticators().clear();
        QueueItemAuthenticatorConfiguration.get().getAuthenticators().add((Object)authenticator);
        try {
            this.r.buildAndAssertSuccess(prj);
        }
        catch (Exception e) {
            FreeStyleBuild build = (FreeStyleBuild)prj.getLastBuild();
            if (build != null) {
                System.out.println(JenkinsRule.getLog((Run)build));
            }
            throw e;
        }
    }

    @Test
    public void given_nestedFolderAndSystemCredentials_when_builtAsUserWithUseItem_then_folderCredentialFound() throws Exception {
        SystemCredentialsProvider.getInstance().getCredentials().add(new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "foo-manchu", "You don't want me", "bar", "fly"));
        Folder f = this.createFolder();
        CredentialsStore folderStore = this.getFolderStore(f);
        folderStore.addCredentials(Domain.global(), (Credentials)new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "foo-manchu", "Prof. Xavier", "prof", "xavier"));
        Folder child = (Folder)f.createProject(Folder.class, "child");
        this.getFolderStore(child).addCredentials(Domain.global(), (Credentials)new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "foo-manchu", "Dr. Fu Manchu", "foo", "manchu"));
        FreeStyleProject prj = (FreeStyleProject)child.createProject(FreeStyleProject.class, "job");
        prj.getBuildersList().add((Object)new HasCredentialBuilder("foo-manchu", Matchers.hasProperty((String)"username", (Matcher)Matchers.is((Object)"foo"))));
        JenkinsRule.DummySecurityRealm realm = this.r.createDummySecurityRealm();
        this.r.jenkins.setSecurityRealm((SecurityRealm)realm);
        MockAuthorizationStrategy strategy = new MockAuthorizationStrategy();
        strategy.grant(new Permission[]{CredentialsProvider.USE_ITEM}).everywhere().to(new String[]{"bob"});
        strategy.grant(new Permission[]{Item.BUILD}).everywhere().to(new String[]{"bob"});
        strategy.grant(new Permission[]{Computer.BUILD}).everywhere().to(new String[]{"bob"});
        this.r.jenkins.setAuthorizationStrategy((AuthorizationStrategy)strategy);
        MockQueueItemAuthenticator authenticator = new MockQueueItemAuthenticator().authenticate(prj.getFullName(), User.getById((String)"bob", (boolean)true).impersonate2());
        QueueItemAuthenticatorConfiguration.get().getAuthenticators().clear();
        QueueItemAuthenticatorConfiguration.get().getAuthenticators().add((Object)authenticator);
        try {
            this.r.buildAndAssertSuccess(prj);
        }
        catch (Exception e) {
            FreeStyleBuild build = (FreeStyleBuild)prj.getLastBuild();
            if (build != null) {
                System.out.println(JenkinsRule.getLog((Run)build));
            }
            throw e;
        }
    }

    @Test
    public void cannotUpdateCredentialsId() throws Exception {
        UsernamePasswordCredentialsImpl cred1 = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "cred1", "Cred 1", "foo", "bar");
        UsernamePasswordCredentialsImpl cred2 = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "cred2", "Cred 2", "fee", "baz");
        Folder f = this.createFolder();
        CredentialsStore folderStore = this.getFolderStore(f);
        folderStore.addCredentials(Domain.global(), (Credentials)cred1);
        Assert.assertThrows(IllegalArgumentException.class, () -> folderStore.updateCredentials(Domain.global(), (Credentials)cred1, (Credentials)cred2));
    }

    private CredentialsStore getFolderStore(Folder f) {
        Iterable stores = CredentialsProvider.lookupStores((ModelObject)f);
        CredentialsStore folderStore = null;
        for (CredentialsStore s : stores) {
            if (!(s.getProvider() instanceof FolderCredentialsProvider) || s.getContext() != f) continue;
            folderStore = s;
            break;
        }
        return folderStore;
    }

    private Folder createFolder() throws IOException {
        return (Folder)this.r.jenkins.createProject(Folder.class, "folder" + this.r.jenkins.getItems().size());
    }

    private static class HasCredentialBuilder
    extends TestBuilder {
        private final String id;
        private final Matcher<?> matcher;

        HasCredentialBuilder(String id) {
            this(id, null);
        }

        HasCredentialBuilder(String id, Matcher<?> matcher) {
            this.id = id;
            this.matcher = matcher;
        }

        public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
            IdCredentials credentials = CredentialsProvider.findCredentialById((String)this.id, IdCredentials.class, build);
            if (credentials == null) {
                listener.getLogger().printf("Could not find any credentials with id %s%n", this.id);
                build.setResult(Result.FAILURE);
                return false;
            }
            listener.getLogger().printf("Found %s credentials with id %s%n", CredentialsNameProvider.name((Credentials)credentials), this.id);
            if (this.matcher != null) {
                if (this.matcher.matches((Object)credentials)) {
                    listener.getLogger().println("Credentials match criteria");
                } else {
                    StringDescription description = new StringDescription();
                    this.matcher.describeMismatch((Object)credentials, (Description)description);
                    listener.getLogger().println(description.toString());
                    return false;
                }
            }
            return true;
        }
    }
}

