/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.health;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.hudson.plugins.folder.health.NamedChildHealthMetric;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class NamedChildHealthMetricTest {
    @Rule
    public JenkinsRule j = new JenkinsRule();

    @Test
    public void childExists() throws Exception {
        Folder folder = (Folder)this.j.jenkins.createProject(Folder.class, "myFolder");
        folder.createProject(Folder.class, "mySubFolder");
        folder.getHealthMetrics().add((Object)new NamedChildHealthMetric("mySubFolder"));
        List reports = folder.getBuildHealthReports();
        MatcherAssert.assertThat((String)"report should be available for existing child", (Object)reports, (Matcher)IsCollectionWithSize.hasSize((int)1));
    }

    @Test
    public void childDoesNotExist() throws Exception {
        Folder folder = (Folder)this.j.jenkins.createProject(Folder.class, "myFolder");
        folder.createProject(Folder.class, "mySubFolder");
        folder.getHealthMetrics().add((Object)new NamedChildHealthMetric("doesnotexist"));
        List reports = folder.getBuildHealthReports();
        MatcherAssert.assertThat((String)"report should not contain report for non-existent child", (Object)reports, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void nestedChild() throws Exception {
        Folder folder = (Folder)this.j.jenkins.createProject(Folder.class, "myFolder");
        Folder subFolder = (Folder)folder.createProject(Folder.class, "mySubFolder");
        subFolder.createProject(Folder.class, "nestedFolder");
        folder.getHealthMetrics().add((Object)new NamedChildHealthMetric("mySubFolder/nestedFolder"));
        List reports = folder.getBuildHealthReports();
        MatcherAssert.assertThat((String)"report should not contain report for nested child", (Object)reports, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }
}

