/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.simplediskusage;

import hudson.FilePath;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class UsageComputation {
    private static final FilePath CHECK_FILE = new FilePath(Jenkins.get().getRootPath(), "simpleDiskUsageCheck");
    private final Map<Path, CompletionListener> listenerMap;
    private final List<Path> pathsToScan;
    private static final Logger logger = Logger.getLogger(UsageComputation.class.getName());

    public UsageComputation(List<Path> pathsToScan) {
        this.pathsToScan = pathsToScan;
        this.listenerMap = new HashMap<Path, CompletionListener>();
    }

    public void addListener(Path path, CompletionListener listener) {
        this.listenerMap.put(path.toAbsolutePath(), listener);
    }

    public int getItemsCount() {
        return this.listenerMap.size();
    }

    public void compute() throws IOException {
        for (Path path : this.pathsToScan) {
            this.computeUsage(path.toAbsolutePath());
        }
    }

    public void computeFS() {
        for (Path path : this.pathsToScan) {
            try {
                Path dir = path.toAbsolutePath();
                long pathDiskUsage = this.jenkinsFSUsage();
                CompletionListener listener = this.listenerMap.get(dir);
                if (listener == null) continue;
                listener.onCompleted(dir, pathDiskUsage, 0L);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "cloudbees-disk-usage-plugin: FS information could not get acquired.");
            }
        }
    }

    protected long jenkinsFSUsage() {
        File rd = Jenkins.get().getRootDir();
        long totalJenkins = rd.getTotalSpace();
        long usableJenkins = rd.getUsableSpace();
        if (usableJenkins <= 0L || totalJenkins <= 0L) {
            logger.log(Level.WARNING, "cloudbees-disk-usage-plugin: JENKINS_HOME disk usage information isn't available.");
            return -1L;
        }
        return totalJenkins - usableJenkins;
    }

    protected void computeUsage(Path path) throws IOException {
        final AtomicLong chunkStartTime = new AtomicLong(System.currentTimeMillis());
        final AtomicLong writableLastCheckTime = new AtomicLong(System.currentTimeMillis());
        final Stack<AtomicLong> computeStack = new Stack<AtomicLong>();
        final Stack<AtomicLong> counterStack = new Stack<AtomicLong>();
        computeStack.push(new AtomicLong(0L));
        counterStack.push(new AtomicLong(0L));
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){
            final /* synthetic */ UsageComputation this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                computeStack.push(new AtomicLong(0L));
                counterStack.push(new AtomicLong(0L));
                if (System.currentTimeMillis() - writableLastCheckTime.get() > 10000L) {
                    writableLastCheckTime.set(System.currentTimeMillis());
                    try {
                        CHECK_FILE.touch(System.currentTimeMillis());
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.WARNING, "Exception while touching the checkfile", e);
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                ((AtomicLong)computeStack.peek()).addAndGet(attrs.size());
                ((AtomicLong)counterStack.peek()).getAndIncrement();
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                long runTimeInMillis;
                if (exc != null) {
                    logger.log(Level.WARNING, "Exception thrown while walking {}: {}", new Object[]{dir, exc});
                }
                if ((runTimeInMillis = System.currentTimeMillis() - chunkStartTime.get()) > 100L) {
                    try {
                        Thread.sleep(runTimeInMillis);
                        chunkStartTime.set(System.currentTimeMillis());
                    }
                    catch (InterruptedException e) {
                        return FileVisitResult.TERMINATE;
                    }
                }
                long pathDiskUsage = ((AtomicLong)computeStack.pop()).get();
                long pathFileCount = ((AtomicLong)counterStack.pop()).get();
                CompletionListener listener = this.this$0.listenerMap.get(dir);
                if (listener != null) {
                    listener.onCompleted(dir, pathDiskUsage, pathFileCount);
                }
                ((AtomicLong)computeStack.peek()).addAndGet(pathDiskUsage);
                ((AtomicLong)counterStack.peek()).addAndGet(pathFileCount);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static interface CompletionListener {
        public void onCompleted(Path var1, long var2, long var4);
    }
}

