/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.simplediskusage;

import com.cloudbees.simplediskusage.DiskItem;
import com.cloudbees.simplediskusage.JobDiskItem;
import com.cloudbees.simplediskusage.UsageComputation;
import hudson.Extension;
import hudson.Plugin;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.model.Job;
import hudson.model.TopLevelItem;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.NamingThreadFactory;
import jakarta.inject.Singleton;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Singleton
public class QuickDiskUsagePlugin
extends Plugin {
    public static final int QUIET_PERIOD = 900000;
    private static final Executor singleExecutorService = Executors.newSingleThreadExecutor((ThreadFactory)new NamingThreadFactory(Executors.defaultThreadFactory(), "Simple disk usage computation"));
    private static final Logger logger = Logger.getLogger(QuickDiskUsagePlugin.class.getName());
    private final CopyOnWriteArrayList<DiskItem> directoriesUsages = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<JobDiskItem> jobsUsages = new CopyOnWriteArrayList();
    private long lastRunStart = 0L;
    private long lastRunEnd = 0L;
    private final transient AtomicInteger progress = new AtomicInteger();
    private final transient AtomicInteger total = new AtomicInteger();
    private final transient Runnable computeDiskUsage = new Runnable(){

        @Override
        public void run() {
            logger.fine("Re-estimating disk usage");
            QuickDiskUsagePlugin.this.progress.set(0);
            QuickDiskUsagePlugin.this.lastRunStart = System.currentTimeMillis();
            Jenkins jenkins = Jenkins.get();
            try (ACLContext old = ACL.as((Authentication)ACL.SYSTEM);){
                UsageComputation uc = new UsageComputation(Arrays.asList(Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), jenkins.getRootDir().toPath()));
                QuickDiskUsagePlugin.this.registerJobs(uc);
                QuickDiskUsagePlugin.this.registerDirectories(uc);
                QuickDiskUsagePlugin.this.total.set(uc.getItemsCount());
                uc.compute();
                File rootPath = QuickDiskUsagePlugin.this.getJenkinsBaseDirectory();
                UsageComputation ucfs = new UsageComputation(Arrays.asList(rootPath.toPath()));
                QuickDiskUsagePlugin.this.registerJobs(ucfs);
                QuickDiskUsagePlugin.this.registerDirectoriesFS(ucfs);
                QuickDiskUsagePlugin.this.total.set(ucfs.getItemsCount());
                ucfs.computeFS();
                logger.fine("Finished re-estimating disk usage.");
                QuickDiskUsagePlugin.this.lastRunEnd = System.currentTimeMillis();
            }
            catch (IOException | InterruptedException e) {
                logger.log(Level.WARNING, "Unable to run disk usage check", e);
                QuickDiskUsagePlugin.this.lastRunEnd = QuickDiskUsagePlugin.this.lastRunStart;
            }
            try {
                QuickDiskUsagePlugin.this.save();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to save " + String.valueOf(QuickDiskUsagePlugin.this.getConfigXml()), e);
            }
        }
    };
    private final transient Runnable computeDiskUsageOnStartup = new Runnable(){

        @Override
        public void run() {
            Jenkins jenkins = Jenkins.get();
            while (jenkins.getInitLevel() != InitMilestone.COMPLETED) {
                try {
                    logger.log(Level.FINE, "Waiting for Jenkins to be up before computing disk usage");
                    Thread.sleep(180000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            QuickDiskUsagePlugin.this.refreshData();
        }
    };

    public void start() throws Exception {
        try {
            this.load();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to load " + String.valueOf(this.getConfigXml()), e);
        }
        if (this.isRunning()) {
            this.lastRunEnd = this.lastRunStart;
        }
    }

    public void refreshData() {
        if (!this.isRunning()) {
            singleExecutorService.execute(this.computeDiskUsage);
        }
    }

    public void refreshDataOnStartup() {
        singleExecutorService.execute(this.computeDiskUsageOnStartup);
    }

    public CopyOnWriteArrayList<DiskItem> getDirectoriesUsages() throws IOException {
        if (System.currentTimeMillis() - this.lastRunEnd >= 900000L) {
            this.refreshData();
        }
        return this.directoriesUsages;
    }

    public CopyOnWriteArrayList<JobDiskItem> getJobsUsages() throws IOException {
        if (System.currentTimeMillis() - this.lastRunEnd >= 900000L) {
            this.refreshData();
        }
        return this.jobsUsages;
    }

    public long getLastRunStart() {
        return this.lastRunStart;
    }

    public long getLastRunEnd() {
        return this.lastRunEnd;
    }

    public String getSince() {
        return Util.getPastTimeString((long)(System.currentTimeMillis() - this.lastRunEnd));
    }

    public String getDuration() {
        return Util.getTimeSpanString((long)(this.lastRunEnd - this.lastRunStart));
    }

    public boolean isRunning() {
        return this.lastRunEnd < this.lastRunStart;
    }

    @RequirePOST
    public void doRefresh(StaplerRequest2 req, StaplerResponse2 res) throws IOException, ServletException {
        this.refreshData();
        res.forwardToPreviousPage(req);
    }

    @RequirePOST
    public void doClean(StaplerRequest2 req, StaplerResponse2 res) throws IOException, ServletException {
        Jenkins jenkins = Jenkins.get();
        final Job job = (Job)jenkins.getItemByFullName(req.getParameter("job"), Job.class);
        Timer.get().submit(new Runnable(){
            final /* synthetic */ QuickDiskUsagePlugin this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    job.logRotate();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "logRotate failed", e);
                }
            }
        });
        res.forwardToPreviousPage(req);
    }

    private void registerJobs(UsageComputation uc) throws IOException, InterruptedException {
        Jenkins jenkins = Jenkins.get();
        for (JobDiskItem item : this.jobsUsages) {
            if (item.getPath().exists() && jenkins.getItemByFullName(item.getFullName(), Job.class) != null) continue;
            this.jobsUsages.remove(item);
        }
        for (Job job : jenkins.getAllItems(Job.class)) {
            if (!(job instanceof TopLevelItem)) continue;
            uc.addListener(job.getRootDir().toPath(), new JobUsageListener(job));
        }
    }

    private File getJenkinsBaseDirectory() throws NullPointerException {
        Jenkins jenkins = Jenkins.get();
        Path basePath = jenkins.getRootDir().toPath();
        try {
            while (basePath.getParent() != null) {
                basePath = basePath.getParent();
            }
        }
        catch (NullPointerException e) {
            logger.log(Level.WARNING, "cloudbees-disk-usage-plugin: Could not find Jenkins Base Directory");
        }
        return basePath.toFile();
    }

    private void registerDirectoriesFS(UsageComputation uc) throws IOException, InterruptedException {
        HashMap<File, String> directoriesToProcess = new HashMap<File, String>();
        File rootPath = this.getJenkinsBaseDirectory();
        directoriesToProcess.put(rootPath, "JENKINS_FS");
        for (Map.Entry item : directoriesToProcess.entrySet()) {
            uc.addListener(((File)item.getKey()).toPath(), new DirectoryUsageListener((String)item.getValue()));
        }
    }

    private void registerDirectories(UsageComputation uc) throws IOException, InterruptedException {
        Jenkins jenkins = Jenkins.get();
        HashMap<File, Object> directoriesToProcess = new HashMap<File, Object>();
        directoriesToProcess.put(jenkins.getRootDir(), "JENKINS_HOME");
        File[] jenkinsHomeRootDirectories = jenkins.getRootDir().listFiles();
        if (jenkinsHomeRootDirectories != null) {
            for (File child : jenkinsHomeRootDirectories) {
                if (!child.isDirectory()) continue;
                directoriesToProcess.put(child, "JENKINS_HOME/" + child.getName());
            }
        }
        directoriesToProcess.put(new File(System.getProperty("java.io.tmpdir")), "java.io.tmpdir");
        for (DiskItem diskItem : this.directoriesUsages) {
            if (diskItem.getPath().exists() && directoriesToProcess.containsKey(diskItem.getPath())) continue;
            this.directoriesUsages.remove(diskItem);
        }
        for (Map.Entry entry : directoriesToProcess.entrySet()) {
            uc.addListener(((File)entry.getKey()).toPath(), new DirectoryUsageListener((String)entry.getValue()));
        }
    }

    public int getItemsCount() {
        return this.total.intValue();
    }

    public int getProgress() {
        return this.progress.intValue();
    }

    class JobUsageListener
    implements UsageComputation.CompletionListener {
        final Job<?, ?> job;

        JobUsageListener(Job<?, ?> job) {
            this.job = job;
        }

        @Deprecated
        public void onCompleted(Path dir, long usage) {
            this.onCompleted(dir, usage, 0L);
        }

        @Override
        public void onCompleted(Path dir, long usage, long count) {
            JobDiskItem jobDiskItem = new JobDiskItem(this.job, usage / 1024L, (Long)count);
            QuickDiskUsagePlugin.this.jobsUsages.remove(jobDiskItem);
            QuickDiskUsagePlugin.this.jobsUsages.add(jobDiskItem);
            QuickDiskUsagePlugin.this.progress.incrementAndGet();
        }
    }

    class DirectoryUsageListener
    implements UsageComputation.CompletionListener {
        final String displayName;

        DirectoryUsageListener(String displayName) {
            this.displayName = displayName;
        }

        public void onCompleted(Path dir, long usage) {
            this.onCompleted(dir, usage, 0L);
        }

        @Override
        public void onCompleted(Path dir, long usage, long count) {
            DiskItem diskItem = new DiskItem(this.displayName, dir.toFile(), usage / 1024L, count);
            QuickDiskUsagePlugin.this.directoriesUsages.remove(diskItem);
            QuickDiskUsagePlugin.this.directoriesUsages.add(diskItem);
            QuickDiskUsagePlugin.this.progress.incrementAndGet();
        }
    }
}

