/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.simplediskusage;

import java.io.File;
import java.util.Objects;

public class DiskItem
implements Comparable<DiskItem> {
    private final String displayName;
    private final File path;
    private final Long usage;
    private final Long count;

    public DiskItem(String displayName, File path, Long usage, Long count) {
        this.displayName = displayName;
        this.path = path;
        this.usage = usage;
        this.count = count;
    }

    @Deprecated
    public DiskItem(String displayName, File path, Long usage) {
        this(displayName, path, usage, 0L);
    }

    public File getPath() {
        return this.path;
    }

    public Long getUsage() {
        return this.usage;
    }

    public Long getCount() {
        return this.count;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUsageInMB() {
        float mbValue = (float)this.usage.longValue() / 1024.0f;
        return String.format("%.1f", Float.valueOf(mbValue));
    }

    @Override
    public int compareTo(DiskItem o) {
        return Objects.compare(this.getDisplayName() != null ? this.getDisplayName() : "", o != null && o.getDisplayName() != null ? o.getDisplayName() : "", String.CASE_INSENSITIVE_ORDER);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiskItem diskItem = (DiskItem)o;
        return Objects.equals(this.getPath(), diskItem.getPath());
    }

    public int hashCode() {
        return Objects.hash(this.getPath());
    }
}

