/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cloudstats;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.ModelObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jenkinsci.plugins.cloudstats.PhaseExecutionAttachment;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public final class PhaseExecution
implements ModelObject {
    @NonNull
    private final List<PhaseExecutionAttachment> attachments = new CopyOnWriteArrayList<PhaseExecutionAttachment>();
    private final long started;
    @NonNull
    private final ProvisioningActivity.Phase phase;

    PhaseExecution(@NonNull ProvisioningActivity.Phase phase) {
        this(phase, System.currentTimeMillis());
    }

    PhaseExecution(@NonNull ProvisioningActivity.Phase phase, long started) {
        this.started = started;
        this.phase = phase;
    }

    @NonNull
    public List<PhaseExecutionAttachment> getAttachments() {
        return Collections.unmodifiableList(this.attachments);
    }

    @NonNull
    public <T extends PhaseExecutionAttachment> List<T> getAttachments(@NonNull Class<T> type) {
        ArrayList<PhaseExecutionAttachment> out = new ArrayList<PhaseExecutionAttachment>();
        for (PhaseExecutionAttachment attachment : this.getAttachments()) {
            if (!type.isInstance(attachment)) continue;
            out.add((PhaseExecutionAttachment)type.cast(attachment));
        }
        return out;
    }

    @NonNull
    public ProvisioningActivity.Status getStatus() {
        ProvisioningActivity.Status status = ProvisioningActivity.Status.OK;
        for (PhaseExecutionAttachment a : this.getAttachments()) {
            if (a.getStatus().ordinal() <= status.ordinal()) continue;
            status = a.getStatus();
        }
        return status;
    }

    @NonNull
    public Date getStarted() {
        return new Date(this.started);
    }

    public long getStartedTimestamp() {
        return this.started;
    }

    @NonNull
    public ProvisioningActivity.Phase getPhase() {
        return this.phase;
    }

    @NonNull
    public String getDisplayName() {
        return this.phase.toString();
    }

    @Restricted(value={NoExternalUse.class})
    void attach(@NonNull PhaseExecutionAttachment phaseExecutionAttachment) {
        this.attachments.add(phaseExecutionAttachment);
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public String getUrlName(@NonNull PhaseExecutionAttachment attachment) {
        String urlName = attachment.getUrlName();
        if (urlName == null) {
            return null;
        }
        if (!this.attachments.contains(attachment)) {
            throw new IllegalArgumentException("Attachment not present in current execution");
        }
        int cntr = 0;
        for (PhaseExecutionAttachment a : this.attachments) {
            if (a.equals(attachment)) break;
            if (!urlName.equals(a.getUrlName())) continue;
            ++cntr;
        }
        if (cntr > 0) {
            return "attachment/" + urlName + ":" + cntr;
        }
        return "attachment/" + urlName;
    }

    @Restricted(value={DoNotUse.class})
    public PhaseExecutionAttachment getAttachment(String urlName) {
        int n = 0;
        int i = urlName.lastIndexOf(58);
        if (i != -1) {
            try {
                n = Integer.parseInt(urlName.substring(i + 1));
                urlName = urlName.substring(0, i);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n > this.attachments.size()) {
            return null;
        }
        int cntr = 0;
        for (PhaseExecutionAttachment a : this.attachments) {
            if (!urlName.equals(a.getUrlName())) continue;
            if (cntr == n) {
                return a;
            }
            ++cntr;
        }
        return null;
    }
}

