/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cloudstats;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.Extension;
import hudson.FilePath;
import hudson.XmlFile;
import hudson.model.Computer;
import hudson.model.Label;
import hudson.model.ManagementLink;
import hudson.model.Node;
import hudson.model.PeriodicWork;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.security.Permission;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.Cloud;
import hudson.slaves.CloudProvisioningListener;
import hudson.slaves.ComputerListener;
import hudson.slaves.NodeProvisioner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;
import jenkins.model.Jenkins;
import jenkins.model.NodeListener;
import jenkins.util.Timer;
import org.jenkinsci.plugins.cloudstats.ActivityIndex;
import org.jenkinsci.plugins.cloudstats.CyclicThreadSafeCollection;
import org.jenkinsci.plugins.cloudstats.PhaseExecution;
import org.jenkinsci.plugins.cloudstats.PhaseExecutionAttachment;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedItem;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerProxy;

@Extension
public class CloudStatistics
extends ManagementLink
implements Saveable,
StaplerProxy {
    private static final Logger LOGGER = Logger.getLogger(CloudStatistics.class.getName());
    static final String ARCHIVE_RECORDS_PROPERTY_NAME = "org.jenkinsci.plugins.cloudstats.CloudStatistics.ARCHIVE_RECORDS";
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Not final for testing")
    public static int ARCHIVE_RECORDS = Integer.getInteger("org.jenkinsci.plugins.cloudstats.CloudStatistics.ARCHIVE_RECORDS", 100);
    @GuardedBy(value="active")
    @NonNull
    private Collection<ProvisioningActivity> active = new CopyOnWriteArrayList<ProvisioningActivity>();
    @GuardedBy(value="active")
    @NonNull
    private CyclicThreadSafeCollection<ProvisioningActivity> log = new CyclicThreadSafeCollection(ARCHIVE_RECORDS);
    private static final Set<Class> loggedUnsupportedTypes = Collections.synchronizedSet(new HashSet());

    @NonNull
    public static CloudStatistics get() {
        return (CloudStatistics)((Object)Jenkins.getInstance().getExtensionList(CloudStatistics.class).get(0));
    }

    @Restricted(value={NoExternalUse.class})
    public CloudStatistics() {
        try {
            this.load();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to load stored statistics", e);
        }
        for (ProvisioningActivity activity : this.getActivities()) {
            if (activity.getCurrentPhase() != ProvisioningActivity.Phase.PROVISIONING) continue;
            PhaseExecutionAttachment attachment = new PhaseExecutionAttachment(ProvisioningActivity.Status.OK, "Provisioning interrupted by restart");
            activity.enter(ProvisioningActivity.Phase.COMPLETED);
            this.attach(activity, ProvisioningActivity.Phase.COMPLETED, attachment);
            this.archive(activity);
            LOGGER.info("Closing dangling provisioning activity " + String.valueOf(activity));
        }
    }

    public String getDisplayName() {
        return "Cloud Statistics";
    }

    public String getIconFileName() {
        Jenkins jenkins = Jenkins.get();
        if (!jenkins.hasPermission(this.getRequiredPermission())) {
            return null;
        }
        if (jenkins.clouds.isEmpty() && this.isEmpty()) {
            return null;
        }
        return "symbol-analytics";
    }

    @NonNull
    public Permission getRequiredPermission() {
        return Jenkins.SYSTEM_READ;
    }

    public Object getTarget() {
        Jenkins.get().checkPermission(this.getRequiredPermission());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEmpty() {
        Collection<ProvisioningActivity> collection = this.active;
        synchronized (collection) {
            return this.log.isEmpty() && this.active.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Collection<ProvisioningActivity> getNotCompletedActivities() {
        ArrayList<ProvisioningActivity> activeCopy;
        Collection<ProvisioningActivity> collection = this.active;
        synchronized (collection) {
            activeCopy = new ArrayList<ProvisioningActivity>(this.active);
        }
        ArrayList<ProvisioningActivity> ret = new ArrayList<ProvisioningActivity>(activeCopy.size());
        for (ProvisioningActivity activity : activeCopy) {
            if (activity.getCurrentPhase() == ProvisioningActivity.Phase.COMPLETED) continue;
            ret.add(activity);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NonNull
    Collection<ProvisioningActivity> getRetainedActivities() {
        Collection<ProvisioningActivity> collection = this.active;
        synchronized (collection) {
            return new ArrayList<ProvisioningActivity>(this.active);
        }
    }

    public String getUrlName() {
        return "cloud-stats";
    }

    public String getDescription() {
        return "Report of current and past provisioning activities";
    }

    public String getCategoryName() {
        return "STATUS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProvisioningActivity> getActivities() {
        Collection<ProvisioningActivity> collection = this.active;
        synchronized (collection) {
            ArrayList<ProvisioningActivity> out = new ArrayList<ProvisioningActivity>(this.active.size() + this.log.size());
            out.addAll(this.log.toList());
            out.addAll(this.active);
            return out;
        }
    }

    @CheckForNull
    public ProvisioningActivity getPotentiallyCompletedActivityFor(ProvisioningActivity.Id id) {
        if (id == null) {
            return null;
        }
        for (ProvisioningActivity activity : this.getActivities()) {
            if (!activity.isFor(id)) continue;
            return activity;
        }
        return null;
    }

    @CheckForNull
    public ProvisioningActivity getActivityFor(ProvisioningActivity.Id id) {
        ProvisioningActivity activity = this.getPotentiallyCompletedActivityFor(id);
        if (activity != null) {
            return activity;
        }
        LOGGER.log(Level.WARNING, "No activity tracked for " + String.valueOf(id), new IllegalStateException());
        return null;
    }

    @CheckForNull
    public ProvisioningActivity getActivityFor(TrackedItem item) {
        ProvisioningActivity.Id id = item.getId();
        if (id == null) {
            return null;
        }
        return this.getActivityFor(id);
    }

    public ActivityIndex getIndex() {
        return new ActivityIndex(this.getActivities());
    }

    @Restricted(value={NoExternalUse.class})
    public ProvisioningActivity getActivity(@NonNull String hashString) {
        int hash;
        try {
            hash = Integer.parseInt(hashString);
        }
        catch (NumberFormatException nan) {
            return null;
        }
        for (ProvisioningActivity activity : this.getActivities()) {
            if (activity.getId().getFingerprint() != hash) continue;
            return activity;
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public String getUrl(@NonNull ProvisioningActivity activity, @NonNull PhaseExecution phaseExecution, @NonNull PhaseExecutionAttachment attachment) {
        activity.getClass();
        phaseExecution.getClass();
        attachment.getClass();
        if (attachment.getUrlName() == null) {
            return null;
        }
        StringBuilder url = new StringBuilder("/cloud-stats/");
        url.append("activity/").append(activity.getId().getFingerprint()).append('/');
        url.append("phase/").append(phaseExecution.getPhase().toString()).append('/');
        url.append(phaseExecution.getUrlName(attachment)).append('/');
        return url.toString();
    }

    public void attach(@NonNull ProvisioningActivity activity, @NonNull ProvisioningActivity.Phase phase, @NonNull PhaseExecutionAttachment attachment) {
        boolean entered;
        activity.attach(phase, attachment);
        if (attachment.getStatus() == ProvisioningActivity.Status.FAIL && (entered = activity.enterIfNotAlready(ProvisioningActivity.Phase.COMPLETED))) {
            this.archive(activity);
        }
        this.persist();
    }

    public void save() throws IOException {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        this.getConfigFile().write((Object)this);
    }

    void persist() {
        try {
            this.save();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to store cloud statistics", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        XmlFile file = this.getConfigFile();
        if (file.exists()) {
            file.unmarshal((Object)this);
        }
        boolean changed = false;
        Collection<ProvisioningActivity> collection = this.active;
        synchronized (collection) {
            if (this.active.isEmpty()) {
                List<ProvisioningActivity> toSort = this.log.toList();
                this.log.clear();
                for (ProvisioningActivity activity : toSort) {
                    assert (activity != null);
                    if (activity.getPhaseExecution(ProvisioningActivity.Phase.COMPLETED) == null) {
                        this.active.add(activity);
                        changed = true;
                        continue;
                    }
                    this.log.add(activity);
                }
            }
        }
        collection = this.active;
        synchronized (collection) {
            Collection<ProvisioningActivity> defensiveCopyOfActiveField = this.getRetainedActivities();
            for (ProvisioningActivity pa : defensiveCopyOfActiveField) {
                if (pa.getCurrentPhase() != ProvisioningActivity.Phase.COMPLETED) continue;
                this.active.remove(pa);
                this.log.add(pa);
                changed = true;
            }
        }
        if (changed) {
            this.persist();
        }
    }

    private Object readResolve() {
        if (!(this.active instanceof CopyOnWriteArrayList)) {
            Collection<ProvisioningActivity> a = this.active;
            this.active = new CopyOnWriteArrayList<ProvisioningActivity>();
            this.active.addAll(a);
        }
        try {
            this.log.size();
        }
        catch (NullPointerException npe) {
            String msg = "Failed to properly deserialize cloud-stats records: ";
            this.log = new CyclicThreadSafeCollection(ARCHIVE_RECORDS);
            FilePath configFile = new FilePath(this.getConfigFile().getFile());
            try {
                if (configFile.exists()) {
                    FilePath target = new FilePath(new File(configFile.getRemote() + ".bak-JENKINS-44929"));
                    configFile.renameTo(target);
                    LOGGER.warning(msg + " Please file a bug report attaching " + target.getRemote());
                } else {
                    LOGGER.warning(msg + " " + configFile.getRemote() + " not found");
                }
            }
            catch (IOException | InterruptedException ex) {
                LOGGER.log(Level.SEVERE, msg + " Unable to capture the old config.", ex);
            }
        }
        if (ARCHIVE_RECORDS != this.log.capacity()) {
            CyclicThreadSafeCollection<ProvisioningActivity> existing = this.log;
            this.log = new CyclicThreadSafeCollection(ARCHIVE_RECORDS);
            int added = 0;
            for (ProvisioningActivity pa : existing) {
                if (added > ARCHIVE_RECORDS) break;
                this.log.add(pa);
                ++added;
            }
        }
        return this;
    }

    XmlFile getConfigFile() {
        return new XmlFile(Jenkins.XSTREAM, new File(new File(Jenkins.getInstance().root, ((Object)((Object)this)).getClass().getCanonicalName() + ".xml").getAbsolutePath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archive(ProvisioningActivity activity) {
        Collection<ProvisioningActivity> collection = this.active;
        synchronized (collection) {
            this.log.add(activity);
            this.active.remove(activity);
        }
    }

    @CheckForNull
    private static ProvisioningActivity.Id getIdFor(NodeProvisioner.PlannedNode plannedNode) {
        if (!(plannedNode instanceof TrackedItem)) {
            CloudStatistics.logTypeNotSupported(plannedNode.getClass());
            return null;
        }
        return ((TrackedItem)plannedNode).getId();
    }

    @CheckForNull
    private static ProvisioningActivity.Id getIdFor(Node node) {
        if (node instanceof Jenkins) {
            return null;
        }
        if (!(node instanceof TrackedItem)) {
            LOGGER.info("No support for cloud-stats-plugin by " + String.valueOf(node.getClass()));
            return null;
        }
        return ((TrackedItem)node).getId();
    }

    @CheckForNull
    private static ProvisioningActivity.Id getIdFor(Computer computer) {
        if (computer instanceof Jenkins.MasterComputer) {
            return null;
        }
        if (!(computer instanceof AbstractCloudComputer)) {
            return null;
        }
        if (!(computer instanceof TrackedItem)) {
            CloudStatistics.logTypeNotSupported(computer.getClass());
            return null;
        }
        return ((TrackedItem)computer).getId();
    }

    private static void logTypeNotSupported(Class<?> type) {
        if (!loggedUnsupportedTypes.contains(type)) {
            LOGGER.info("No support for cloud-stats plugin by " + String.valueOf(type));
            loggedUnsupportedTypes.add(type);
        }
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static class SlaveCompletionDetector
    extends NodeListener {
        private final CloudStatistics stats = CloudStatistics.get();

        protected void onUpdated(@NonNull Node oldOne, @NonNull Node newOne) {
            if (oldOne.getNodeName().equals(newOne.getNodeName())) {
                return;
            }
            ProvisioningActivity.Id id = CloudStatistics.getIdFor(oldOne);
            if (id == null) {
                return;
            }
            ProvisioningActivity activity = this.stats.getActivityFor(id);
            if (activity == null) {
                return;
            }
            activity.rename(newOne.getNodeName());
            this.stats.persist();
        }

        protected void onDeleted(@NonNull Node node) {
            ProvisioningActivity.Id id = CloudStatistics.getIdFor(node);
            if (id == null) {
                return;
            }
            ProvisioningActivity activity = this.stats.getActivityFor(id);
            if (activity == null) {
                return;
            }
            boolean entered = activity.enterIfNotAlready(ProvisioningActivity.Phase.COMPLETED);
            if (entered) {
                this.stats.archive(activity);
                this.stats.persist();
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static class DanglingSlaveScavenger
    extends PeriodicWork {
        private final CloudStatistics stats = CloudStatistics.get();

        public long getRecurrencePeriod() {
            return 600000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRun() {
            ArrayList<ProvisioningActivity.Id> trackedExisting = new ArrayList<ProvisioningActivity.Id>();
            for (Computer computer : Jenkins.getInstance().getComputers()) {
                if (!(computer instanceof TrackedItem)) continue;
                TrackedItem item = (TrackedItem)computer;
                trackedExisting.add(item.getId());
            }
            ArrayList<ProvisioningActivity> completed = new ArrayList<ProvisioningActivity>();
            for (ProvisioningActivity activity : this.stats.getRetainedActivities()) {
                Map<ProvisioningActivity.Phase, PhaseExecution> executions = activity.getPhaseExecutions();
                if (executions.get((Object)ProvisioningActivity.Phase.COMPLETED) != null) {
                    completed.add(activity);
                    continue;
                }
                assert (activity.getStatus() != ProvisioningActivity.Status.FAIL);
                if (executions.get((Object)ProvisioningActivity.Phase.LAUNCHING) == null || trackedExisting.contains(activity.getId())) continue;
                activity.enter(ProvisioningActivity.Phase.COMPLETED);
                completed.add(activity);
            }
            if (!completed.isEmpty()) {
                Collection<ProvisioningActivity> collection = this.stats.active;
                synchronized (collection) {
                    this.stats.log.addAll(completed);
                    this.stats.active.removeAll(completed);
                }
                this.stats.persist();
            }
        }
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class OperationListener
    extends ComputerListener {
        private final CloudStatistics stats = CloudStatistics.get();

        public void preLaunch(Computer c, TaskListener taskListener) {
            ProvisioningActivity.Id id = CloudStatistics.getIdFor(c);
            if (id == null) {
                return;
            }
            ProvisioningActivity activity = this.stats.getActivityFor(id);
            if (activity == null) {
                return;
            }
            boolean entered = activity.enterIfNotAlready(ProvisioningActivity.Phase.LAUNCHING);
            if (entered) {
                this.stats.persist();
            }
        }

        public void onLaunchFailure(Computer c, TaskListener taskListener) {
            ProvisioningActivity.Id id = CloudStatistics.getIdFor(c);
            if (id == null) {
                return;
            }
            ProvisioningActivity activity = this.stats.getActivityFor(id);
            if (activity == null) {
                return;
            }
        }

        public void onOnline(Computer c, TaskListener listener) {
            ProvisioningActivity.Id id = CloudStatistics.getIdFor(c);
            if (id == null) {
                return;
            }
            ProvisioningActivity activity = this.stats.getActivityFor(id);
            if (activity == null) {
                return;
            }
            boolean entered = activity.enterIfNotAlready(ProvisioningActivity.Phase.OPERATING);
            if (entered) {
                this.stats.persist();
            }
        }
    }

    @Extension
    public static class ProvisioningListener
    extends CloudProvisioningListener {
        private final CloudStatistics stats = CloudStatistics.get();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Restricted(value={DoNotUse.class})
        public void onStarted(Cloud cloud, Label label, Collection<NodeProvisioner.PlannedNode> plannedNodes) {
            BulkChange change = new BulkChange((Saveable)this.stats);
            try {
                boolean changed = false;
                for (NodeProvisioner.PlannedNode plannedNode : plannedNodes) {
                    ProvisioningActivity.Id id = CloudStatistics.getIdFor(plannedNode);
                    if (id == null) continue;
                    this.onStarted(id);
                    changed = true;
                }
                if (changed) {
                    this.stats.persist();
                }
            }
            finally {
                change.abort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public ProvisioningActivity onStarted(@NonNull ProvisioningActivity.Id id) {
            ProvisioningActivity activity = new ProvisioningActivity(id);
            Collection<ProvisioningActivity> collection = this.stats.active;
            synchronized (collection) {
                this.stats.active.add(activity);
            }
            this.stats.persist();
            return activity;
        }

        @Restricted(value={DoNotUse.class})
        public void onComplete(NodeProvisioner.PlannedNode plannedNode, Node node) {
            ProvisioningActivity.Id id = CloudStatistics.getIdFor(plannedNode);
            if (id != null) {
                Timer.get().schedule(() -> this.onComplete(id, node), 0L, TimeUnit.SECONDS);
            }
        }

        @CheckForNull
        public ProvisioningActivity onComplete(@NonNull ProvisioningActivity.Id id, @NonNull Node node) {
            ProvisioningActivity activity = this.stats.getActivityFor(id);
            if (activity != null) {
                activity.rename(node.getDisplayName());
                this.stats.persist();
            }
            return activity;
        }

        @Restricted(value={DoNotUse.class})
        public void onFailure(NodeProvisioner.PlannedNode plannedNode, Throwable t) {
            ProvisioningActivity.Id id = CloudStatistics.getIdFor(plannedNode);
            if (id != null) {
                Timer.get().schedule(() -> this.onFailure(id, t), 0L, TimeUnit.SECONDS);
            }
        }

        @CheckForNull
        public ProvisioningActivity onFailure(@NonNull ProvisioningActivity.Id id, @NonNull Throwable throwable) {
            ProvisioningActivity activity = this.stats.getActivityFor(id);
            if (activity != null) {
                this.stats.attach(activity, ProvisioningActivity.Phase.PROVISIONING, new PhaseExecutionAttachment.ExceptionAttachment(ProvisioningActivity.Status.FAIL, throwable));
            }
            return activity;
        }

        public static ProvisioningListener get() {
            return (ProvisioningListener)((Object)Jenkins.getInstance().getExtensionList(ProvisioningListener.class).get(0));
        }
    }
}

