/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cloudstats;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.cloudstats.Health;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;

public final class ActivityIndex {
    public static final List<ProvisioningActivity> EMPTY = Collections.emptyList();
    @NonNull
    private final Map<String, Collection<ProvisioningActivity>> byCloud;
    @NonNull
    private final Map<String, Map<String, Collection<ProvisioningActivity>>> byTemplate;

    public ActivityIndex(@NonNull List<ProvisioningActivity> activities) {
        HashMap<String, ArrayList<ProvisioningActivity>> byCloud = new HashMap<String, ArrayList<ProvisioningActivity>>();
        HashMap byTemplate = new HashMap();
        for (ProvisioningActivity a : activities) {
            ArrayList<ProvisioningActivity> tmpl;
            ProvisioningActivity.Id id = a.getId();
            String cloudName = id.getCloudName();
            String templateName = id.getTemplateName();
            ArrayList<ProvisioningActivity> cld = (ArrayList<ProvisioningActivity>)byCloud.get(cloudName);
            if (cld == null) {
                cld = new ArrayList<ProvisioningActivity>();
                byCloud.put(cloudName, cld);
            }
            cld.add(a);
            HashMap<String, ArrayList<ProvisioningActivity>> cl = (HashMap<String, ArrayList<ProvisioningActivity>>)byTemplate.get(cloudName);
            if (cl == null) {
                cl = new HashMap<String, ArrayList<ProvisioningActivity>>();
                byTemplate.put(cloudName, cl);
            }
            if ((tmpl = (ArrayList<ProvisioningActivity>)cl.get(templateName)) == null) {
                tmpl = new ArrayList<ProvisioningActivity>();
                cl.put(templateName, tmpl);
            }
            tmpl.add(a);
        }
        this.byCloud = Collections.unmodifiableMap(byCloud);
        this.byTemplate = Collections.unmodifiableMap(byTemplate);
    }

    @NonNull
    public Map<String, Collection<ProvisioningActivity>> byCloud() {
        return this.byCloud;
    }

    @NonNull
    public Map<String, Map<String, Collection<ProvisioningActivity>>> byTemplate() {
        return this.byTemplate;
    }

    @NonNull
    public Collection<ProvisioningActivity> forCloud(@NonNull String name) {
        Collection<ProvisioningActivity> ret = this.byCloud.get(name);
        return ret == null ? EMPTY : ret;
    }

    @NonNull
    public Collection<ProvisioningActivity> forTemplate(@NonNull String cloud, @Nullable String template) {
        Map<String, Collection<ProvisioningActivity>> forCloud = this.byTemplate.get(cloud);
        if (forCloud == null) {
            return EMPTY;
        }
        Collection<ProvisioningActivity> ret = forCloud.get(template);
        return ret == null ? EMPTY : ret;
    }

    @NonNull
    public Map<String, Health> healthByCloud() {
        HashMap<String, Health> ret = new HashMap<String, Health>(this.byCloud.size());
        for (Map.Entry<String, Collection<ProvisioningActivity>> entry : this.byCloud.entrySet()) {
            ret.put(entry.getKey(), new Health(this.filterForHealth(entry.getValue())));
        }
        return ret;
    }

    @NonNull
    public Map<String, Map<String, Health>> healthByTemplate() {
        HashMap<String, Map<String, Health>> ret = new HashMap<String, Map<String, Health>>(this.byTemplate.size());
        for (Map.Entry<String, Map<String, Collection<ProvisioningActivity>>> entry : this.byTemplate.entrySet()) {
            HashMap<String, Health> tmpltret = new HashMap<String, Health>(entry.getValue().size());
            for (Map.Entry<String, Collection<ProvisioningActivity>> template : entry.getValue().entrySet()) {
                tmpltret.put(template.getKey(), new Health(this.filterForHealth(template.getValue())));
            }
            ret.put(entry.getKey(), tmpltret);
        }
        return ret;
    }

    @NonNull
    public Health cloudHealth(@NonNull String cloud) {
        return new Health(this.filterForHealth(this.forCloud(cloud)));
    }

    @NonNull
    public Health templateHealth(@NonNull String cloud, @Nullable String template) {
        return new Health(this.filterForHealth(this.forTemplate(cloud, template)));
    }

    private Collection<ProvisioningActivity> filterForHealth(Collection<ProvisioningActivity> as) {
        ArrayList<ProvisioningActivity> samples = new ArrayList<ProvisioningActivity>(as.size());
        for (ProvisioningActivity sample : as) {
            ProvisioningActivity.Phase currentPhase = sample.getCurrentPhase();
            if (currentPhase != ProvisioningActivity.Phase.COMPLETED && currentPhase != ProvisioningActivity.Phase.OPERATING) continue;
            samples.add(sample);
        }
        return samples;
    }
}

