/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cloudstats;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Util;
import hudson.model.ModelObject;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import org.jenkinsci.plugins.cloudstats.PhaseExecution;
import org.jenkinsci.plugins.cloudstats.PhaseExecutionAttachment;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public final class ProvisioningActivity
implements ModelObject,
Comparable<ProvisioningActivity> {
    public static final String PREMATURE_COMPLETION_DETECTED = "Provisioning activity was completed before reaching OPERATING phase without reporting a problem";
    @NonNull
    private final Id id;
    @GuardedBy(value="id")
    @Nullable
    private String name;
    private final Map<Phase, PhaseExecution> progress = Collections.synchronizedMap(new LinkedHashMap(Phase.values().length));

    public ProvisioningActivity(@NonNull Id id) {
        this.progress.put(Phase.PROVISIONING, null);
        this.progress.put(Phase.LAUNCHING, null);
        this.progress.put(Phase.OPERATING, null);
        this.progress.put(Phase.COMPLETED, null);
        this.id = id;
        this.enter(new PhaseExecution(Phase.PROVISIONING));
        String name = id.nodeName;
        if (name == null) {
            name = id.templateName;
        }
        if (name == null) {
            name = id.cloudName;
        }
        this.name = name;
    }

    ProvisioningActivity(@NonNull Id id, long started) {
        this.progress.put(Phase.PROVISIONING, null);
        this.progress.put(Phase.LAUNCHING, null);
        this.progress.put(Phase.OPERATING, null);
        this.progress.put(Phase.COMPLETED, null);
        this.id = id;
        this.enter(new PhaseExecution(Phase.PROVISIONING, started));
        String name = id.nodeName;
        if (name == null) {
            name = id.templateName;
        }
        if (name == null) {
            name = id.cloudName;
        }
        this.name = name;
    }

    @NonNull
    public Id getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Date getStarted() {
        Map<Phase, PhaseExecution> map = this.progress;
        synchronized (map) {
            return this.progress.get((Object)Phase.PROVISIONING).getStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStartedTimestamp() {
        Map<Phase, PhaseExecution> map = this.progress;
        synchronized (map) {
            return this.progress.get((Object)Phase.PROVISIONING).getStartedTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public PhaseExecution getPhaseExecution(@NonNull Phase phase) {
        Map<Phase, PhaseExecution> map = this.progress;
        synchronized (map) {
            return this.progress.get((Object)phase);
        }
    }

    @NonNull
    public Map<Phase, PhaseExecution> getPhaseExecutions() {
        return Collections.unmodifiableMap(this.progress);
    }

    @NonNull
    public PhaseExecution getCurrentPhaseExecution() {
        Map<Phase, PhaseExecution> map = this.progress;
        synchronized (map) {
            PhaseExecution ex = this.progress.get((Object)Phase.COMPLETED);
            if (ex != null) {
                return ex;
            }
            ex = this.progress.get((Object)Phase.OPERATING);
            if (ex != null) {
                return ex;
            }
            ex = this.progress.get((Object)Phase.LAUNCHING);
            if (ex != null) {
                return ex;
            }
            ex = this.progress.get((Object)Phase.PROVISIONING);
            if (ex != null) {
                return ex;
            }
            throw new IllegalStateException("Unknown provisioning state of " + this.getDisplayName());
        }
    }

    @NonNull
    public Phase getCurrentPhase() {
        return this.getCurrentPhaseExecution().getPhase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Status getStatus() {
        Map<Phase, PhaseExecution> map = this.progress;
        synchronized (map) {
            Status status = Status.OK;
            for (PhaseExecution e : this.progress.values()) {
                if (e == null) continue;
                Status s = e.getStatus();
                if (status.ordinal() >= s.ordinal()) continue;
                status = s;
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enter(@NonNull Phase phase) {
        Map<Phase, PhaseExecution> map = this.progress;
        synchronized (map) {
            if (this.progress.get((Object)phase) != null) {
                throw new IllegalStateException("The phase " + String.valueOf((Object)phase) + " has already started");
            }
            Phase currentPhase = this.getCurrentPhase();
            if (currentPhase.compareTo(phase) >= 0) {
                throw new IllegalStateException("The phase " + String.valueOf((Object)this.getCurrentPhase()) + " has already started");
            }
            this.progress.put(phase, new PhaseExecution(phase));
            if (phase == Phase.COMPLETED && currentPhase != Phase.OPERATING && this.getStatus() == Status.OK) {
                PhaseExecutionAttachment attachment = new PhaseExecutionAttachment(Status.WARN, PREMATURE_COMPLETION_DETECTED);
                this.progress.get((Object)Phase.COMPLETED).attach(attachment);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enter(@NonNull PhaseExecution pe) {
        Map<Phase, PhaseExecution> map = this.progress;
        synchronized (map) {
            this.progress.put(pe.getPhase(), pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enterIfNotAlready(@NonNull Phase phase) {
        Map<Phase, PhaseExecution> map = this.progress;
        synchronized (map) {
            if (this.progress.get((Object)phase) != null || this.getCurrentPhase().compareTo(phase) >= 0) {
                return false;
            }
            this.progress.put(phase, new PhaseExecution(phase));
        }
        return true;
    }

    @Restricted(value={NoExternalUse.class})
    void attach(Phase phase, PhaseExecutionAttachment attachment) {
        PhaseExecution execution = this.getPhaseExecution(phase);
        if (execution == null) {
            throw new IllegalArgumentException("Phase " + String.valueOf((Object)phase) + " not entered yet");
        }
        execution.attach(attachment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public String getName() {
        Id id = this.id;
        synchronized (id) {
            return this.name;
        }
    }

    @NonNull
    public String getDisplayName() {
        return "Activity " + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    void rename(@NonNull String newName) {
        if (Util.fixEmptyAndTrim((String)newName) == null) {
            throw new IllegalArgumentException("Unable to rename to empty string");
        }
        Id id = this.id;
        synchronized (id) {
            this.name = newName;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public PhaseExecution getPhase(@NonNull String phaseName) {
        Phase phase = Phase.valueOf(phaseName);
        return this.getPhaseExecution(phase);
    }

    @Restricted(value={NoExternalUse.class})
    public long getDuration(@NonNull PhaseExecution execution) {
        Phase phase = execution.getPhase();
        if (phase == Phase.COMPLETED) {
            throw new IllegalArgumentException();
        }
        PhaseExecution next = null;
        for (Phase p : Phase.values()) {
            if (p.ordinal() > phase.ordinal() && (next = this.getPhaseExecution(p)) != null) break;
        }
        long started = execution.getStartedTimestamp();
        return next != null ? next.getStartedTimestamp() - started : -(System.currentTimeMillis() - started);
    }

    public boolean isFor(Id id) {
        return id.fingerprint == this.id.fingerprint;
    }

    @Override
    public int compareTo(@NonNull ProvisioningActivity o) {
        return Long.compare(o.getStartedTimestamp(), this.getStartedTimestamp());
    }

    public String toString() {
        return this.id.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        ProvisioningActivity rhs = (ProvisioningActivity)o;
        return this.id.equals(rhs.id);
    }

    public int hashCode() {
        return this.id.hashCode() * 31;
    }

    public static enum Phase {
        PROVISIONING,
        LAUNCHING,
        OPERATING,
        COMPLETED;

    }

    public static final class Id
    implements Serializable {
        @NonNull
        private final String cloudName;
        @CheckForNull
        private final String templateName;
        @CheckForNull
        private final String nodeName;
        private final int fingerprint;

        public Id(@NonNull String cloudName, @CheckForNull String templateName, @CheckForNull String nodeName) {
            this.cloudName = cloudName;
            this.templateName = templateName;
            this.nodeName = nodeName;
            this.fingerprint = System.identityHashCode(this) ^ (int)System.currentTimeMillis();
        }

        public Id(@NonNull String cloudName, @CheckForNull String templateName) {
            this(cloudName, templateName, null);
        }

        public Id(@NonNull String cloudName) {
            this(cloudName, null);
        }

        @NonNull
        public Id named(@NonNull String name) {
            return new Id(this, name);
        }

        private Id(@NonNull Id id, @NonNull String name) {
            this.cloudName = id.cloudName;
            this.templateName = id.templateName;
            this.fingerprint = id.fingerprint;
            this.nodeName = name;
        }

        @NonNull
        public String getCloudName() {
            return this.cloudName;
        }

        @CheckForNull
        public String getTemplateName() {
            return this.templateName;
        }

        @CheckForNull
        public String getNodeName() {
            return this.nodeName;
        }

        public int getFingerprint() {
            return this.fingerprint;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Id id = (Id)o;
            return this.fingerprint == id.fingerprint;
        }

        public int hashCode() {
            return Objects.hash(this.fingerprint);
        }

        public String toString() {
            return "ProvisioningActivity for %s/%s/%s (%d)".formatted(this.cloudName, this.templateName, this.nodeName, this.fingerprint);
        }
    }

    public static enum Status {
        OK,
        WARN,
        FAIL;

    }
}

