/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cloudstats;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.HealthReport;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import jenkins.util.NonLocalizable;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jvnet.localizer.Localizable;

public final class Health {
    @NonNull
    private final List<ProvisioningActivity> samples;

    public Health(@NonNull Collection<ProvisioningActivity> samples) {
        this.samples = new ArrayList<ProvisioningActivity>(samples);
        Collections.sort(this.samples);
    }

    public Report getOverall() {
        int all = this.samples.size();
        float success = 0.0f;
        for (ProvisioningActivity sample : this.samples) {
            if (sample.getStatus() == ProvisioningActivity.Status.FAIL) continue;
            success += 1.0f;
        }
        return new Report(success * 100.0f / (float)all);
    }

    public Report getCurrent() {
        if (this.samples.isEmpty()) {
            return new Report(Float.NaN);
        }
        double start = this.samples.iterator().next().getStartedTimestamp();
        double success = 1.0;
        double count = this.samples.size();
        for (ProvisioningActivity sample : this.samples) {
            if (sample.getStatus() != ProvisioningActivity.Status.FAIL) continue;
            double age = (start - (double)sample.getStartedTimestamp()) / 1000.0 / 60.0 / 60.0;
            assert ((age += 1.0) > 0.0) : "Illegal sample age " + age;
            double increment = 1.0 / (count * age);
            success -= increment;
        }
        return new Report((float)(success * 100.0));
    }

    public long getNumSamples() {
        return this.samples.size();
    }

    public static final class Report
    implements Comparable<Report> {
        private static final DecimalFormat FORMAT = new DecimalFormat("#.#'%'");
        private final float percent;

        public Report(@Nonnegative float percent) {
            this.percent = percent;
        }

        public float getPercentage() {
            return this.percent;
        }

        @Override
        public int compareTo(@NonNull Report o) {
            return Float.compare(this.percent, o.percent);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Report report = (Report)o;
            return Float.compare(report.percent, this.percent) == 0;
        }

        public int hashCode() {
            return this.percent != 0.0f ? Float.floatToIntBits(this.percent) : 0;
        }

        public String toString() {
            if (Float.isNaN(this.percent)) {
                return "?";
            }
            return FORMAT.format(this.percent);
        }

        public HealthReport getWeather() {
            return new HealthReport(Math.round(this.percent), (Localizable)new NonLocalizable("Cloud Statistics"));
        }
    }
}

