/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cloudstats;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CyclicThreadSafeCollection<E>
implements Collection<E> {
    @NonNull
    private final E[] data;
    @Nonnegative
    private int next = 0;
    @Nonnegative
    private int size = 0;

    public CyclicThreadSafeCollection(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be non-negative");
        }
        this.data = CyclicThreadSafeCollection.newArray(capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        E[] EArray = this.data;
        synchronized (this.data) {
            this.data[this.next] = e;
            this.next = (this.next + 1) % this.data.length;
            if (this.size < this.data.length) {
                ++this.size;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    @Override
    public boolean addAll(@NonNull Collection<? extends E> c) {
        for (E e : c) {
            this.add(e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        E[] EArray = this.data;
        synchronized (this.data) {
            this.next = 0;
            this.size = 0;
            Arrays.fill(this.data, null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    @NonNull
    public Iterator<E> iterator() {
        return this.toList().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnegative
    public int size() {
        E[] EArray = this.data;
        synchronized (this.data) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.size;
        }
    }

    @Nonnegative
    public int capacity() {
        return this.data.length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.toList().contains(o);
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> c) {
        return this.toList().containsAll(c);
    }

    @NonNull
    public List<E> toList() {
        return Arrays.asList(this.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public E[] toArray() {
        E[] EArray = this.data;
        synchronized (this.data) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.toArray(CyclicThreadSafeCollection.newArray(this.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public <T> T[] toArray(@NonNull T[] ret) {
        E[] EArray = this.data;
        synchronized (this.data) {
            int size = this.size();
            if (ret.length < size) {
                ret = CyclicThreadSafeCollection.newArray(size);
            } else if (ret.length > size) {
                ret[size] = null;
            }
            if (size < this.data.length) {
                System.arraycopy(this.data, 0, ret, 0, size);
            } else {
                int offset = this.data.length - this.next;
                System.arraycopy(this.data, 0, ret, offset, this.next);
                System.arraycopy(this.data, this.next, ret, 0, offset);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }

    private static <X> X[] newArray(int capacity) {
        return new Object[capacity];
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }
}

